/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.layers.Earth.USGSDigitalOrtho;
import gov.nasa.worldwind.layers.Earth.USGSUrbanAreaOrtho;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.BrowserOpener;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.sar.AnalysisPanel;
import gov.nasa.worldwindx.applications.sar.BulkDownloadFrame;
import gov.nasa.worldwindx.applications.sar.ControlPanel;
import gov.nasa.worldwindx.applications.sar.LayerMenu;
import gov.nasa.worldwindx.applications.sar.OSXAdapter;
import gov.nasa.worldwindx.applications.sar.SARAboutDialog;
import gov.nasa.worldwindx.applications.sar.SARAnnotation;
import gov.nasa.worldwindx.applications.sar.SARAnnotationSupport;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.SaveTrackDialog;
import gov.nasa.worldwindx.applications.sar.ScalebarHint;
import gov.nasa.worldwindx.applications.sar.TrackController;
import gov.nasa.worldwindx.applications.sar.TracksPanel;
import gov.nasa.worldwindx.applications.sar.UserPreferenceUtils;
import gov.nasa.worldwindx.applications.sar.ViewMenu;
import gov.nasa.worldwindx.applications.sar.WWPanel;
import gov.nasa.worldwindx.applications.sar.actions.SARScreenShotAction;
import gov.nasa.worldwindx.applications.sar.tracks.CSVTrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.CompoundFilter;
import gov.nasa.worldwindx.applications.sar.tracks.GPXTrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.NMEATrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.TrackReaderFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.w3c.dom.Document;

public class SAR2
extends JFrame {
    private TrackController trackController;
    private SARAnnotationSupport annotationSupport;
    private ScalebarHint scalebarHint;
    private WorldWindow wwd;
    private Timer redrawTimer;
    private static final int REDRAW_TIMER_DELAY = 1000;
    private ControlPanel controlPanel;
    private WWPanel wwPanel;
    private LayerMenu layerMenu;
    private ViewMenu viewLayerMenu;
    private JCheckBoxMenuItem feetMenuItem;
    private JCheckBoxMenuItem metersMenuItem;
    private JCheckBoxMenuItem angleDDMenuItem;
    private JCheckBoxMenuItem angleDMSMenuItem;
    private JButton viewExamineButton;
    private JButton viewFollowButton;
    private JButton viewFreeButton;
    private JButton extendTrackPlaneButton;
    private JButton extendTrackCursorAirButton;
    private JButton extendTrackCursorGroundButton;
    private JButton nextPointButton;
    private JButton removeLastPointButton;
    private JButton showTrackInfoButton;
    private JFileChooser openFileChooser;
    private SaveTrackDialog saveTrackDialog;
    private BulkDownloadFrame bulkDownloadFrame;
    private static final int OK = 0;
    private static final int CANCELLED = 2;
    private static final int ERROR = 4;
    public static final String UNIT_IMPERIAL = "Imperial";
    public static final String UNIT_METRIC = "Metric";
    private static final double METER_TO_FEET = 3.280839895;
    protected static final String ONLINE_HELP_URL = "http://worldwind.arc.nasa.gov/java/apps/SARApp/help/v6/SARHelp.html";
    protected static AVList userPreferences = new AVListImpl();
    private Timer autoSaveTimer;
    protected static final long MIN_AUTO_SAVE_INTERVAL = 1000L;
    private SARTrack toolbarTrack;

    public SAR2() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.initComponents();
        this.setTitle("World Wind Search and Rescue Prototype (Version 6.2 released 7/15/2010)");
        this.wwd = this.wwPanel.getWwd();
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (layer instanceof USGSDigitalOrtho) {
                layer.setOpacity(0.5);
                layer.setEnabled(false);
                continue;
            }
            if (!(layer instanceof USGSUrbanAreaOrtho)) continue;
            layer.setEnabled(false);
        }
        this.getAnalysisPanel().setWwd(this.wwd);
        this.trackController = new TrackController();
        this.trackController.setWwd(this.wwd);
        this.trackController.setTracksPanel(this.getTracksPanel());
        this.trackController.setAnalysisPanel(this.getAnalysisPanel());
        this.layerMenu.setWwd(this.wwd);
        this.viewLayerMenu.setWwd(this.wwd);
        this.annotationSupport = new SARAnnotationSupport();
        this.annotationSupport.setWwd(this.wwd);
        this.scalebarHint = new ScalebarHint();
        this.scalebarHint.setWwd(this.wwd);
        this.redrawTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.redraw();
            }
        });
        this.redrawTimer.start();
        this.wwd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("TrackViewPanel.ViewModeChange") || propertyChangeEvent.getPropertyName().equals("TrackController.TrackCurrent") || propertyChangeEvent.getPropertyName().equals("TrackController.BeginTrackPointEntry") || propertyChangeEvent.getPropertyName().equals("TrackController.EndTrackPointEntry")) {
                    SAR2.this.updateToolBar(propertyChangeEvent);
                }
            }
        });
        this.autoSaveTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.onAutoSave();
            }
        });
        this.initializeUserPreferences();
        this.loadUserPreferences();
        this.onUserPreferencesChanged();
    }

    public static void centerWindowInDesktop(Window window) {
        if (window != null) {
            int n = Toolkit.getDefaultToolkit().getScreenSize().width;
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
            int n3 = n - insets.left - insets.right;
            int n4 = n2 - insets.bottom - insets.top;
            int n5 = window.getSize().width;
            int n6 = window.getSize().height;
            if (n5 > n3) {
                n5 = Math.min(n5, n3);
            }
            if (n6 > n4) {
                n6 = Math.min(n6, n4);
            }
            window.setPreferredSize(new Dimension(n5, n6));
            window.pack();
            window.setLocation((n3 - n5) / 2 + insets.left, (n4 - n6) / 2 + insets.top);
        }
    }

    public static double metersToFeet(double d) {
        return d * 3.280839895;
    }

    public static double feetToMeters(double d) {
        return d / 3.280839895;
    }

    public String getElevationUnit() {
        return SAR2.getUserPreferences().getStringValue("ElevationUnit");
    }

    public void setElevationUnit(String string) {
        SAR2.getUserPreferences().setValue("ElevationUnit", string);
        this.saveUserPreferences();
        this.onUserPreferencesChanged();
    }

    private void elevationUnitChanged(String string, String string2) {
        if (UNIT_IMPERIAL.equals(string2)) {
            this.feetMenuItem.setSelected(true);
        } else if (UNIT_METRIC.equals(string2)) {
            this.metersMenuItem.setSelected(true);
        }
        this.getTracksPanel().setElevationUnit(string2);
        this.wwd.setValue("ElevationUnit", string2);
        this.wwd.firePropertyChange("ElevationUnit", string, string2);
        this.wwd.redraw();
    }

    public String getAngleFormat() {
        return SAR2.getUserPreferences().getStringValue("AngleFormat");
    }

    public void setAngleFormat(String string) {
        SAR2.getUserPreferences().setValue("AngleFormat", string);
        this.saveUserPreferences();
        this.onUserPreferencesChanged();
    }

    private void angleFormatChanged(String string, String string2) {
        if ("gov.nasa.worldwind.Geom.AngleDD".equals(string2)) {
            this.angleDDMenuItem.setSelected(true);
        } else if ("gov.nasa.worldwind.Geom.AngleDMS".equals(string2)) {
            this.angleDMSMenuItem.setSelected(true);
        }
        this.getTracksPanel().setAngleFormat(string2);
        this.wwd.setValue("AngleFormat", string2);
        this.wwd.firePropertyChange("AngleFormat", string, string2);
        this.wwd.redraw();
    }

    public SARTrack getCurrentTrack() {
        return this.getTracksPanel().getCurrentTrack();
    }

    public TracksPanel getTracksPanel() {
        return this.controlPanel.getTracksPanel();
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.controlPanel.getAnalysisPanel();
    }

    private void newTrack(String string) {
        Object object = JOptionPane.showInputDialog(this, "Enter a new track name", "Add New Track", 3, null, null, string);
        if (object == null) {
            return;
        }
        string = object.toString();
        SARTrack sARTrack = new SARTrack(string);
        this.trackController.addTrack(sARTrack);
        sARTrack.markDirty();
    }

    private void newTrackFromFile() {
        File[] fileArray = this.showOpenDialog("Open a track file");
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (File file : fileArray) {
            this.newTrackFromFile(file.getPath(), null);
        }
    }

    private void newTrackFromFile(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        SARTrack sARTrack = null;
        try {
            sARTrack = SARTrack.fromFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sARTrack == null) {
            return;
        }
        if (string2 != null) {
            sARTrack.setName(string2);
        }
        this.trackController.addTrack(sARTrack);
        try {
            File file = this.getAnnotationsPath(string);
            if (file != null && file.exists()) {
                this.annotationSupport.readAnnotations(file.getPath(), sARTrack);
            }
            this.restoreTrackState(new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sARTrack.clearDirtyBit();
    }

    private File[] showOpenDialog(String string) {
        FileFilter[] fileFilterArray;
        if (this.openFileChooser == null) {
            fileFilterArray = new TrackReaderFilter[]{new TrackReaderFilter(new CSVTrackReader()), new TrackReaderFilter(new GPXTrackReader()), new TrackReaderFilter(new NMEATrackReader())};
            this.openFileChooser = new JFileChooser();
            this.openFileChooser.setMultiSelectionEnabled(true);
            this.openFileChooser.setFileSelectionMode(0);
            CompoundFilter compoundFilter = new CompoundFilter(fileFilterArray, "Accepted Files");
            this.openFileChooser.addChoosableFileFilter(compoundFilter);
            for (FileFilter fileFilter : fileFilterArray) {
                this.openFileChooser.addChoosableFileFilter((javax.swing.filechooser.FileFilter)((Object)fileFilter));
            }
            this.openFileChooser.setFileFilter(compoundFilter);
        }
        if ((fileFilterArray = SAR2.getUserPreferences().getStringValue("CurrentBrowseDirectory")) != null) {
            this.openFileChooser.setCurrentDirectory(new File((String)fileFilterArray));
        }
        this.openFileChooser.setDialogTitle(string != null ? string : "Open Track");
        int n = this.openFileChooser.showOpenDialog(this);
        if (n != 0) {
            return null;
        }
        FileFilter[] fileFilterArray2 = this.openFileChooser.getCurrentDirectory();
        SAR2.getUserPreferences().setValue("CurrentBrowseDirectory", fileFilterArray2.getPath());
        this.onUserPreferencesChanged();
        this.saveUserPreferences();
        return this.openFileChooser.getSelectedFiles();
    }

    private void newTrackFromURL(String string, String string2) {
        Object object;
        if (string == null && (object = JOptionPane.showInputDialog(this, "Enter a track URL", "Add New Track", 3, null, null, null)) != null) {
            string = object.toString();
        }
        if (string == null) {
            return;
        }
        object = SAR2.makeURL(string);
        if (object == null) {
            return;
        }
        SARTrack sARTrack = null;
        try {
            ByteBuffer byteBuffer = WWIO.readURLContentToBuffer((URL)object);
            File file = WWIO.saveBufferToTempFile(byteBuffer, ".xml");
            sARTrack = SARTrack.fromFile(file.getPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (sARTrack == null) {
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        sARTrack.setFile(null);
        sARTrack.setName(string2);
        this.trackController.addTrack(sARTrack);
        sARTrack.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newTrackFromPath(String string, String string2) {
        SARTrack sARTrack = null;
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
            File file = WWIO.saveBufferToTempFile(byteBuffer, "." + WWIO.getSuffix(string));
            sARTrack = SARTrack.fromFile(file.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
        if (sARTrack == null) {
            return;
        }
        if (string2 == null) {
            string2 = WWIO.getFilename(string);
        }
        sARTrack.setFile(null);
        sARTrack.setName(string2);
        this.trackController.addTrack(sARTrack);
        sARTrack.markDirty();
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    private int removeTrack(SARTrack sARTrack, boolean bl) {
        if (sARTrack == null) {
            return 0;
        }
        int n = 0;
        if (sARTrack.isDirty() || bl) {
            int n2 = SaveTrackDialog.showSaveChangesPrompt(this, null, null, sARTrack);
            if (n2 == 0) {
                n = this.saveTrack(sARTrack, false);
            } else if (n2 == 2) {
                n = 2;
            }
        }
        if (n != 0) {
            return n;
        }
        try {
            sARTrack.firePropertyChange("TrackController.TrackRemoved", null, sARTrack);
            this.trackController.refreshCurrentTrack();
            this.annotationSupport.removeAnnotationsForTrack(sARTrack);
            this.wwd.redraw();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 4;
        }
        return 0;
    }

    private int removeAllTracks(boolean bl) {
        int n = 0;
        for (SARTrack sARTrack : this.getTracksPanel().getAllTracks()) {
            if (((n |= this.removeTrack(sARTrack, bl)) & 2) == 0) continue;
            return n;
        }
        return n;
    }

    private int saveTrack(SARTrack sARTrack, boolean bl) {
        return this.saveTrack(sARTrack, null, 0, true, bl);
    }

    private int saveTrack(SARTrack sARTrack, File file, int n, boolean bl, boolean bl2) {
        if (sARTrack == null) {
            String string = Logging.getMessage("nullValue.TrackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file == null) {
            file = sARTrack.getFile();
        }
        if (n == 0) {
            n = sARTrack.getFormat();
        }
        if (file == null || bl2) {
            int n2 = this.showSaveDialog(sARTrack, file, n);
            if (n2 == 1) {
                return 2;
            }
            if (n2 == -1) {
                return 4;
            }
            file = this.saveTrackDialog.getSelectedFile();
            n = this.saveTrackDialog.getFileFormat();
            bl = this.saveTrackDialog.isSaveAnnotations();
        }
        try {
            long l = file.exists() ? file.lastModified() : 0L;
            SARTrack.toFile(sARTrack, file.getPath(), n);
            if (bl) {
                File file2 = this.getAnnotationsPath(file.getPath());
                this.annotationSupport.writeAnnotations(file2.getPath(), sARTrack);
            }
            this.saveTrackState(file);
            if (file.exists() && l <= file.lastModified()) {
                sARTrack.setFile(file);
                sARTrack.setFormat(n);
                sARTrack.setName(file.getName());
                sARTrack.clearDirtyBit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 4;
        }
        return 0;
    }

    private void saveTrackState(File file) {
        String string = this.getRestorableState();
        File file2 = this.getTrackStateFile(file);
        WWIO.writeTextFile(string, file2);
    }

    private void restoreTrackState(File file) {
        File file2 = this.getTrackStateFile(file);
        if (!file2.exists()) {
            return;
        }
        String string = WWIO.readTextFile(file2);
        if (string != null) {
            this.restoreState(string);
        }
    }

    private File getTrackStateFile(File file) {
        String string = file.getAbsolutePath();
        return new File(string + ".sts");
    }

    private int showSaveDialog(SARTrack sARTrack, File file, int n) {
        if (this.saveTrackDialog == null) {
            this.saveTrackDialog = new SaveTrackDialog();
        }
        this.saveTrackDialog.setDialogTitle(sARTrack);
        if (file != null) {
            this.saveTrackDialog.setSelectedFile(file);
        } else {
            this.saveTrackDialog.setSelectedFile(sARTrack);
        }
        if (n != 0) {
            this.saveTrackDialog.setFileFormat(n);
        } else {
            this.saveTrackDialog.setFileFormat(sARTrack);
        }
        return this.saveTrackDialog.showSaveDialog(this);
    }

    private void bulkDownload() {
        if (this.bulkDownloadFrame == null) {
            this.bulkDownloadFrame = new BulkDownloadFrame(this.wwd);
            this.bulkDownloadFrame.setLocation(new Point(this.getLocationOnScreen().x + 100, this.getLocationOnScreen().y + 100));
        }
        this.bulkDownloadFrame.setVisible(true);
    }

    private SARAnnotation getCurrentAnnotation() {
        return this.annotationSupport.getCurrent();
    }

    private void newAnnotation() {
        this.newAnnotation(null, this.getCurrentTrack());
    }

    private void newAnnotation(String string, SARTrack sARTrack) {
        this.annotationSupport.addNew(string, sARTrack);
        this.wwd.redraw();
    }

    private void removeAnnotation(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            this.annotationSupport.remove(sARAnnotation);
        }
        this.wwd.redraw();
    }

    private void setAnnotationsEnabled(boolean bl) {
        this.annotationSupport.setEnabled(bl);
        this.wwd.redraw();
    }

    private void extendTrack(String string) {
        SARTrack sARTrack = this.trackController.getCurrentTrack();
        if (sARTrack == null) {
            return;
        }
        if (this.trackController.isExtending()) {
            sARTrack.firePropertyChange("TrackController.EndTrackPointEntry", null, string);
        } else {
            sARTrack.firePropertyChange("TrackController.BeginTrackPointEntry", null, string);
        }
    }

    public static AVList getUserPreferences() {
        return userPreferences;
    }

    public void showHelp() {
        try {
            BrowserOpener.browse(new URL(ONLINE_HELP_URL));
        }
        catch (Exception exception) {
            System.err.println("Unable to open Help window");
            exception.printStackTrace();
        }
    }

    public void showAbout() {
        SARAboutDialog sARAboutDialog = new SARAboutDialog();
        sARAboutDialog.showDialog(this);
    }

    public boolean exit() {
        int n = this.removeAllTracks(false);
        if ((n & 2) != 0) {
            return false;
        }
        this.dispose();
        System.exit(0);
        return true;
    }

    private File getAnnotationsPath(String string) {
        return string != null ? new File(string + ".sta") : null;
    }

    private void initComponents() {
        this.setTitle("World Wind Search and Rescue");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SAR2.this.exit();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SAR2.this.exit();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.controlPanel = new ControlPanel();
        this.controlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add((Component)this.controlPanel, "West");
        this.wwPanel = new WWPanel();
        this.wwPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.wwPanel.setPreferredSize(new Dimension(1000, 800));
        container.add((Component)this.wwPanel, "Center");
        SARScreenShotAction sARScreenShotAction = new SARScreenShotAction(this.wwPanel.getWwd(), (Icon)this.getIcon("24x24-snapshot.gif"));
        JMenuBar jMenuBar = new JMenuBar();
        JComponent jComponent = new JMenu();
        ((AbstractButton)jComponent).setText("File");
        ((AbstractButton)jComponent).setMnemonic('F');
        JComponent jComponent2 = new JMenuItem();
        ((AbstractButton)jComponent2).setText("New Track...");
        ((AbstractButton)jComponent2).setMnemonic('N');
        ((JMenuItem)jComponent2).setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrack(null);
            }
        });
        ((JMenu)jComponent).add((JMenuItem)jComponent2);
        Serializable serializable = new JMenuItem();
        ((AbstractButton)serializable).setText("Open Track File...");
        ((AbstractButton)serializable).setMnemonic('O');
        ((JMenuItem)serializable).setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromFile();
            }
        });
        ((JMenu)jComponent).add((JMenuItem)serializable);
        Serializable serializable2 = new JMenuItem();
        ((AbstractButton)serializable2).setText("Open Track URL...");
        ((AbstractButton)serializable2).setMnemonic('U');
        ((JMenuItem)serializable2).setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromURL(null, null);
            }
        });
        ((JMenu)jComponent).add((JMenuItem)serializable2);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText("Close Track");
        jMenuItem.setMnemonic('C');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(Configuration.isMacOS() ? 87 : 115, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.removeTrack(SAR2.this.getCurrentTrack(), false);
            }
        });
        ((JMenu)jComponent).add(jMenuItem);
        ((JMenu)jComponent).addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText("Save Track");
        jMenuItem2.setMnemonic('S');
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.saveTrack(SAR2.this.getCurrentTrack(), false);
            }
        });
        ((JMenu)jComponent).add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText("Save Track As...");
        jMenuItem3.setMnemonic('A');
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.saveTrack(SAR2.this.getCurrentTrack(), true);
            }
        });
        ((JMenu)jComponent).add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(sARScreenShotAction);
        jMenuItem4.setIcon(null);
        jMenuItem4.setMnemonic('T');
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((JMenu)jComponent).add(jMenuItem4);
        ((JMenu)jComponent).addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenuItem5.setText("Bulk download...");
        jMenuItem5.setMnemonic('B');
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.bulkDownload();
            }
        });
        ((JMenu)jComponent).add(jMenuItem5);
        ((JMenu)jComponent).addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem();
        jMenuItem6.setText("PipeTrackTest.gpx");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromPath("gov/nasa/worldwindx/applications/sar/data/PipeTrackTest.gpx", null);
            }
        });
        ((JMenu)jComponent).add(jMenuItem6);
        jMenuItem6 = new JMenuItem();
        jMenuItem6.setText("PipeTracks2.gpx");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromPath("gov/nasa/worldwindx/applications/sar/data/PipeTracks2.gpx", null);
            }
        });
        ((JMenu)jComponent).add(jMenuItem6);
        jMenuItem6 = new JMenuItem();
        jMenuItem6.setText("PipeTracks3.gpx");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromPath("gov/nasa/worldwindx/applications/sar/data/PipeTracks3.gpx", null);
            }
        });
        ((JMenu)jComponent).add(jMenuItem6);
        if (!Configuration.isMacOS()) {
            ((JMenu)jComponent).addSeparator();
            JMenuItem jMenuItem7 = new JMenuItem();
            jMenuItem7.setText("Exit");
            jMenuItem7.setMnemonic('X');
            jMenuItem7.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
            jMenuItem7.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SAR2.this.exit();
                }
            });
            ((JMenu)jComponent).add(jMenuItem7);
        } else {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("exit", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jMenuBar.add((JMenu)jComponent);
        jComponent2 = new JMenu();
        ((AbstractButton)jComponent2).setText("Units");
        ((AbstractButton)jComponent2).setMnemonic('U');
        this.metersMenuItem = new JCheckBoxMenuItem();
        this.metersMenuItem.setText("Meters");
        this.metersMenuItem.setMnemonic('M');
        this.metersMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.metersMenuItem.setActionCommand(UNIT_METRIC);
        this.metersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setElevationUnit(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jComponent2).add(this.metersMenuItem);
        this.feetMenuItem = new JCheckBoxMenuItem();
        this.feetMenuItem.setText("Feet");
        this.feetMenuItem.setMnemonic('F');
        this.feetMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.feetMenuItem.setActionCommand(UNIT_IMPERIAL);
        this.feetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setElevationUnit(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jComponent2).add(this.feetMenuItem);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.metersMenuItem);
        ((ButtonGroup)serializable).add(this.feetMenuItem);
        ((JMenu)jComponent2).addSeparator();
        this.angleDDMenuItem = new JCheckBoxMenuItem();
        this.angleDDMenuItem.setText("Angles DD");
        this.angleDDMenuItem.setMnemonic('D');
        this.angleDDMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.angleDDMenuItem.setActionCommand("gov.nasa.worldwind.Geom.AngleDD");
        this.angleDDMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setAngleFormat(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jComponent2).add(this.angleDDMenuItem);
        this.angleDMSMenuItem = new JCheckBoxMenuItem();
        this.angleDMSMenuItem.setText("Angles DMS");
        this.angleDMSMenuItem.setMnemonic('S');
        this.angleDMSMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.angleDMSMenuItem.setActionCommand("gov.nasa.worldwind.Geom.AngleDMS");
        this.angleDMSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setAngleFormat(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jComponent2).add(this.angleDMSMenuItem);
        serializable2 = new ButtonGroup();
        ((ButtonGroup)serializable2).add(this.angleDDMenuItem);
        ((ButtonGroup)serializable2).add(this.angleDMSMenuItem);
        jMenuBar.add((JMenu)jComponent2);
        serializable = new JMenu();
        ((AbstractButton)serializable).setText("Annotation");
        ((AbstractButton)serializable).setMnemonic('A');
        serializable2 = new JMenuItem();
        ((AbstractButton)serializable2).setText("New Annotation...");
        ((AbstractButton)serializable2).setMnemonic('N');
        ((JMenuItem)serializable2).setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newAnnotation();
            }
        });
        ((JMenu)serializable).add((JMenuItem)serializable2);
        jMenuItem = new JMenuItem();
        jMenuItem.setText("Remove Annotation");
        jMenuItem.setMnemonic('R');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.removeAnnotation(SAR2.this.getCurrentAnnotation());
            }
        });
        ((JMenu)serializable).add(jMenuItem);
        jMenuItem2 = new JCheckBoxMenuItem();
        jMenuItem2.setText("Show Annotations");
        jMenuItem2.setMnemonic('S');
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        jMenuItem2.setSelected(true);
        jMenuItem2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SAR2.this.setAnnotationsEnabled(itemEvent.getStateChange() == 1);
            }
        });
        ((JMenu)serializable).add(jMenuItem2);
        jMenuBar.add((JMenu)serializable);
        this.viewLayerMenu = new ViewMenu();
        this.viewLayerMenu.setMnemonic('V');
        jMenuBar.add(this.viewLayerMenu);
        this.layerMenu = new LayerMenu();
        this.layerMenu.setMnemonic('L');
        jMenuBar.add(this.layerMenu);
        serializable2 = new JMenu();
        ((AbstractButton)serializable2).setText("Help");
        ((AbstractButton)serializable2).setMnemonic('H');
        jMenuItem = new JMenuItem();
        jMenuItem.setText("Search and Rescue Help");
        jMenuItem.setMnemonic('H');
        if (!Configuration.isMacOS()) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        } else {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(156, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.showHelp();
            }
        });
        ((JMenu)serializable2).add(jMenuItem);
        if (!Configuration.isMacOS()) {
            jMenuItem2 = new JMenuItem();
            jMenuItem2.setText("About");
            jMenuItem2.setMnemonic('A');
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SAR2.this.showAbout();
                }
            });
            ((JMenu)serializable2).add(jMenuItem2);
        } else {
            try {
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAbout", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jMenuBar.add((JMenu)serializable2);
        this.setJMenuBar(jMenuBar);
        jComponent = new JToolBar();
        ((JToolBar)jComponent).setFloatable(false);
        ((JToolBar)jComponent).setRollover(true);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jComponent2 = this.makeToolBarButton("24x24-open.gif", "Open track from file", "Open");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromFile();
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = this.makeToolBarButton("24x24-new.gif", "New track", "New");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrack(null);
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = this.makeToolBarButton("24x24-save.gif", "Save track", "Save");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.saveTrack(SAR2.this.getCurrentTrack(), false);
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = new JButton(sARScreenShotAction);
        ((AbstractButton)jComponent2).setText(null);
        jComponent.add(jComponent2);
        ((JToolBar)jComponent).addSeparator();
        this.viewExamineButton = this.makeToolBarButton("24x24-view-examine.gif", "View examine", "Examine");
        this.viewExamineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.firePropertyChange("TrackViewPanel.ViewModeChange", null, "TrackViewPanel.ViewModeExamine");
            }
        });
        jComponent.add(this.viewExamineButton);
        this.viewFollowButton = this.makeToolBarButton("24x24-view-follow.gif", "View fly-it", "Fly-it");
        this.viewFollowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.firePropertyChange("TrackViewPanel.ViewModeChange", null, "TrackViewPanel.ViewModeFollow");
            }
        });
        jComponent.add(this.viewFollowButton);
        this.viewFreeButton = this.makeToolBarButton("24x24-view-free.gif", "View free", "Free");
        this.viewFreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.firePropertyChange("TrackViewPanel.ViewModeChange", null, "TrackViewPanel.ViewModeFree");
            }
        });
        jComponent.add(this.viewFreeButton);
        ((JToolBar)jComponent).addSeparator();
        this.showTrackInfoButton = this.makeToolBarButton("24x24-segment-info.gif", "Display track information in the 3D view", "Display track information");
        this.showTrackInfoButton.setBorderPainted(false);
        this.showTrackInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.showTrackInfoButton.setBorderPainted(!SAR2.this.showTrackInfoButton.isBorderPainted());
                String string = SAR2.this.showTrackInfoButton.isBorderPainted() ? "TrackViewPanel.CurrentSegment" : null;
                SAR2.this.wwd.firePropertyChange("TrackViewPanel.ShowTrackInformation", null, string);
            }
        });
        jComponent.add(this.showTrackInfoButton);
        ((JToolBar)jComponent).addSeparator();
        this.extendTrackPlaneButton = this.makeToolBarButton("24x24-extend-plane.gif", "Extend track using the 3D plane", "Extension plane");
        this.extendTrackPlaneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.extendTrack("TrackController.ExtensionPlane");
            }
        });
        jComponent.add(this.extendTrackPlaneButton);
        this.extendTrackCursorAirButton = this.makeToolBarButton("24x24-extend-air.gif", "Extend track in the air with the mouse cursor and the Alt key", "Extension air");
        this.extendTrackCursorAirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.extendTrack("TrackController.ExtensionMouseAir");
            }
        });
        jComponent.add(this.extendTrackCursorAirButton);
        this.extendTrackCursorGroundButton = this.makeToolBarButton("24x24-extend-ground.gif", "Extend track on the ground with the mouse cursor and the Alt key", "Extension ground");
        this.extendTrackCursorGroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.extendTrack("TrackController.ExtensionMouseGround");
            }
        });
        jComponent.add(this.extendTrackCursorGroundButton);
        this.removeLastPointButton = this.makeToolBarButton("24x24-remove-point.gif", "Remove last track point", "Remove last");
        this.removeLastPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SAR2.this.getCurrentTrack() != null) {
                    SAR2.this.getCurrentTrack().firePropertyChange("TrackController.RemoveLastPoint", null, null);
                }
            }
        });
        jComponent.add(this.removeLastPointButton);
        this.nextPointButton = this.makeToolBarButton("24x24-forward.gif", "Move to next point", "Next point");
        this.nextPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SAR2.this.getCurrentTrack() != null) {
                    SAR2.this.getCurrentTrack().firePropertyChange("TrackController.MoveToNextPoint", null, null);
                }
            }
        });
        jComponent.add(this.nextPointButton);
        ((JToolBar)jComponent).addSeparator();
        jComponent2 = this.makeToolBarButton("24x24-profile.gif", "Terrain profile", "Profile");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.firePropertyChange("TerrainProfilePanel.Open", null, null);
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = this.makeToolBarButton("24x24-clouds.gif", "Cloud ceiling", "Clouds");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.firePropertyChange("CloudCeilingPanel.CloudCeilingOpen", null, null);
            }
        });
        jComponent.add(jComponent2);
        ((JToolBar)jComponent).addSeparator();
        jComponent2 = this.makeToolBarButton("24x24-help.gif", "Help", "Help");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.showHelp();
            }
        });
        jComponent.add(jComponent2);
        jComponent2 = this.makeToolBarButton("24x24-about.gif", "About the Search And Rescue application", "About");
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.showAbout();
            }
        });
        jComponent.add(jComponent2);
        this.setToolbarDefaultState();
        jComponent2 = new JPanel(new BorderLayout(0, 0));
        jComponent2.add((Component)jComponent, "North");
        jComponent2.add((Component)new JSeparator(0), "Center");
        this.getContentPane().add((Component)jComponent2, "North");
        this.pack();
        SAR2.centerWindowInDesktop(this);
    }

    private JButton makeToolBarButton(String string, String string2, String string3) {
        JButton jButton = new JButton();
        jButton.setToolTipText(string2);
        ImageIcon imageIcon = this.getIcon(string);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        } else {
            jButton.setText(string3);
        }
        return jButton;
    }

    private void updateToolBar(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("TrackController.TrackCurrent")) {
            SARTrack sARTrack = this.getCurrentTrack();
            if (this.toolbarTrack == null || sARTrack == null) {
                this.setToolbarDefaultState();
            }
            this.toolbarTrack = sARTrack;
        } else if (propertyChangeEvent.getPropertyName().equals("TrackViewPanel.ViewModeChange")) {
            Object object = propertyChangeEvent.getNewValue();
            this.viewExamineButton.setBorderPainted(object.equals("TrackViewPanel.ViewModeExamine"));
            this.viewFollowButton.setBorderPainted(object.equals("TrackViewPanel.ViewModeFollow"));
            this.viewFreeButton.setBorderPainted(object.equals("TrackViewPanel.ViewModeFree"));
        } else if (propertyChangeEvent.getPropertyName().equals("TrackController.BeginTrackPointEntry")) {
            Object object = propertyChangeEvent.getNewValue();
            this.extendTrackPlaneButton.setEnabled(object.equals("TrackController.ExtensionPlane"));
            this.extendTrackCursorGroundButton.setEnabled(object.equals("TrackController.ExtensionMouseGround"));
            this.extendTrackCursorAirButton.setEnabled(object.equals("TrackController.ExtensionMouseAir"));
            this.extendTrackPlaneButton.setBorderPainted(this.extendTrackPlaneButton.isEnabled());
            this.extendTrackCursorGroundButton.setBorderPainted(this.extendTrackCursorGroundButton.isEnabled());
            this.extendTrackCursorAirButton.setBorderPainted(this.extendTrackCursorAirButton.isEnabled());
            this.nextPointButton.setEnabled(this.extendTrackPlaneButton.isEnabled());
            this.removeLastPointButton.setEnabled(true);
        } else if (propertyChangeEvent.getPropertyName().equals("TrackController.EndTrackPointEntry")) {
            this.extendTrackPlaneButton.setEnabled(true);
            this.extendTrackCursorGroundButton.setEnabled(true);
            this.extendTrackCursorAirButton.setEnabled(true);
            this.extendTrackPlaneButton.setBorderPainted(false);
            this.extendTrackCursorGroundButton.setBorderPainted(false);
            this.extendTrackCursorAirButton.setBorderPainted(false);
            this.nextPointButton.setEnabled(false);
            this.removeLastPointButton.setEnabled(false);
        }
    }

    private void setToolbarDefaultState() {
        SARTrack sARTrack = this.getCurrentTrack();
        String string = this.controlPanel.getAnalysisPanel().getViewMode();
        this.viewExamineButton.setEnabled(sARTrack != null);
        this.viewFollowButton.setEnabled(sARTrack != null);
        this.viewFreeButton.setEnabled(sARTrack != null);
        this.extendTrackPlaneButton.setEnabled(sARTrack != null);
        this.extendTrackCursorGroundButton.setEnabled(sARTrack != null);
        this.extendTrackCursorAirButton.setEnabled(sARTrack != null);
        this.nextPointButton.setEnabled(false);
        this.removeLastPointButton.setEnabled(false);
        this.showTrackInfoButton.setEnabled(sARTrack != null);
        this.viewExamineButton.setBorderPainted(string.equals("TrackViewPanel.ViewModeExamine"));
        this.viewFollowButton.setBorderPainted(string.equals("TrackViewPanel.ViewModeFollow"));
        this.viewFreeButton.setBorderPainted(string.equals("TrackViewPanel.ViewModeFree"));
        this.extendTrackPlaneButton.setBorderPainted(false);
        this.extendTrackCursorGroundButton.setBorderPainted(false);
        this.extendTrackCursorAirButton.setBorderPainted(false);
    }

    private ImageIcon getIcon(String string) {
        String string2 = "gov/nasa/worldwindx/applications/sar/images/" + string;
        Object object = WWIO.getFileOrResourceAsStream(string2, this.getClass());
        if (!(object instanceof InputStream)) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read((InputStream)object);
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatAngle(String string, Angle angle) {
        String string2 = "gov.nasa.worldwind.Geom.AngleDMS".equals(string) ? angle.toDMSString() : String.format("%7.4f\u00b0", angle.degrees);
        return string2;
    }

    protected void onUserPreferencesChanged() {
        this.startOrStopAutoSave(1000L);
        this.elevationUnitChanged(null, SAR2.getUserPreferences().getStringValue("ElevationUnit"));
        this.angleFormatChanged(null, SAR2.getUserPreferences().getStringValue("AngleFormat"));
    }

    protected void initializeUserPreferences() {
        UserPreferenceUtils.getDefaultUserPreferences(SAR2.getUserPreferences());
    }

    protected void loadUserPreferences() {
        File file = new File(UserPreferenceUtils.getDefaultUserPreferencesPath());
        if (!file.exists()) {
            return;
        }
        Document document = null;
        try {
            document = WWXML.openDocumentFile(file.getPath(), this.getClass());
        }
        catch (WWRuntimeException wWRuntimeException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToReadFrom", file.getPath());
            Logging.logger().severe(string);
        }
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            return;
        }
        if (document.getDocumentElement() == null) {
            String string = Logging.getMessage("nullValue.DocumentElementIsNull");
            Logging.logger().severe(string);
            return;
        }
        UserPreferenceUtils.getUserPreferences(document.getDocumentElement(), SAR2.getUserPreferences());
    }

    protected void saveUserPreferences() {
        File file = new File(UserPreferenceUtils.getDefaultUserPreferencesPath());
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            String string = Logging.getMessage("generic.CannotCreateFile", file.getPath());
            Logging.logger().severe(string);
            return;
        }
        Document document = UserPreferenceUtils.createUserPreferencesDocument(SAR2.getUserPreferences());
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            return;
        }
        try {
            WWXML.saveDocumentToFile(document, file.getPath());
        }
        catch (WWRuntimeException wWRuntimeException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToWriteTo", file.getPath());
            Logging.logger().severe(string);
        }
    }

    protected void onAutoSave() {
        this.autoSaveAllTracks();
    }

    protected void startOrStopAutoSave(long l) {
        this.autoSaveTimer.stop();
        if (UserPreferenceUtils.getBooleanValue(SAR2.getUserPreferences(), "AutoSaveTracks")) {
            long l2 = AVListImpl.getLongValue(SAR2.getUserPreferences(), "AutoSaveTracksInterval", l);
            if (l2 < l) {
                l2 = l;
            }
            this.autoSaveTimer.setDelay((int)l2);
            this.autoSaveTimer.setInitialDelay((int)l2);
            this.autoSaveTimer.start();
        }
    }

    protected void autoSaveAllTracks() {
        if (!UserPreferenceUtils.getBooleanValue(SAR2.getUserPreferences(), "AutoSaveTracks")) {
            return;
        }
        for (SARTrack sARTrack : this.getTracksPanel().getAllTracks()) {
            this.autoSaveTrack(sARTrack);
        }
    }

    protected void autoSaveTrack(SARTrack sARTrack) {
        if (!UserPreferenceUtils.getBooleanValue(SAR2.getUserPreferences(), "AutoSaveTracks")) {
            return;
        }
        if (!sARTrack.isDirty()) {
            return;
        }
        if (sARTrack.getFile() == null || sARTrack.getFormat() == 0) {
            return;
        }
        this.saveTrack(sARTrack, false);
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (this.controlPanel.getTracksPanel().getCurrentTrack() != null) {
            SARTrack sARTrack = this.controlPanel.getTracksPanel().getCurrentTrack();
            this.controlPanel.getTracksPanel().getTrackPanel(sARTrack).doGetRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "trackPanel"));
        }
        if (this.controlPanel.getAnalysisPanel() != null) {
            this.controlPanel.getAnalysisPanel().doGetRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "analysisPanel"));
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Object object;
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "trackPanel");
        if (stateObject2 != null && this.controlPanel.getTracksPanel().getCurrentTrack() != null) {
            object = this.controlPanel.getTracksPanel().getCurrentTrack();
            this.controlPanel.getTracksPanel().getTrackPanel((SARTrack)object).doRestoreState(restorableSupport, stateObject2);
        }
        if ((object = restorableSupport.getStateObject(stateObject, "analysisPanel")) != null && this.controlPanel.getAnalysisPanel() != null) {
            this.controlPanel.getAnalysisPanel().doRestoreState(restorableSupport, (RestorableSupport.StateObject)object);
        }
    }
}

