/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.eurogeoss.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GetRecordsResponse {
    protected int numberOfRecordsMatched;
    protected int numberOfRecordsReturned;
    protected int nextRecord;
    protected Collection<Record> records = new ArrayList<Record>();

    public GetRecordsResponse() {
    }

    public GetRecordsResponse(XMLEventReader xMLEventReader) throws XMLStreamException {
        this.parseElement(xMLEventReader);
    }

    public int getNumberOfRecordsMatched() {
        return this.numberOfRecordsMatched;
    }

    public void setNumberOfRecordsMatched(int n) {
        this.numberOfRecordsMatched = n;
    }

    public int getNumberOfRecordsReturned() {
        return this.numberOfRecordsReturned;
    }

    public void setNumberOfRecordsReturned(int n) {
        this.numberOfRecordsReturned = n;
    }

    public int getNextRecord() {
        return this.nextRecord;
    }

    public void setNextRecord(int n) {
        this.nextRecord = n;
    }

    public Collection<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> collection) {
        this.records = collection;
    }

    protected void parseElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                String string = startElement.getName().getLocalPart();
                ++n;
                if (string.equals("SearchResults")) {
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string2 = attribute.getName().getLocalPart();
                        if (string2.equals("numberOfRecordsMatched")) {
                            this.numberOfRecordsMatched = WWUtil.convertStringToInteger(attribute.getValue());
                            continue;
                        }
                        if (string2.equals("numberOfRecordsReturned")) {
                            this.numberOfRecordsReturned = WWUtil.convertStringToInteger(attribute.getValue());
                            continue;
                        }
                        if (!string2.equals("nextRecord")) continue;
                        this.nextRecord = WWUtil.convertStringToInteger(attribute.getValue());
                    }
                    xMLEventReader.nextEvent();
                    continue;
                }
                if (string.equals("MD_Metadata")) {
                    this.records.add(new Record(xMLEventReader));
                    continue;
                }
                xMLEventReader.nextEvent();
                continue;
            }
            if (xMLEvent.isEndElement()) {
                if (--n <= 0) break;
                xMLEventReader.nextEvent();
                continue;
            }
            xMLEventReader.nextEvent();
        }
    }
}

