/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.eurogeoss.GetRecordsRequest;
import gov.nasa.worldwindx.applications.eurogeoss.GetRecordsResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class CatalogConnection {
    protected String serviceUrl;
    protected int connectTimeout = 10000;
    protected int readTimeout = 10000;

    public CatalogConnection(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.serviceUrl = string;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws IOException, XMLStreamException {
        if (getRecordsRequest == null) {
            String string = Logging.getMessage("nullValue.RequestIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        HttpURLConnection httpURLConnection = null;
        GetRecordsResponse getRecordsResponse = null;
        try {
            URL uRL = new URL(this.serviceUrl);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(this.getConnectTimeout());
            httpURLConnection.setReadTimeout(this.getReadTimeout());
            getRecordsResponse = this.sendGetRecordsRequest(getRecordsRequest, httpURLConnection);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return getRecordsResponse;
    }

    protected GetRecordsResponse sendGetRecordsRequest(GetRecordsRequest getRecordsRequest, HttpURLConnection httpURLConnection) throws IOException, XMLStreamException {
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
        OutputStream outputStream = httpURLConnection.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), "UTF-8");
        outputStreamWriter.write(getRecordsRequest.toXMLString());
        outputStreamWriter.close();
        if (Thread.interrupted()) {
            return null;
        }
        if (httpURLConnection.getResponseCode() != 200) {
            String string = Logging.getMessage("HTTP.ResponseCode", httpURLConnection.getResponseCode(), httpURLConnection.getURL());
            throw new IOException(string);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        return this.parseResponse(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GetRecordsResponse parseResponse(InputStream inputStream) throws XMLStreamException {
        XMLEventReader xMLEventReader = null;
        try {
            xMLEventReader = WWXML.openEventReaderStream(new BufferedInputStream(inputStream));
            GetRecordsResponse getRecordsResponse = new GetRecordsResponse(xMLEventReader);
            return getRecordsResponse;
        }
        finally {
            if (xMLEventReader != null) {
                xMLEventReader.close();
            }
        }
    }
}

