/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.dataimporter.DataInstaller;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSet;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSetFinder;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreSectorHighlighter;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreTable;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;

public class FileStorePanel
extends JPanel
implements ListSelectionListener {
    protected static long VISIBILITY_UPDATE_INTERVAL = 2000L;
    protected WorldWindow wwd;
    protected FileStoreTable fileStoreTable;
    protected FileStoreSectorHighlighter sectorHighlighter;
    protected long previousUpdate;
    protected boolean applyVisibilityFilter = false;

    public FileStorePanel(WorldWindow worldWindow) {
        super(new BorderLayout(5, 5));
        this.wwd = worldWindow;
        this.fileStoreTable = new FileStoreTable();
        this.setPreferredSize(new Dimension(800, 250));
        JScrollPane jScrollPane = new JScrollPane(this.fileStoreTable);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JButton jButton = new JButton(new AbstractAction("Delete Selected Data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileStorePanel.this.deleteSelected();
            }
        });
        jPanel.add((Component)jButton, "East");
        this.add((Component)jPanel, "South");
        final JCheckBox jCheckBox = new JCheckBox("Filter by Visibility");
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileStorePanel.this.applyVisibilityFilter = jCheckBox.isSelected();
                FileStorePanel.this.previousUpdate = 0L;
                FileStorePanel.this.wwd.redraw();
            }
        });
        jPanel.add((Component)jCheckBox, "West");
        this.sectorHighlighter = new FileStoreSectorHighlighter(worldWindow, this);
        this.addSelectionListener(this);
        this.wwd.addRenderingListener(new RenderingListener(){

            @Override
            public void stageChanged(RenderingEvent renderingEvent) {
                if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap")) {
                    FileStorePanel.this.filterForVisibility();
                }
            }
        });
    }

    public void update(final FileStore fileStore) {
        final FileStoreDataSetFinder fileStoreDataSetFinder = new FileStoreDataSetFinder();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final List<FileStoreDataSet> list = fileStoreDataSetFinder.findDataSets(fileStore);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileStorePanel.this.fileStoreTable.setDataSets(list);
                        FileStorePanel.this.setCursor(Cursor.getDefaultCursor());
                        FileStorePanel.this.wwd.redraw();
                    }
                });
            }
        });
        thread.start();
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.fileStoreTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public List<FileStoreDataSet> getSelectedDataSets() {
        return this.fileStoreTable.getSelectedDataSets();
    }

    public void scrollToDataSet(FileStoreDataSet fileStoreDataSet) {
        this.fileStoreTable.scrollToDataSet(fileStoreDataSet);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getFirstIndex() < 0) {
            return;
        }
        List<FileStoreDataSet> list = this.fileStoreTable.getSelectedDataSets();
        for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
            int n = this.fileStoreTable.convertRowIndexToModel(i);
            FileStoreDataSet fileStoreDataSet = ((FileStoreTableModel)this.fileStoreTable.getModel()).getRow(n);
            if (fileStoreDataSet.isImagery()) {
                this.manageLayer(fileStoreDataSet, list.contains(fileStoreDataSet));
                continue;
            }
            if (!fileStoreDataSet.isElevation()) continue;
            this.manageElevationModel(fileStoreDataSet, list.contains(fileStoreDataSet));
        }
        this.fileStoreTable.repaint();
    }

    protected void manageLayer(FileStoreDataSet fileStoreDataSet, boolean bl) {
        if (bl) {
            this.addToWorldWindow(fileStoreDataSet);
        } else {
            Layer layer = DataInstaller.findLayer(this.wwd, fileStoreDataSet.getName());
            if (layer != null) {
                this.wwd.getModel().getLayers().remove(layer);
            }
        }
    }

    protected void manageElevationModel(FileStoreDataSet fileStoreDataSet, boolean bl) {
        if (bl) {
            this.addToWorldWindow(fileStoreDataSet);
        } else {
            ElevationModel elevationModel = DataInstaller.findElevationModel(this.wwd, fileStoreDataSet.getName());
            if (elevationModel != null) {
                DataInstaller.removeElevationModel(this.wwd, elevationModel);
            }
        }
    }

    protected void addToWorldWindow(FileStoreDataSet fileStoreDataSet) {
        Document document = null;
        try {
            document = WWXML.openDocument(new File(fileStoreDataSet.configFilePath));
            document = DataConfigurationUtils.convertToStandardDataConfigDocument(document);
        }
        catch (WWRuntimeException wWRuntimeException) {
            Logging.logger().log(Level.SEVERE, "Exception making data set active", wWRuntimeException);
        }
        if (document == null) {
            return;
        }
        DataInstaller.addToWorldWindow(this.wwd, document.getDocumentElement(), fileStoreDataSet, true);
    }

    protected void deleteSelected() {
        List<FileStoreDataSet> list = this.fileStoreTable.getSelectedDataSets();
        for (FileStoreDataSet fileStoreDataSet : list) {
            String string = "Delete " + fileStoreDataSet.getName() + "?" + "\nThis operation cannot be undone.";
            int n = JOptionPane.showConfirmDialog(this, string, "Verify Data Deletion", 1, 2);
            if (n == 0) {
                this.deleteDataSet(fileStoreDataSet);
                continue;
            }
            if (n == 1) continue;
            return;
        }
    }

    protected void deleteDataSet(FileStoreDataSet fileStoreDataSet) {
        ElevationModel elevationModel;
        fileStoreDataSet.delete();
        ((FileStoreTableModel)this.fileStoreTable.getModel()).removeDataSet(fileStoreDataSet);
        if (fileStoreDataSet.isImagery()) {
            Layer layer = DataInstaller.findLayer(this.wwd, fileStoreDataSet.getName());
            if (layer != null) {
                this.wwd.getModel().getLayers().remove(layer);
            }
        } else if (fileStoreDataSet.isElevation() && (elevationModel = DataInstaller.findElevationModel(this.wwd, fileStoreDataSet.getName())) != null) {
            DataInstaller.removeElevationModel(this.wwd, elevationModel);
        }
    }

    protected void filterForVisibility() {
        long l = System.currentTimeMillis();
        if (this.previousUpdate + VISIBILITY_UPDATE_INTERVAL > l) {
            return;
        }
        FileStoreTableModel fileStoreTableModel = (FileStoreTableModel)this.fileStoreTable.getModel();
        if (fileStoreTableModel.getDataSets().size() == 0) {
            return;
        }
        Sector sector = this.wwd.getSceneController().getDrawContext().getVisibleSector();
        if (this.applyVisibilityFilter && sector == null) {
            for (FileStoreDataSet fileStoreDataSet : fileStoreTableModel.getDataSets()) {
                fileStoreDataSet.removeKey("gov.nasa.worldwindx.dataimport.FileStoreTable.Visible");
            }
        } else {
            for (FileStoreDataSet fileStoreDataSet : fileStoreTableModel.getDataSets()) {
                if (!this.applyVisibilityFilter || sector.contains(fileStoreDataSet.getSector())) {
                    fileStoreDataSet.setValue("gov.nasa.worldwindx.dataimport.FileStoreTable.Visible", true);
                    continue;
                }
                fileStoreDataSet.removeKey("gov.nasa.worldwindx.dataimport.FileStoreTable.Visible");
            }
        }
        this.previousUpdate = l;
        this.fileStoreTable.repaint();
    }
}

