/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwindx.applications.dataimporter.FileSetPanel;
import gov.nasa.worldwindx.applications.dataimporter.FileStorePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class DataInstallerPanel
extends JPanel {
    protected FileSetPanel fileSetPanel;
    protected FileStorePanel fileStorePanel;
    protected WorldWindow wwd;

    public DataInstallerPanel(WorldWindow worldWindow) {
        super(new BorderLayout(5, 5));
        this.wwd = worldWindow;
        this.setBorder(new EmptyBorder(30, 10, 10, 10));
        this.fileSetPanel = new FileSetPanel(worldWindow);
        this.fileStorePanel = new FileStorePanel(worldWindow);
        this.fileStorePanel.update(WorldWind.getDataFileStore());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Available Data", this.fileSetPanel);
        jTabbedPane.add("Installed Data", this.fileStorePanel);
        this.add((Component)jTabbedPane, "Center");
        this.fileSetPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataInstallerPanel.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
        this.fileSetPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwindx.dataimport.DataInstaller.InstallComplete")) {
                    DataInstallerPanel.this.fileStorePanel.update(WorldWind.getDataFileStore());
                }
            }
        });
    }
}

