/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class Config {
    private Properties prop;
    private File file;

    public synchronized void set(String key, String value) throws IOException {
        this.prop.put(key, value);
        this.save();
    }

    public synchronized String get(String key) {
        return this.prop.getProperty(key);
    }

    public synchronized String get(String name, String defaultValue) {
        return this.prop.getProperty(name, defaultValue);
    }

    public Config(String name) throws IOException {
        String home = System.getProperty("user.home");
        this.file = new File(home + "/." + name);
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.prop = new Properties();
        FileInputStream fis = new FileInputStream(this.file);
        this.prop.load(fis);
        fis.close();
    }

    private void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        this.prop.store(fos, "Saved: " + new Date());
        fos.close();
    }
}

