/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jnn.func;

public class Sigma {
    public static final double SIG_X1 = -5.0;
    public static final double SIG_X2 = 5.0;
    public static final double SIG_XA = -100.0;
    public static final double SIG_XB = 100.0;
    public static final int SIG_N = 1024;
    public static final int SIG_P = 1024;
    private static final double SIG_SX = 102.3;
    private static final double SIG_TX = 10.76842105263158;
    private static final double[] SIG_YA;
    private static final double[] SIG_YB;
    private static final double[] SIG_Y;

    public static double evaluate(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static double evaluateOpt(double x) {
        if (x < -100.0) {
            return 0.0;
        }
        if (x >= 100.0) {
            return 1.0;
        }
        if (x < -5.0) {
            double di = 10.76842105263158 * (x - -100.0);
            int i = (int)di;
            return SIG_YA[i] + (di - (double)i) * (SIG_YA[i + 1] - SIG_YA[i]);
        }
        if (x >= 5.0) {
            double di = 10.76842105263158 * (x - 5.0);
            int i = (int)di;
            return SIG_YB[i] + (di - (double)i) * (SIG_YB[i + 1] - SIG_YB[i]);
        }
        double di = 102.3 * (x - -5.0);
        int i = (int)di;
        return SIG_Y[i] + (di - (double)i) * (SIG_Y[i + 1] - SIG_Y[i]);
    }

    static {
        int i;
        SIG_YA = new double[1024];
        SIG_YB = new double[1024];
        SIG_Y = new double[1024];
        for (i = 0; i < 1024; ++i) {
            Sigma.SIG_Y[i] = Sigma.evaluate(-5.0 + (double)i / 102.3);
        }
        for (i = 0; i < 1024; ++i) {
            Sigma.SIG_YA[i] = Sigma.evaluate(-100.0 + (double)i / 10.76842105263158);
        }
        for (i = 0; i < 1024; ++i) {
            Sigma.SIG_YB[i] = Sigma.evaluate(5.0 + (double)i / 10.76842105263158);
        }
    }
}

