/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class CachedVector<E>
extends Vector<E> {
    private static final long serialVersionUID = -4994486169224407197L;
    private Map<Object, IntegerWrapper> _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int n) {
        super(n);
    }

    @Override
    public int indexOf(Object object) {
        this.initializeCache();
        IntegerWrapper integerWrapper = this._indexCache.get(object);
        if (integerWrapper != null) {
            return integerWrapper.integer;
        }
        if (this.isLazyCaching()) {
            int n = super.indexOf(object);
            if (n == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n);
            }
            return n;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n, int n2) {
        if (this._indexCache != null) {
            if (this.size() - n <= this.size() >> 2) {
                Collection<IntegerWrapper> collection = this._indexCache.values();
                for (IntegerWrapper integerWrapper : collection) {
                    if (integerWrapper.integer < n) continue;
                    integerWrapper.integer += n2;
                }
            } else {
                this.uncacheAll();
            }
        }
    }

    protected Map<Object, IntegerWrapper> createCache() {
        return new IdentityHashMap<Object, IntegerWrapper>();
    }

    public synchronized void cacheIt(Object object, int n) {
        if (this._indexCache != null && (this._indexCache.get(object) == null || n < this._indexCache.get((Object)object).integer)) {
            this._indexCache.put(object, new IntegerWrapper(n));
        }
    }

    public synchronized void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public boolean add(E e) {
        boolean bl = super.add(e);
        if (!this.isLazyCaching() && bl) {
            this.initializeCache();
            this.cacheIt(e, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(n, 1);
            this.cacheIt(e, n);
        } else if (this._indexCache != null) {
            this.adjustCache(n, 1);
            this.cacheIt(e, n);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        if (e != null) {
            this.uncacheIt(e);
            this.adjustCache(n, -1);
        }
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n, -1);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = super.addAll(n, collection);
        this.initializeCache();
        this.adjustCache(n, collection.size());
        for (E e : collection) {
            this.cacheIt(e, n++);
        }
        return bl;
    }

    @Override
    public E set(int n, E e) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e2 = super.set(n, e);
            this.uncacheIt(e2);
            this.cacheIt(e, n);
            return e2;
        }
        return super.set(n, e);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer n = 0;
        for (Object e : this) {
            if (this._indexCache.get(e) == null) {
                this._indexCache.put(e, new IntegerWrapper(n));
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else {
            super.removeRange(n, n2);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }

    public static class IntegerWrapper {
        int integer;

        private IntegerWrapper(int n) {
            this.integer = n;
        }
    }
}

