/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.util.io.FileUtils;

@XStreamAlias(value="template")
public class TemplateFile {
    private static final String defaultNamePattern = "template%s.%s";
    @XStreamAlias(value="file")
    protected String fileName;
    @XStreamOmitField
    protected String contents;
    @XStreamOmitField
    protected TemplateType type;
    @XStreamOmitField
    protected TemplateEngine engine;

    public static TemplateFile fromFile(String path) throws TemplateException, IOException {
        TemplateFile template = null;
        if (path != null) {
            File file = new File(path);
            String extension = FileUtils.getExtension((File)file);
            if (".vm".equalsIgnoreCase(extension)) {
                template = new TemplateFile(TemplateType.VELOCITY);
            } else if (".js".equalsIgnoreCase(extension)) {
                template = new TemplateFile(TemplateType.JAVASCRIPT);
            } else {
                throw new TemplateException("Unsupported template extension");
            }
            template.setFileName(file.getName());
            template.read();
        }
        return template;
    }

    public TemplateFile() {
        this(TemplateType.VELOCITY);
    }

    public TemplateFile(TemplateType templateType) {
        this.type = templateType;
    }

    public TemplateFile(TemplateEngine templateEngine) {
        this(templateEngine, null);
    }

    public TemplateFile(TemplateEngine templateEngine, String templateFileName) {
        this.engine = templateEngine;
        this.type = this.engine.getType();
        if (templateFileName != null) {
            this.setFileName(templateFileName);
        }
    }

    public void associateWith(TemplateEngine engine) throws TemplateException {
        if (engine == null) {
            throw new TemplateException("Null template engine");
        }
        if (this.type != null && !engine.getType().equals((Object)this.type)) {
            throw new TemplateException("Wrong template engine type");
        }
        this.engine = engine;
    }

    public String getContents() throws IOException {
        if (this.contents == null) {
            this.read();
        }
        return this.contents;
    }

    public void setContents(String text, boolean shouldParse) throws TemplateException {
        String oldValue = this.contents;
        this.contents = text;
        try {
            if (shouldParse) {
                this.engine.parse(this);
            }
        }
        catch (TemplateException e) {
            this.contents = oldValue;
            throw e;
        }
    }

    public String getFileName() {
        if (this.fileName == null) {
            if (this.engine != null) {
                Path adapterPath = this.engine.getTemplateBasePath();
                this.fileName = adapterPath.getName(adapterPath.getNameCount() - 1) + "." + this.getExtension();
            } else {
                this.fileName = String.format(defaultNamePattern, 1, this.getExtension());
            }
        }
        return this.fileName;
    }

    public void setFileName(String value) {
        String extension = FileUtils.getExtension((String)value);
        if (".vm".equalsIgnoreCase(extension)) {
            this.type = TemplateType.VELOCITY;
        } else if (".js".equalsIgnoreCase(extension)) {
            this.type = TemplateType.JAVASCRIPT;
        } else {
            throw new IllegalArgumentException("Unsupported file extension");
        }
        this.fileName = FileUtils.getFileNameFromPath((String)value);
    }

    public File getTemplatePath() {
        Path thisPath;
        if (this.engine != null) {
            Path adapterPath = this.engine.getTemplateBasePath();
            thisPath = adapterPath.resolve(this.getFileName());
        } else {
            thisPath = Paths.get(this.getFileName(), new String[0]);
        }
        return thisPath.toFile();
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType value) {
        this.type = value;
    }

    public String getExtension() {
        String ext;
        switch (this.type) {
            case JAVASCRIPT: {
                ext = "js";
                break;
            }
            default: {
                ext = "vm";
            }
        }
        return ext;
    }

    private String read() throws IOException {
        if (this.contents == null) {
            Path templatePath = this.getTemplatePath().toPath();
            byte[] encoded = Files.readAllBytes(templatePath);
            this.contents = new String(encoded, Charset.defaultCharset());
        }
        return this.contents;
    }

    public void save() throws IOException {
        File path = this.getTemplatePath();
        if (path != null) {
            try (FileWriter writer = new FileWriter(path);){
                writer.write(this.getContents());
                writer.flush();
                writer.close();
            }
        }
    }

    public TemplateFile copy() throws IOException {
        TemplateFile newTemplate = new TemplateFile(this.type);
        newTemplate.fileName = this.fileName;
        newTemplate.contents = this.getContents();
        return newTemplate;
    }

    public String toString() {
        return this.getFileName();
    }
}

