/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.netbeans.modules.favorites.Tab;
import org.netbeans.modules.favorites.api.Favorites;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public final class FavoritesNode
extends FilterNode
implements Index {
    private static Node node;
    static RequestProcessor RP;
    private static DataFlavor uriListDataFlavor;

    private FavoritesNode(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        if (index != -1) {
            return null;
        }
        DataObject[] dos = LoaderTransfer.getDataObjects((Transferable)t, (int)7);
        if (dos == null) {
            List<File> files = this.getDraggedFilesList(t);
            if (!files.isEmpty()) {
                return new FavoritesExternalPasteType(files);
            }
            return null;
        }
        for (DataObject dataObject : dos) {
            if (Actions.Add.isAllowed(dataObject)) continue;
            return null;
        }
        return new FavoritesPasteType(dos);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> cl) {
        if (cl == Index.class) {
            return (T)((Node.Cookie)cl.cast((Object)this));
        }
        return (T)super.getCookie(cl);
    }

    public int getNodesCount() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            return ind.getNodesCount();
        }
        return 0;
    }

    public Node[] getNodes() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            return ind.getNodes();
        }
        return new Node[0];
    }

    public int indexOf(Node node) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            if (node instanceof ProjectFilterNode) {
                ProjectFilterNode fn = (ProjectFilterNode)node;
                int i = ind.indexOf(fn.getOriginal());
                return i;
            }
            int i = ind.indexOf(node);
            return i;
        }
        return -1;
    }

    public void reorder() {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.reorder();
        }
    }

    public void reorder(int[] perm) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.reorder(perm);
        }
    }

    public void move(int x, int y) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.move(x, y);
        }
    }

    public void exchange(int x, int y) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.exchange(x, y);
        }
    }

    public void moveUp(int x) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.moveUp(x);
        }
    }

    public void moveDown(int x) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.moveDown(x);
        }
    }

    public void addChangeListener(ChangeListener chl) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.addChangeListener(chl);
        }
    }

    public void removeChangeListener(ChangeListener chl) {
        Index ind = (Index)this.getOriginal().getCookie(Index.class);
        if (ind != null) {
            ind.removeChangeListener(chl);
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Favorites");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            return folder;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new FavoritesNode(FavoritesNode.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String s = System.getProperty("user.home");
        File home = new File(s);
        home = FileUtil.normalizeFile((File)home);
        return Utilities.toURI((File)home).toURL();
    }

    static File fileForNode(Node n) {
        DataObject obj = (DataObject)n.getCookie(DataObject.class);
        if (obj == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)obj.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private List<File> getDraggedFilesList(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (null != fileList) {
                    return NbCollections.checkedListByCopy((List)fileList, File.class, (boolean)true);
                }
            } else if (t.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String uriList = (String)t.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(uriList);
            }
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(FavoritesNode.class.getName()).log(Level.WARNING, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FavoritesNode.class.getName()).log(Level.FINE, null, ex);
        }
        return Collections.emptyList();
    }

    private DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException cnfE) {
                throw new AssertionError((Object)cnfE);
            }
        }
        return uriListDataFlavor;
    }

    private List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = Utilities.toFile((URI)uri);
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }

    static Node createFilterNode(Node node) {
        return new ProjectFilterNode(node, EventQueue.isDispatchThread() ? FilterNode.Children.LEAF : FavoritesNode.findChildren(node));
    }

    private static Children findChildren(Node node) {
        assert (!EventQueue.isDispatchThread());
        DataFolder folder = (DataFolder)node.getLookup().lookup(DataFolder.class);
        Object ch = folder != null ? new Chldrn((Node)new FilterNode(node, folder.createNodeChildren((DataFilter)new VisQ())), true) : (node.isLeaf() ? Children.LEAF : new Chldrn(node, true));
        return ch;
    }

    static {
        RP = new RequestProcessor("Favorites Nodes");
    }

    private static class Chldrn
    extends FilterNode.Children {
        private boolean hideHidden;

        public Chldrn(Node node, boolean hideHidden) {
            super(node);
            this.hideHidden = hideHidden;
        }

        protected Node[] createNodes(Node node) {
            return new Node[]{FavoritesNode.createFilterNode(node)};
        }
    }

    private static class FavoritesExternalPasteType
    extends PasteType {
        private final List<File> files;

        private FavoritesExternalPasteType(List<File> files) {
            this.files = files;
        }

        public Transferable paste() throws IOException {
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    HashSet<FileObject> fos = new HashSet<FileObject>(FavoritesExternalPasteType.this.files.size());
                    for (File f : FavoritesExternalPasteType.this.files) {
                        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
                        if (fo == null) continue;
                        fos.add(fo);
                    }
                    if (!fos.isEmpty()) {
                        try {
                            Favorites.getDefault().add(fos.toArray(new FileObject[fos.size()]));
                        }
                        catch (DataObjectNotFoundException ex) {
                            Logger.getLogger(FavoritesNode.class.getName()).log(Level.INFO, null, ex);
                        }
                    }
                }
            });
            return null;
        }
    }

    private static class FavoritesPasteType
    extends PasteType {
        private final DataObject[] dos;

        private FavoritesPasteType(DataObject[] dos) {
            this.dos = dos;
        }

        public Transferable paste() throws IOException {
            Tab.RP.post(new Runnable(){

                @Override
                public void run() {
                    Actions.Add.addToFavorites(Arrays.asList(FavoritesPasteType.this.dos));
                }
            });
            return null;
        }
    }

    private static class ProjectFilterNode
    extends FilterNode
    implements NodeListener,
    Runnable {
        private DataShadow ds;

        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
            this.addNodeListener(this);
            RP.post((Runnable)this);
        }

        @Override
        public void run() {
            this.setChildren(FavoritesNode.findChildren(this.getOriginal()));
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                this.ds = (DataShadow)this.getCookie(DataShadow.class);
                this.fireDisplayNameChange(null, null);
            }
        }

        protected NodeListener createNodeListener() {
            return new FilterNode.NodeAdapter(this){

                protected void propertyChange(FilterNode fn, PropertyChangeEvent ev) {
                    super.propertyChange(fn, ev);
                    if ("leaf".equals(ev.getPropertyName())) {
                        RP.post((Runnable)ProjectFilterNode.this);
                    }
                }
            };
        }

        public void setName(String name) {
            DataFolder favoritesFolder = FavoritesNode.getFolder();
            DataObject[] children = favoritesFolder.getChildren();
            super.setName(name);
            try {
                favoritesFolder.setOrder(children);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String getDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = this.getShadow();
                if (ds != null) {
                    String name = ds.getName();
                    String path = FileUtil.getFileDisplayName((FileObject)ds.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplate", (Object)name, (Object)path);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = this.getShadow();
                if (ds != null) {
                    String name = ds.getName();
                    String path = FileUtil.getFileDisplayName((FileObject)ds.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(FavoritesNode.class, (String)"CTL_DisplayNameTemplateHtml", (Object)name, (Object)path);
                }
                return super.getDisplayName();
            }
            return this.getOriginal().getHtmlDisplayName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public Action[] getActions(boolean context) {
            Action[] arr = super.getActions(context);
            boolean isRoot = false;
            FileObject fo = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            if (fo == null) {
                Logger.getLogger(FavoritesNode.class.getName()).log(Level.INFO, "No FO in node: {0}:{1}", new Object[]{this.getOriginal().getName(), this.getOriginal()});
            } else {
                isRoot = fo.isRoot();
            }
            if (isRoot) {
                return this.createActionsForRoot(arr, FavoritesNode.getNode().equals((Object)this.getParentNode()));
            }
            if (FavoritesNode.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = this.getShadow();
                if (ds != null) {
                    if (ds.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(arr);
                    }
                    return this.createActionsForFavoriteFile(arr);
                }
            } else if (fo != null) {
                if (fo.isFolder()) {
                    return this.createActionsForFolder(arr);
                }
                return this.createActionsForFile(arr);
            }
            return arr;
        }

        private Action[] createActionsForRoot(Action[] arr, boolean removeAvailable) {
            if (removeAvailable) {
                ArrayList<Action> newArr = new ArrayList<Action>(arr.length + 2);
                newArr.addAll(Arrays.asList(arr));
                if (!newArr.isEmpty()) {
                    newArr.add(null);
                }
                newArr.add(Actions.remove());
                return newArr.toArray(new Action[newArr.size()]);
            }
            return arr;
        }

        private Action[] createActionsForFavoriteFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Object> newArr = new ArrayList<Object>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFile(Action[] arr) {
            boolean added = false;
            ArrayList<Object> newArr = new ArrayList<Object>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }

        private DataShadow getShadow() {
            return this.ds;
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return FavoritesNode.getNode();
        }
    }

    static class VisQ
    implements DataFilter.FileBased,
    ChangeableDataFilter,
    ChangeListener {
        public static final VisQ DEFAULT = new VisQ();
        private ChangeListener weak;
        private ChangeSupport support = new ChangeSupport((Object)this);

        VisQ() {
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        public boolean acceptFileObject(FileObject fo) {
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.support.fireChange();
        }
    }
}

