/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.main;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class Main {
    private static final String NB_MAIN_CLASS = "org.netbeans.core.startup.Main";

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        System.setProperty("snap.home", Paths.get(Main.getPropertySafe("netbeans.home"), new String[0]).getParent().toString());
        if (Boolean.getBoolean("snap.debug")) {
            Main.dumpEnv(args);
        }
        Main.runNetBeans(args, NB_MAIN_CLASS);
    }

    private static String getPropertySafe(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("Expecting system property '%s' to be set", key));
        }
        return value;
    }

    private static void dumpEnv(String[] args) {
        System.out.println();
        System.out.println("Class: " + Main.class.getName());
        System.out.println();
        System.out.println("Arguments:");
        for (int i = 0; i < args.length; ++i) {
            System.out.printf("args[%d] = \"%s\"%n", i, args[i]);
        }
        System.out.println();
        System.out.println("System properties:");
        Properties properties = System.getProperties();
        ArrayList<String> propertyNameList = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(propertyNameList);
        for (String name : propertyNameList) {
            String value = properties.getProperty(name);
            System.out.println(name + " = " + value);
        }
        System.out.flush();
        System.out.println();
        System.out.println("Stack trace (this is no error!): ");
        new Exception().printStackTrace(System.out);
        System.out.println();
        System.out.flush();
    }

    private static void runNetBeans(String[] args, String mainClassName) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> nbMainClass = classLoader.loadClass(mainClassName);
        Method nbMainMethod = nbMainClass.getDeclaredMethod("main", String[].class);
        nbMainMethod.invoke(null, new Object[]{args});
    }
}

