/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class StringToNominal
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private static final long serialVersionUID = 4864084427902797605L;
    private final Range m_AttIndices = new Range("last");

    public String globalInfo() {
        return "Converts a range of string attributes (unspecified number of values) to nominal (set number of values). You should ensure that all string values that will appear are represented in the first batch of the data.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndices.setUpper(instanceInfo.numAttributes() - 1);
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance newInstance = (Instance)instance.copy();
            for (int i = 0; i < newInstance.numAttributes(); ++i) {
                String inVal;
                if (!newInstance.attribute(i).isString() || newInstance.isMissing(i) || !this.m_AttIndices.isInRange(i)) continue;
                Attribute outAtt = this.getOutputFormat().attribute(newInstance.attribute(i).name());
                int outIndex = outAtt.indexOfValue(inVal = newInstance.stringValue(i));
                if (outIndex < 0) {
                    newInstance.setMissing(i);
                    continue;
                }
                newInstance.setValue(i, (double)outIndex);
            }
            this.push(newInstance, false);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy(), false);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSets the range of attribute indices (default last).", "R", 1, "-R <col>"));
        newVector.addElement(new Option("\tInvert the range specified by -R.", "V", 1, "-V <col>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndices = Utils.getOption('R', options);
        if (attIndices.length() != 0) {
            this.setAttributeRange(attIndices);
        } else {
            this.setAttributeRange("last");
        }
        String invertSelection = Utils.getOption('V', options);
        if (invertSelection.length() != 0) {
            this.m_AttIndices.setInvert(true);
        } else {
            this.m_AttIndices.setInvert(false);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-R");
        options.add("" + this.getAttributeRange());
        if (this.m_AttIndices.getInvert()) {
            options.add("-V");
        }
        return options.toArray(new String[0]);
    }

    public String attributeRangeTipText() {
        return "Sets which attributes to process. This attributes must be string attributes (\"first\" and \"last\" are valid values as well as ranges and lists)";
    }

    public String getAttributeRange() {
        return this.m_AttIndices.getRanges();
    }

    public void setAttributeRange(String rangeList) {
        this.m_AttIndices.setRanges(rangeList);
    }

    private void setOutputFormat() {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!this.m_AttIndices.isInRange(j) || !att.isString()) {
                newAtts.add(att);
                continue;
            }
            ArrayList<String> newVals = new ArrayList<String>(att.numValues());
            for (int i = 0; i < att.numValues(); ++i) {
                newVals.add(att.value(i));
            }
            Attribute newAtt = new Attribute(att.name(), newVals);
            newAtt.setWeight(att.weight());
            newAtts.add(newAtt);
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] argv) {
        StringToNominal.runFilter(new StringToNominal(), argv);
    }
}

