/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weka.core.ClassCache;
import weka.core.Environment;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageManager;
import weka.core.packageManagement.Dependency;
import weka.core.packageManagement.Package;
import weka.core.packageManagement.PackageConstraint;

public class WekaPackageLibIsolatingClassLoader
extends URLClassLoader {
    protected String m_packageName = "";
    protected WekaPackageClassLoaderManager m_classloaderRepo;
    protected Set<String> m_packageJarEntries = new HashSet<String>();
    protected Set<String> m_packageJarResources = new HashSet<String>();
    protected Set<String> m_libJarEntries = new HashSet<String>();
    protected boolean m_debug;
    protected Set<String> m_packageDependencies = new HashSet<String>();

    public WekaPackageLibIsolatingClassLoader(WekaPackageClassLoaderManager repo, File packageDir) throws Exception {
        super(new URL[0]);
        String debug = System.getProperty("weka.core.classloader.debug", "false");
        this.m_debug = debug.equalsIgnoreCase("true");
        this.m_classloaderRepo = repo;
        this.init(packageDir);
    }

    protected void init(File packageDir) throws Exception {
        this.m_packageName = packageDir.getName();
        Package toLoad = WekaPackageManager.getInstalledPackageInfo(this.m_packageName);
        List<String> jarsToBeIgnoredWhenLoadingClasses = this.checkForNativeLibs(toLoad, packageDir);
        List<Dependency> deps = toLoad.getDependencies();
        for (Dependency d : deps) {
            PackageConstraint target = d.getTarget();
            this.m_packageDependencies.add(target.getPackage().getName());
        }
        if (this.m_debug) {
            System.out.println("WekaPackageLibIsolatingClassLoader for: " + this.m_packageName);
            System.out.print("\tDependencies:");
            for (String dep : this.m_packageDependencies) {
                System.out.print(" " + dep);
            }
            System.out.println();
        }
        this.processDir(packageDir, jarsToBeIgnoredWhenLoadingClasses, true);
        if (this.m_debug) {
            System.out.println("\nPackage jar(s) classes:");
            for (String c : this.m_packageJarEntries) {
                System.out.println("\t" + c);
            }
            System.out.println("\nPackage jar(s) resources:");
            for (String r : this.m_packageJarResources) {
                System.out.println("\t" + r);
            }
            System.out.println("\nLib jar(s) classes:");
            for (String c : this.m_libJarEntries) {
                System.out.println("\t" + c);
            }
        }
    }

    protected void addPackageDependency(String packageName) {
        this.m_packageDependencies.add(packageName);
    }

    protected List<String> checkForNativeLibs(Package toLoad, File packageDir) {
        String nativeLibs;
        ArrayList<String> jarsForClassloaderToIgnore = new ArrayList<String>();
        if (toLoad.getPackageMetaDataElement("NativeLibs") != null && (nativeLibs = toLoad.getPackageMetaDataElement("NativeLibs").toString()).length() > 0) {
            String[] jarsWithLibs;
            for (String entry : jarsWithLibs = nativeLibs.split(";")) {
                String[] jarAndEntries = entry.split(":");
                if (jarAndEntries.length != 2) {
                    System.err.println("Was expecting two entries for native lib spec - jar:comma-separated lib paths");
                    continue;
                }
                String jarPath = jarAndEntries[0].trim();
                String[] libPathsInJar = jarAndEntries[1].split(",");
                ArrayList<String> libsToInstall = new ArrayList<String>();
                for (String lib : libPathsInJar) {
                    String libName = lib.trim().replace("\\", "/");
                    if (this.nativeLibInstalled(libName.substring(libName.lastIndexOf("/") + 1, libName.length()))) continue;
                    libsToInstall.add(libName.substring(libName.lastIndexOf("/") + 1, libName.length()));
                }
                if (libsToInstall.size() <= 0) continue;
                try {
                    this.installNativeLibs(packageDir, jarPath, libsToInstall);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (toLoad.getPackageMetaDataElement("InjectLoader") != null) {
            String[] entries;
            String injectDetails = toLoad.getPackageMetaDataElement("InjectLoader").toString();
            for (String entry : entries = injectDetails.split(";")) {
                String jarPath = entry.trim();
                boolean rootClassLoader = false;
                if (jarPath.startsWith("root|")) {
                    jarPath = jarPath.replace("root|", "");
                    rootClassLoader = true;
                }
                String ignoreJar = jarPath.replace("\\", "/");
                ignoreJar = ignoreJar.substring(ignoreJar.lastIndexOf("/") + 1);
                jarsForClassloaderToIgnore.add(ignoreJar);
                try {
                    WekaPackageClassLoaderManager.injectAllClassesInJar(new File(packageDir.toString() + File.separator + jarPath.trim()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return jarsForClassloaderToIgnore;
    }

    private static byte[] getByteCode(InputStream in) throws IOException {
        int readLength;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream byteCodeBuf = new ByteArrayOutputStream();
        while ((readLength = in.read(buf)) != -1) {
            byteCodeBuf.write(buf, 0, readLength);
        }
        in.close();
        return byteCodeBuf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installNativeLibs(File packageDir, String libJar, List<String> libJarPaths) throws IOException {
        File libJarFile = new File(packageDir.toString() + File.separator + libJar.trim());
        if (!libJarFile.exists()) {
            System.err.println("Native lib jar file '" + libJarFile.toString() + "' does " + "not seem to exist - skipping");
            return;
        }
        ZipFile libZip = new ZipFile(libJarFile);
        Enumeration<? extends ZipEntry> enumeration = libZip.entries();
        ArrayList<String> libNames = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.isDirectory()) {
                String lastPart = zipEntry.getName().replace("\\", "/");
                if (libJarPaths.contains(lastPart = lastPart.substring(lastPart.lastIndexOf("/") + 1))) {
                    File installPath = new File(WekaPackageManager.NATIVE_LIBS_DIR, lastPart);
                    if (!installPath.exists()) {
                        BufferedInputStream inS = new BufferedInputStream(libZip.getInputStream(zipEntry));
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(installPath));
                        try {
                            WekaPackageLibIsolatingClassLoader.copyStreams(inS, bos);
                        }
                        finally {
                            ((InputStream)inS).close();
                            bos.flush();
                            bos.close();
                        }
                    }
                    libNames.add(lastPart);
                }
            }
            if (libNames.size() != libJarPaths.size()) continue;
            break;
        }
        libZip.close();
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] data = new byte[1024];
        while ((count = input.read(data, 0, 1024)) != -1) {
            output.write(data, 0, count);
        }
    }

    protected boolean nativeLibInstalled(String libName) {
        boolean result = false;
        File[] contents = WekaPackageManager.NATIVE_LIBS_DIR.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (!f.getName().equals(libName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void processDir(File dir, List<String> jarsToIgnore, boolean topLevel) throws MalformedURLException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File content : contents) {
                if (content.isFile() && content.getPath().toLowerCase().endsWith(".jar")) {
                    if (jarsToIgnore.contains(content.getName())) continue;
                    URL url = content.toURI().toURL();
                    this.addURL(url);
                    if (topLevel) {
                        this.storeJarContents(content, this.m_packageJarEntries, true);
                        if (!this.m_debug) continue;
                        System.out.println("Package jar: " + content.getName());
                        continue;
                    }
                    if (this.m_debug) {
                        System.out.println("Lib jar: " + content.toString());
                    }
                    this.storeJarContents(content, this.m_libJarEntries, false);
                    continue;
                }
                if (!content.isDirectory() || !content.getName().equalsIgnoreCase("lib")) continue;
                this.processDir(content, jarsToIgnore, false);
            }
        }
    }

    protected void storeJarContents(File jarFile, Set<String> repo, boolean isTopLevelPackageJar) {
        if (jarFile.exists()) {
            try {
                JarFile jar = new JarFile(jarFile);
                Enumeration<JarEntry> enm = jar.entries();
                while (enm.hasMoreElements()) {
                    JarEntry entry = enm.nextElement();
                    if (entry.getName().endsWith(".class")) {
                        String cleanedUp = ClassCache.cleanUp(entry.getName());
                        repo.add(cleanedUp);
                        continue;
                    }
                    if (entry.isDirectory() || entry.getName().contains("META-INF") || !isTopLevelPackageJar) continue;
                    String resource = entry.getName();
                    resource = resource.replace("\\", "/");
                    this.m_packageJarResources.add(entry.getName());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            try {
                result = super.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                String packageName;
                Iterator<String> i$ = this.m_packageDependencies.iterator();
                while (i$.hasNext() && (result = this.m_classloaderRepo.findClass(packageName = i$.next(), name)) == null) {
                }
            }
        }
        if (result == null) {
            try {
                result = this.m_classloaderRepo.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new ClassNotFoundException("[" + this.toString() + "] Unable to find class: " + name);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        URL result = super.getResource(name);
        if (result == null) {
            String packageName;
            Iterator<String> i$ = this.m_packageDependencies.iterator();
            while (i$.hasNext() && (result = this.m_classloaderRepo.findResource(packageName = i$.next(), name)) == null) {
            }
        }
        if (result == null) {
            if (this.m_debug) {
                System.out.println("Trying parent classloader (" + this.m_classloaderRepo.getClass().getClassLoader() + ") for resource '" + name + "'");
            }
            if ((result = this.m_classloaderRepo.getClass().getClassLoader().getResource(name)) == null && this.m_debug) {
                System.out.println("Failed...");
            }
        }
        if (this.m_debug) {
            System.out.println(this.m_packageName + " classloader searching for resource " + name + (result != null ? " - found" : " - not found"));
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> result = null;
        result = super.getResources(name);
        if (result == null || !result.hasMoreElements()) {
            String packageName;
            Iterator<String> i$ = this.m_packageDependencies.iterator();
            while (i$.hasNext() && ((result = this.m_classloaderRepo.findResources(packageName = i$.next(), name)) == null || !result.hasMoreElements())) {
            }
        }
        if (result == null || !result.hasMoreElements()) {
            if (this.m_debug) {
                System.out.println("Trying parent classloader (" + this.m_classloaderRepo.getClass().getClassLoader() + ") for resources '" + name + "'");
            }
            if (((result = this.m_classloaderRepo.getClass().getClassLoader().getResources(name)) == null || !result.hasMoreElements()) && this.m_debug) {
                System.out.println("Failed...");
            }
        }
        if (this.m_debug) {
            System.out.println(this.m_packageName + " classloader searching for resources " + name + (result != null ? " - found" : " - not found"));
        }
        return result;
    }

    public boolean hasThirdPartyClass(String className) {
        return this.m_libJarEntries.contains(className);
    }

    protected Class<?> findGloballyVisiblePackageClass(String name) {
        Class<?> result = null;
        if (this.classExistsInPackageJarFiles(name)) {
            try {
                result = this.findLoadedClass(name);
                if (result == null) {
                    result = super.findClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    protected URL findGloballyVisiblePackageResource(String name) {
        URL result = null;
        if (this.resourceExistsInPackageJarFiles(name)) {
            result = super.findResource(name);
        }
        return result;
    }

    protected Enumeration<URL> findGloballyVisiblePackageResources(String name) throws IOException {
        Enumeration<URL> result = null;
        if (this.resourceExistsInPackageJarFiles(name)) {
            result = super.findResources(name);
        }
        return result;
    }

    private static Object getFieldObject(Class<?> clazz, String name, Object obj) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    protected void closeClassLoader() {
        block30: {
            HashSet<String> closedFiles = new HashSet<String>();
            try {
                Object obj = WekaPackageLibIsolatingClassLoader.getFieldObject(URLClassLoader.class, "ucp", this);
                ArrayList loaders = (ArrayList)WekaPackageLibIsolatingClassLoader.getFieldObject(obj.getClass(), "loaders", obj);
                for (Object ldr : loaders) {
                    try {
                        JarFile file = (JarFile)WekaPackageLibIsolatingClassLoader.getFieldObject(ldr.getClass(), "jar", ldr);
                        closedFiles.add(file.getName());
                        file.close();
                    }
                    catch (Exception file) {}
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
            try {
                Vector nativeLibArr = (Vector)WekaPackageLibIsolatingClassLoader.getFieldObject(ClassLoader.class, "nativeLibraries", this);
                for (Object lib : nativeLibArr) {
                    try {
                        Method fMethod = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                        fMethod.setAccessible(true);
                        fMethod.invoke(lib, new Object[0]);
                    }
                    catch (Exception fMethod) {}
                }
            }
            catch (Exception nativeLibArr) {
                // empty catch block
            }
            HashMap uCache = null;
            HashMap fCache = null;
            try {
                Class<?> jarUrlConnClass = null;
                try {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    jarUrlConnClass = contextClassLoader.loadClass("sun.net.www.protocol.jar.JarURLConnection");
                }
                catch (Throwable contextClassLoader) {
                    // empty catch block
                }
                if (jarUrlConnClass == null) {
                    jarUrlConnClass = Class.forName("sun.net.www.protocol.jar.JarURLConnection");
                }
                Class<?> factory = WekaPackageLibIsolatingClassLoader.getFieldObject(jarUrlConnClass, "factory", null).getClass();
                try {
                    fCache = (HashMap)WekaPackageLibIsolatingClassLoader.getFieldObject(factory, "fileCache", null);
                }
                catch (Exception file) {
                    // empty catch block
                }
                try {
                    uCache = (HashMap)WekaPackageLibIsolatingClassLoader.getFieldObject(factory, "urlCache", null);
                }
                catch (Exception file) {
                    // empty catch block
                }
                if (uCache != null) {
                    Set set = null;
                    while (set == null) {
                        try {
                            set = ((HashMap)uCache.clone()).keySet();
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {}
                    }
                    for (Object file : set) {
                        JarFile jar;
                        if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (fCache != null) {
                            fCache.remove(uCache.get(jar));
                        }
                        uCache.remove(jar);
                    }
                    break block30;
                }
                if (fCache == null) break block30;
                for (Object key : ((HashMap)fCache.clone()).keySet()) {
                    JarFile jar;
                    Object file = fCache.get(key);
                    if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fCache.remove(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean classExistsInPackageJarFiles(String name) {
        return this.m_packageJarEntries.contains(name);
    }

    private boolean resourceExistsInPackageJarFiles(String name) {
        return this.m_packageJarResources.contains(name);
    }

    public String toString() {
        return "" + this.getClass().getCanonicalName() + " (" + this.m_packageName + ")";
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public Set<String> getPackageJarEntries() {
        return this.m_packageJarEntries;
    }

    protected boolean integrityCheck() throws Exception {
        for (String dep : this.m_packageDependencies) {
            if (this.m_classloaderRepo.getPackageClassLoader(dep) != null) continue;
            return false;
        }
        Package p = WekaPackageManager.getInstalledPackageInfo(this.m_packageName);
        if (!this.checkForMissingClasses(p, System.err)) {
            return false;
        }
        if (!WekaPackageLibIsolatingClassLoader.checkForUnsetEnvVar(p, System.err)) {
            return false;
        }
        if (!WekaPackageLibIsolatingClassLoader.checkForMissingFiles(p, new File(WekaPackageManager.getPackageHome().toString() + File.separator + p.getName()), System.err)) {
            return false;
        }
        this.setSystemProperties(p, System.out);
        return true;
    }

    protected void setSystemProperties(Package toLoad, PrintStream ... progress) {
        Object sysProps = toLoad.getPackageMetaDataElement("SetSystemProperties");
        if (sysProps != null && sysProps.toString().length() > 0) {
            String[] propsToSet;
            for (String prop : propsToSet = sysProps.toString().split(";")) {
                String[] keyVals = prop.split("=");
                if (keyVals.length != 2) continue;
                String key = keyVals[0].trim();
                String val = keyVals[1].trim();
                for (PrintStream p : progress) {
                    p.println("[" + this.toString() + "] setting property: " + prop);
                }
                System.setProperty(key, val);
            }
        }
    }

    protected boolean checkForMissingClasses(Package toCheck, PrintStream ... progress) throws Exception {
        Object doNotLoadMessage;
        boolean result = true;
        Object doNotLoadIfClassNotInstantiable = toCheck.getPackageMetaDataElement("DoNotLoadIfClassNotPresent");
        if (doNotLoadIfClassNotInstantiable != null && doNotLoadIfClassNotInstantiable.toString().length() > 0) {
            StringTokenizer tok = new StringTokenizer(doNotLoadIfClassNotInstantiable.toString(), ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                try {
                    this.findClass(nextT);
                }
                catch (Exception ex) {
                    for (PrintStream p : progress) {
                        p.println("[WekaPackageLibIsolatingClassLoader] " + toCheck.getName() + " can't be loaded because " + nextT + " can't be instantiated.");
                    }
                    result = false;
                    break;
                }
            }
        }
        if (!result && (doNotLoadMessage = toCheck.getPackageMetaDataElement("DoNotLoadIfEnvVarNotSetMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            for (PrintStream p : progress) {
                String dnlM = doNotLoadMessage.toString();
                try {
                    dnlM = Environment.getSystemWide().substitute(dnlM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.println("[Weka] " + dnlM);
            }
        }
        return result;
    }

    public static boolean checkForMissingFiles(Package toLoad, File packageRoot, PrintStream ... progress) {
        Object doNotLoadMessage;
        boolean result = true;
        Object doNotLoadIfFileMissing = toLoad.getPackageMetaDataElement("DoNotLoadIfFileNotPresent");
        String packageRootPath = packageRoot.getPath() + File.separator;
        if (doNotLoadIfFileMissing != null && doNotLoadIfFileMissing.toString().length() > 0) {
            StringTokenizer tok = new StringTokenizer(doNotLoadIfFileMissing.toString(), ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                File toCheck = new File(packageRootPath + nextT);
                if (toCheck.exists()) continue;
                for (PrintStream p : progress) {
                    p.println("[Weka] " + toLoad.getName() + " can't be loaded because " + toCheck.getPath() + " appears to be missing.");
                }
                result = false;
                break;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement("DoNotLoadIfFileNotPresentMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            String dnlM = doNotLoadMessage.toString();
            try {
                dnlM = Environment.getSystemWide().substitute(dnlM);
            }
            catch (Exception toCheck) {
                // empty catch block
            }
            for (PrintStream p : progress) {
                p.println("[Weka] " + dnlM);
            }
        }
        return result;
    }

    protected static boolean checkForUnsetEnvVar(Package toLoad, PrintStream ... progress) {
        Object doNotLoadMessage;
        Object doNotLoadIfUnsetVar = toLoad.getPackageMetaDataElement("DoNotLoadIfEnvVarNotSet");
        boolean result = true;
        if (doNotLoadIfUnsetVar != null && doNotLoadIfUnsetVar.toString().length() > 0) {
            String[] elements = doNotLoadIfUnsetVar.toString().split(",");
            Environment env = Environment.getSystemWide();
            for (String var : elements) {
                if (env.getVariableValue(var.trim()) != null) continue;
                for (PrintStream p : progress) {
                    p.println("[Weka] " + toLoad.getName() + " can't be loaded because " + "the environment variable " + var + " is not set.");
                }
                result = false;
                break;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement("DoNotLoadIfEnvVarNotSetMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            for (PrintStream p : progress) {
                String dnlM = doNotLoadMessage.toString();
                try {
                    dnlM = Environment.getSystemWide().substitute(dnlM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.println("[Weka] " + dnlM);
            }
        }
        return result;
    }
}

