/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.dialogs.CheckListDialog;
import org.esa.snap.productlibrary.rcp.toolviews.DBRemover;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.productlibrary.rcp.toolviews.DatabasePane;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ListView;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryList;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryTable;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ThumbnailView;
import org.esa.snap.productlibrary.rcp.toolviews.model.DatabaseStatistics;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductLibraryConfig;
import org.esa.snap.productlibrary.rcp.toolviews.model.SortingDecorator;
import org.esa.snap.productlibrary.rcp.toolviews.timeline.TimelinePanel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.quicklooks.ThumbnailPanel;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProductLibraryTopComponent", iconBase="org/esa/snap/productlibrary/icons/search.png", persistenceType=0)
public class ProductLibraryToolView
extends ToolTopComponent
implements LabelBarProgressMonitor.ProgressBarListener,
DatabasePane.DatabaseQueryListener,
WorldMapUI.WorldMapUIListener,
ListView.ListViewListener,
ProductLibraryActions.ProductLibraryActionListener {
    private static ImageIcon updateIcon;
    private static ImageIcon updateRolloverIcon;
    private static ImageIcon stopIcon;
    private static ImageIcon stopRolloverIcon;
    private static ImageIcon addButtonIcon;
    private static ImageIcon removeButtonIcon;
    private static ImageIcon listViewButtonIcon;
    private static ImageIcon tableViewButtonIcon;
    private static ImageIcon thumbnailViewButtonIcon;
    private static ImageIcon helpButtonIcon;
    private static final String LAST_ERROR_OUTPUT_DIR_KEY = "snap.lastErrorOutputDir";
    private JPanel mainPanel;
    private JComboBox repositoryListCombo;
    private ProductEntryTable productEntryTable;
    private ProductEntryList productEntryList;
    private ThumbnailView thumbnailView;
    private ListView currentListView;
    private JLabel statusLabel;
    private JPanel progressPanel;
    private JScrollPane listViewPane;
    private JScrollPane tableViewPane;
    private JScrollPane thumbnailPane;
    private JSplitPane splitPaneV;
    private JButton addButton;
    private JButton removeButton;
    private JButton viewButton;
    private JButton updateButton;
    private LabelBarProgressMonitor progMon;
    private JProgressBar progressBar;
    private ProductLibraryConfig libConfig;
    private static final String helpId = "productLibrary";
    private WorldMapUI worldMapUI = null;
    private DatabasePane dbPane;
    private ProductLibraryActions productLibraryActions;
    private boolean initialized = false;

    public ProductLibraryToolView() {
        this.setDisplayName("Product Library");
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialize();
        }
    }

    protected void componentHidden() {
        this.currentListView.setProductEntryList(new ProductEntry[0]);
    }

    protected void componentDeactivated() {
        this.currentListView.setProductEntryList(new ProductEntry[0]);
    }

    private synchronized void initialize() {
        this.initDatabase();
        this.initUI();
        this.dbPane.getDB();
        this.initialized = true;
    }

    private void initDatabase() {
        this.libConfig = new ProductLibraryConfig(SnapApp.getDefault().getPreferences());
        this.dbPane = new DatabasePane();
        this.dbPane.addListener(this);
        this.productLibraryActions = new ProductLibraryActions(this);
        this.productLibraryActions.addListener(this);
        this.productEntryTable = new ProductEntryTable(this.productLibraryActions);
        this.productEntryTable.addListener(this);
        this.productEntryList = new ProductEntryList(this.productLibraryActions);
        this.productEntryList.addListener(this);
        this.thumbnailView = new ThumbnailView(this.productLibraryActions);
        this.thumbnailView.addListener(this);
        this.currentListView = this.productEntryTable;
    }

    private static void loadIcons() {
        updateIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/refresh24.png", ProductLibraryToolView.class);
        updateRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)updateIcon);
        stopIcon = UIUtils.loadImageIcon((String)"icons/Stop24.gif");
        stopRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)stopIcon);
        addButtonIcon = UIUtils.loadImageIcon((String)"icons/Plus24.gif");
        removeButtonIcon = UIUtils.loadImageIcon((String)"icons/Minus24.gif");
        listViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_list24.png", ThumbnailPanel.class);
        tableViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_table24.png", ThumbnailPanel.class);
        thumbnailViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_thumbnails24.png", ThumbnailPanel.class);
        helpButtonIcon = UIUtils.loadImageIcon((String)"icons/Help24.gif");
    }

    public void initUI() {
        ProductLibraryToolView.loadIcons();
        JPanel northPanel = this.createHeaderPanel();
        JPanel centrePanel = this.createCentrePanel();
        JPanel southPanel = this.createStatusPanel();
        DatabaseStatistics stats = new DatabaseStatistics(this.dbPane);
        TimelinePanel timeLinePanel = new TimelinePanel(stats);
        this.dbPane.addListener(timeLinePanel);
        JSplitPane splitPane = new JSplitPane(0, centrePanel, timeLinePanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.99);
        this.mainPanel = new JPanel(new BorderLayout(4, 4));
        this.mainPanel.add((Component)northPanel, "North");
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.add((Component)southPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProductLibraryToolView.this.progMon != null) {
                    ProductLibraryToolView.this.progMon.setCanceled(true);
                }
            }
        });
        this.applyConfig(this.libConfig);
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }
        });
        this.setUIComponentsEnabled(this.repositoryListCombo.getItemCount() > 1);
        this.setLayout(new BorderLayout());
        this.add(this.mainPanel, "Center");
    }

    private JPanel createHeaderPanel() {
        JPanel headerBar = new JPanel();
        headerBar.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        this.updateButton = DialogUtils.createButton((String)"updateButton", (String)"Rescan folder", (ImageIcon)updateIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.updateButton.setActionCommand("update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("stop")) {
                    ProductLibraryToolView.this.updateButton.setEnabled(false);
                    ProductLibraryToolView.this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                    if (ProductLibraryToolView.this.progMon != null) {
                        ProductLibraryToolView.this.progMon.setCanceled(true);
                    }
                } else {
                    RescanOptions dlg = new RescanOptions();
                    dlg.show();
                    if (dlg.IsOK()) {
                        DBScanner.Options options = new DBScanner.Options(dlg.shouldDoRecusive(), dlg.shouldValidateZips(), dlg.shouldDoQuicklooks());
                        ProductLibraryToolView.this.rescanFolder(options);
                    }
                }
            }
        });
        headerBar.add((Component)this.updateButton, gbc);
        headerBar.add(new JLabel("Folder:"));
        gbc.weightx = 99.0;
        this.repositoryListCombo = new JComboBox();
        this.repositoryListCombo.setName(this.getClass().getName() + "repositoryListCombo");
        this.repositoryListCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Object selectedItem = ProductLibraryToolView.this.repositoryListCombo.getSelectedItem();
                    if (selectedItem instanceof File) {
                        ProductLibraryToolView.this.dbPane.setBaseDir((File)selectedItem);
                    } else {
                        ProductLibraryToolView.this.dbPane.setBaseDir(null);
                    }
                }
            }
        });
        headerBar.add((Component)this.repositoryListCombo, gbc);
        gbc.weightx = 0.0;
        this.addButton = DialogUtils.createButton((String)"addButton", (String)"Add folder", (ImageIcon)addButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.addRepository();
            }
        });
        headerBar.add((Component)this.addButton, gbc);
        this.removeButton = DialogUtils.createButton((String)"removeButton", (String)"Remove folder", (ImageIcon)removeButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.removeRepository();
            }
        });
        headerBar.add((Component)this.removeButton, gbc);
        this.viewButton = DialogUtils.createButton((String)"viewButton", (String)"Change View", (ImageIcon)thumbnailViewButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public synchronized void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.currentListView.setProductEntryList(new ProductEntry[0]);
                if (ProductLibraryToolView.this.currentListView instanceof ProductEntryList) {
                    ProductLibraryToolView.this.currentListView = ProductLibraryToolView.this.productEntryTable;
                    ProductLibraryToolView.this.viewButton.setIcon(thumbnailViewButtonIcon);
                    ProductLibraryToolView.this.viewButton.setRolloverIcon(thumbnailViewButtonIcon);
                    ProductLibraryToolView.this.splitPaneV.setLeftComponent(ProductLibraryToolView.this.tableViewPane);
                } else if (ProductLibraryToolView.this.currentListView instanceof ProductEntryTable) {
                    ProductLibraryToolView.this.currentListView = ProductLibraryToolView.this.thumbnailView;
                    ProductLibraryToolView.this.viewButton.setIcon(listViewButtonIcon);
                    ProductLibraryToolView.this.viewButton.setRolloverIcon(listViewButtonIcon);
                    ProductLibraryToolView.this.splitPaneV.setLeftComponent(ProductLibraryToolView.this.thumbnailPane);
                } else if (ProductLibraryToolView.this.currentListView instanceof ThumbnailView) {
                    ProductLibraryToolView.this.currentListView = ProductLibraryToolView.this.productEntryList;
                    ProductLibraryToolView.this.viewButton.setIcon(tableViewButtonIcon);
                    ProductLibraryToolView.this.viewButton.setRolloverIcon(tableViewButtonIcon);
                    ProductLibraryToolView.this.splitPaneV.setLeftComponent(ProductLibraryToolView.this.listViewPane);
                }
                ProductLibraryToolView.this.notifyNewEntryListAvailable();
            }
        });
        headerBar.add((Component)this.viewButton, gbc);
        JButton helpButton = DialogUtils.createButton((String)"helpButton", (String)"Help", (ImageIcon)helpButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        HelpCtx.setHelpIDString((JComponent)helpButton, (String)helpId);
        helpButton.addActionListener(e -> new HelpCtx(helpId).display());
        headerBar.add((Component)helpButton, gbc);
        return headerBar;
    }

    private JPanel createStatusPanel() {
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        this.statusLabel = new JLabel("");
        this.statusLabel.setMinimumSize(new Dimension(100, 10));
        southPanel.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "East");
        return southPanel;
    }

    private JPanel createCentrePanel() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setMinimumSize(new Dimension(200, 577));
        leftPanel.add((Component)this.dbPane, "North");
        JPanel commandPanel = this.productLibraryActions.createCommandPanel();
        this.listViewPane = new JScrollPane(this.productEntryList);
        this.listViewPane.setMinimumSize(new Dimension(400, 400));
        this.tableViewPane = new JScrollPane(this.productEntryTable);
        this.tableViewPane.setMinimumSize(new Dimension(400, 400));
        this.thumbnailPane = new JScrollPane((Component)((Object)this.thumbnailView));
        this.thumbnailPane.setMinimumSize(new Dimension(400, 400));
        this.thumbnailPane.getViewport().setScrollMode(0);
        this.worldMapUI = new WorldMapUI();
        this.worldMapUI.addListener((WorldMapUI.WorldMapUIListener)this);
        this.splitPaneV = new JSplitPane(0, this.tableViewPane, (Component)this.worldMapUI.getWorlMapPane());
        this.splitPaneV.setOneTouchExpandable(true);
        this.splitPaneV.setResizeWeight(0.8);
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.add((Component)leftPanel, "West");
        centrePanel.add((Component)this.splitPaneV, "Center");
        centrePanel.add((Component)commandPanel, "East");
        return centrePanel;
    }

    private void applyConfig(ProductLibraryConfig config) {
        File[] baseDirList = config.getBaseDirs();
        this.repositoryListCombo.insertItemAt("All_Folders", 0);
        for (File f : baseDirList) {
            this.repositoryListCombo.insertItemAt(f, this.repositoryListCombo.getItemCount());
        }
        if (baseDirList.length > 0) {
            this.repositoryListCombo.setSelectedIndex(0);
        }
    }

    private void addRepository() {
        File baseDir = this.productLibraryActions.promptForRepositoryBaseDir();
        if (baseDir == null) {
            return;
        }
        HashMap<String, Boolean> checkBoxMap = new HashMap<String, Boolean>(3);
        checkBoxMap.put("Generate quicklooks?", false);
        checkBoxMap.put("Search folder recursively?", true);
        RescanOptions dlg = new RescanOptions();
        dlg.show();
        if (dlg.IsOK()) {
            this.libConfig.addBaseDir(baseDir);
            int index = this.repositoryListCombo.getItemCount();
            this.repositoryListCombo.insertItemAt(baseDir, index);
            this.setUIComponentsEnabled(this.repositoryListCombo.getItemCount() > 1);
            DBScanner.Options options = new DBScanner.Options(dlg.shouldDoRecusive(), dlg.shouldValidateZips(), dlg.shouldDoQuicklooks());
            this.updateRepostitory(baseDir, options);
        }
    }

    LabelBarProgressMonitor createLabelBarProgressMonitor() {
        if (this.progMon == null) {
            this.progMon = new LabelBarProgressMonitor(this.progressBar, this.statusLabel);
            this.progMon.addListener((LabelBarProgressMonitor.ProgressBarListener)this);
        }
        return this.progMon;
    }

    public File[] getSelectedFiles() {
        return this.currentListView.getSelectedFiles();
    }

    public ProductEntry[] getSelectedProductEntries() {
        return this.currentListView.getSelectedProductEntries();
    }

    public ProductEntry getEntryOverMouse() {
        return this.currentListView.getEntryOverMouse();
    }

    public void sort(SortingDecorator.SORT_BY sortBy) {
        this.currentListView.sort(sortBy);
    }

    public void selectAll() {
        this.currentListView.selectAll();
        this.notifySelectionChanged();
    }

    public void selectNone() {
        this.currentListView.clearSelection();
        this.notifySelectionChanged();
    }

    private synchronized void updateRepostitory(File baseDir, DBScanner.Options options) {
        if (baseDir == null) {
            return;
        }
        this.progMon = this.createLabelBarProgressMonitor();
        DBScanner scanner = new DBScanner(this.dbPane.getDB(), baseDir, options, (ProgressMonitor)this.progMon);
        scanner.addListener(new MyDatabaseScannerListener());
        scanner.execute();
    }

    private synchronized void removeProducts(File baseDir) {
        this.progMon = this.createLabelBarProgressMonitor();
        DBRemover remover = new DBRemover(this.dbPane.getDB(), baseDir, (ProgressMonitor)this.progMon);
        remover.addListener(new MyDatabaseRemoverListener());
        remover.execute();
    }

    private void removeRepository() {
        Object selectedItem = this.repositoryListCombo.getSelectedItem();
        int index = this.repositoryListCombo.getSelectedIndex();
        if (index == 0) {
            Dialogs.Answer status = Dialogs.requestDecision((String)"Remove folders", (String)"This will remove all folders and products from the database.\nAre you sure you wish to continue?", (boolean)true, null);
            if (status == Dialogs.Answer.YES) {
                while (this.repositoryListCombo.getItemCount() > 1) {
                    File baseDir = (File)this.repositoryListCombo.getItemAt(1);
                    this.libConfig.removeBaseDir(baseDir);
                    this.repositoryListCombo.removeItemAt(1);
                }
                this.removeProducts(null);
                this.UpdateUI();
            }
        } else if (selectedItem instanceof File) {
            File baseDir = (File)selectedItem;
            Dialogs.Answer status = Dialogs.requestDecision((String)"Remove products", (String)("This will remove all products within " + baseDir.getAbsolutePath() + " from the database\n" + "Are you sure you wish to continue?"), (boolean)true, null);
            if (status == Dialogs.Answer.YES) {
                this.libConfig.removeBaseDir(baseDir);
                this.repositoryListCombo.removeItemAt(index);
                this.removeProducts(baseDir);
                this.UpdateUI();
            }
        }
    }

    private void setUIComponentsEnabled(boolean enable) {
        this.removeButton.setEnabled(enable);
        this.updateButton.setEnabled(enable);
        this.repositoryListCombo.setEnabled(enable);
    }

    private void toggleUpdateButton(String command) {
        if (command.equals("stop")) {
            this.updateButton.setIcon(stopIcon);
            this.updateButton.setRolloverIcon(stopRolloverIcon);
            this.updateButton.setActionCommand("stop");
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.updateButton.setIcon(updateIcon);
            this.updateButton.setRolloverIcon(updateRolloverIcon);
            this.updateButton.setActionCommand("update");
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    public void UpdateUI() {
        this.dbPane.refresh();
        this.currentListView.updateUI();
    }

    public void findSlices(int dataTakeId) {
        this.dbPane.findSlices(dataTakeId);
    }

    private void rescanFolder(DBScanner.Options options) {
        if (this.repositoryListCombo.getSelectedIndex() != 0) {
            this.updateRepostitory((File)this.repositoryListCombo.getSelectedItem(), options);
        } else {
            File[] baseDirList;
            for (File f : baseDirList = this.libConfig.getBaseDirs()) {
                this.updateRepostitory(f, options);
            }
        }
    }

    private void updateStatusLabel() {
        String selectedText = "";
        int selectedCount = this.currentListView.getSelectionCount();
        if (selectedCount > 0) {
            selectedText = ", " + selectedCount + " Selected";
        } else {
            this.dbPane.updateProductSelectionText(null);
        }
        this.statusLabel.setText(this.currentListView.getTotalCount() + " Products" + selectedText);
    }

    public void ShowRepository(ProductEntry[] productEntryList) {
        this.currentListView.setProductEntryList(productEntryList);
        this.notifySelectionChanged();
        GeoPos[][] geoBoundaries = new GeoPos[productEntryList.length][4];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            geoBoundaries[i++] = entry.getGeoBoundary();
        }
        this.worldMapUI.setAdditionalGeoBoundaries(geoBoundaries);
        this.worldMapUI.setSelectedGeoBoundaries((GeoPos[][])null);
    }

    public static void handleErrorList(List<DBScanner.ErrorFile> errorList) {
        StringBuilder str = new StringBuilder();
        int cnt = 1;
        for (DBScanner.ErrorFile err : errorList) {
            str.append(err.message);
            str.append("   ");
            str.append(err.file.getAbsolutePath());
            str.append('\n');
            if (cnt >= 20) {
                str.append("plus " + (errorList.size() - 20) + " other errors...\n");
                break;
            }
            ++cnt;
        }
        String question = "\nWould you like to save the list to a text file?";
        if (Dialogs.requestDecision((String)"Product Errors", (String)("The follow files have errors:\n" + str.toString() + "\nWould you like to save the list to a text file?"), (boolean)false, null) == Dialogs.Answer.YES) {
            File file = Dialogs.requestFileForSave((String)"Save as...", (boolean)false, (FileFilter)new SnapFileFilter("Text File", new String[]{".txt"}, "Text File"), (String)".txt", (String)"ProductErrorList", null, (String)LAST_ERROR_OUTPUT_DIR_KEY);
            try {
                ProductLibraryToolView.writeErrors(errorList, file);
            }
            catch (Exception e) {
                Dialogs.showError((String)("Unable to save to " + file.getAbsolutePath()));
            }
            if (Desktop.isDesktopSupported() && file.exists()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception e) {
                    SystemUtils.LOG.warning("Unable to open error file: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeErrors(List<DBScanner.ErrorFile> errorList, File file) throws Exception {
        if (file == null) {
            return;
        }
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
            p = new PrintStream(out);
            for (DBScanner.ErrorFile err : errorList) {
                p.println(err.message + "   " + err.file.getAbsolutePath());
            }
        }
    }

    public void notifyProgressStart() {
        this.progressPanel.setVisible(true);
        this.toggleUpdateButton("stop");
    }

    public void notifyProgressDone() {
        this.progressPanel.setVisible(false);
        this.toggleUpdateButton("update");
        this.updateButton.setEnabled(true);
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void notifyNewEntryListAvailable() {
        this.ShowRepository(this.dbPane.getProductEntryList());
    }

    public void notifyNewMapSelectionAvailable() {
        this.dbPane.setSelectionRect(this.worldMapUI.getSelectionBox());
    }

    @Override
    public void notifyDirectoryChanged() {
        this.rescanFolder(new DBScanner.Options(true, false, false));
        this.UpdateUI();
    }

    @Override
    public void notifySelectionChanged() {
        this.updateStatusLabel();
        ProductEntry[] selections = this.getSelectedProductEntries();
        this.productLibraryActions.selectionChanged(selections);
        this.productLibraryActions.updateContextMenu(selections);
        this.dbPane.updateProductSelectionText(selections);
        if (selections != null) {
            GeoPos[][] geoBoundaries = new GeoPos[selections.length][4];
            int i = 0;
            for (ProductEntry entry : selections) {
                geoBoundaries[i++] = entry.getGeoBoundary();
            }
            this.worldMapUI.setSelectedGeoBoundaries(geoBoundaries);
        } else {
            this.worldMapUI.setSelectedGeoBoundaries((GeoPos[][])null);
        }
    }

    @Override
    public void notifyOpenAction() {
        this.productLibraryActions.performOpenAction();
    }

    private static class RescanOptions
    extends CheckListDialog {
        private static final String TITLE = "Scan Folder Options";
        private static final String SEARCH_RECURSIVELY = "Search folder recursively?";
        private static final String VERIFY_ZIP_FILES = "Test zip files for errors?";
        private static final String GENERATE_QUICKLOOKS = "Generate quicklooks?";

        RescanOptions() {
            super(TITLE);
        }

        @Override
        protected void initContent() {
            this.items.put(SEARCH_RECURSIVELY, true);
            this.items.put(VERIFY_ZIP_FILES, false);
            this.items.put(GENERATE_QUICKLOOKS, false);
            super.initContent();
        }

        public boolean shouldDoRecusive() {
            return (Boolean)this.items.get(SEARCH_RECURSIVELY);
        }

        public boolean shouldValidateZips() {
            return (Boolean)this.items.get(VERIFY_ZIP_FILES);
        }

        public boolean shouldDoQuicklooks() {
            return (Boolean)this.items.get(GENERATE_QUICKLOOKS);
        }
    }

    private class MyDatabaseRemoverListener
    implements DBRemover.DBRemoverListener {
        private MyDatabaseRemoverListener() {
        }

        @Override
        public void notifyMSG(DBRemover.DBRemoverListener.MSG msg) {
            if (msg.equals((Object)DBRemover.DBRemoverListener.MSG.DONE)) {
                ProductLibraryToolView.this.setUIComponentsEnabled(ProductLibraryToolView.this.repositoryListCombo.getItemCount() > 1);
                ProductLibraryToolView.this.UpdateUI();
            }
        }
    }

    private class MyDatabaseScannerListener
    implements DBScanner.DBScannerListener {
        private MyDatabaseScannerListener() {
        }

        @Override
        public void notifyMSG(DBScanner dbScanner, DBScanner.DBScannerListener.MSG msg) {
            List<DBScanner.ErrorFile> errorList;
            if (msg.equals((Object)DBScanner.DBScannerListener.MSG.DONE) && !(errorList = dbScanner.getErrorList()).isEmpty()) {
                ProductLibraryToolView.handleErrorList(errorList);
            }
            ProductLibraryToolView.this.UpdateUI();
        }
    }
}

