/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.util.FileIOUtils;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;

public class ProductFileHandler
extends SwingWorker {
    private static final String[] singleFileExt = new String[]{"n1", "e1", "e2", "tif", "tiff", "zip"};
    private static final String[] folderExt = new String[]{"safe"};
    private static final String[] folderMissions = new String[]{"RS2", "TSX", "TDX", "CSKS1", "CSKS2", "CSKS3", "CSKS4", "ALOS", "JERS1", "RS1"};
    private final ProductEntry[] entries;
    private final TYPE operationType;
    private final File targetFolder;
    private final ProgressMonitor pm;
    private final List<ProductFileHandlerListener> listenerList = new ArrayList<ProductFileHandlerListener>(1);
    private final List<DBScanner.ErrorFile> errorList = new ArrayList<DBScanner.ErrorFile>();

    public ProductFileHandler(ProductEntry[] entries, TYPE operationType, File targetFolder, ProgressMonitor pm) {
        this.entries = entries;
        this.operationType = operationType;
        this.targetFolder = targetFolder;
        this.pm = pm;
    }

    public TYPE getOperationType() {
        return this.operationType;
    }

    public void addListener(ProductFileHandlerListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void notifyMSG(ProductFileHandlerListener.MSG msg) {
        for (ProductFileHandlerListener listener : this.listenerList) {
            listener.notifyMSG(this, msg);
        }
    }

    private String getOperationStr() {
        if (this.operationType.equals((Object)TYPE.COPY_TO)) {
            return "Copying";
        }
        if (this.operationType.equals((Object)TYPE.MOVE_TO)) {
            return "Moving";
        }
        if (this.operationType.equals((Object)TYPE.DELETE)) {
            return "Deleting";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground() throws Exception {
        this.errorList.clear();
        try {
            this.pm.beginTask(this.getOperationStr() + " products...", this.entries.length);
            for (ProductEntry entry : this.entries) {
                if (this.pm.isCanceled()) {
                    break;
                }
                try {
                    if (this.operationType.equals((Object)TYPE.COPY_TO)) {
                        ProductFileHandler.copyTo(entry, this.targetFolder);
                    } else if (this.operationType.equals((Object)TYPE.MOVE_TO)) {
                        ProductFileHandler.moveTo(entry, this.targetFolder);
                    } else if (this.operationType.equals((Object)TYPE.DELETE)) {
                        ProductFileHandler.delete(entry);
                    }
                    this.pm.worked(1);
                }
                catch (Exception e) {
                    this.errorList.add(new DBScanner.ErrorFile(entry.getFile(), this.getOperationStr() + " file failed: " + e.getMessage()));
                }
            }
        }
        catch (Throwable e) {
            System.out.println("File Handling Exception\n" + e.getMessage());
        }
        finally {
            this.pm.done();
        }
        return true;
    }

    @Override
    public void done() {
        this.notifyMSG(ProductFileHandlerListener.MSG.DONE);
    }

    public List<DBScanner.ErrorFile> getErrorList() {
        return this.errorList;
    }

    public static boolean canMove(ProductEntry entry) {
        return ProductFileHandler.isDimap(entry) || ProductFileHandler.isFolderProduct(entry) || ProductFileHandler.isSingleFile(entry) || ProductFileHandler.isSMOS(entry);
    }

    private static void copyTo(ProductEntry entry, File targetFolder) throws Exception {
        if (ProductFileHandler.isSingleFile(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (ProductFileHandler.isDimap(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File oldDataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            File newDataFolder = new File(targetFolder, dataFolderName);
            FileIOUtils.copyFolder((Path)oldDataFolder.toPath(), (Path)newDataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.copy(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            File newHdrFile = new File(targetFolder, hdrFile.getName());
            Files.copy(hdrFile.toPath(), newHdrFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getParentFile().getName());
            FileIOUtils.copyFolder((Path)entry.getFile().getParentFile().toPath(), (Path)newFile.toPath());
        }
    }

    public static void moveTo(ProductEntry entry, File targetFolder) throws Exception {
        if (ProductFileHandler.isSingleFile(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        } else if (ProductFileHandler.isDimap(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File oldDataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            File newDataFolder = new File(targetFolder, dataFolderName);
            FileIOUtils.moveFolder((Path)oldDataFolder.toPath(), (Path)newDataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getName());
            Files.move(entry.getFile().toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            File newHdrFile = new File(targetFolder, hdrFile.getName());
            Files.move(hdrFile.toPath(), newHdrFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            File newFile = new File(targetFolder, entry.getFile().getParentFile().getName());
            FileIOUtils.moveFolder((Path)entry.getFile().getParentFile().toPath(), (Path)newFile.toPath());
        }
    }

    public static void delete(ProductEntry entry) throws Exception {
        if (ProductFileHandler.isDimap(entry)) {
            Files.delete(entry.getFile().toPath());
            String dataFolderName = entry.getFile().getName().replace(".dim", ".data");
            File dataFolder = new File(entry.getFile().getParentFile(), dataFolderName);
            FileIOUtils.deleteFolder((Path)dataFolder.toPath());
        } else if (ProductFileHandler.isSMOS(entry)) {
            Files.delete(entry.getFile().toPath());
            File hdrFile = FileUtils.exchangeExtension((File)entry.getFile(), (String)".HDR");
            Files.delete(hdrFile.toPath());
        } else if (ProductFileHandler.isFolderProduct(entry)) {
            FileIOUtils.deleteFolder((Path)entry.getFile().getParentFile().toPath());
        } else if (ProductFileHandler.isSingleFile(entry)) {
            Files.delete(entry.getFile().toPath());
        }
    }

    private static boolean isDimap(ProductEntry entry) {
        return entry.getFile().getName().endsWith(".dim");
    }

    private static boolean isSMOS(ProductEntry entry) {
        return entry.getFile().getName().toUpperCase().endsWith("DBL");
    }

    private static boolean isSingleFile(ProductEntry entry) {
        String fileName = entry.getFile().getName().toLowerCase();
        for (String ext : singleFileExt) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFolderProduct(ProductEntry entry) {
        String mission = entry.getMission();
        for (String folderMission : folderMissions) {
            if (!mission.equals(folderMission)) continue;
            return true;
        }
        String fileName = entry.getFile().getName().toLowerCase();
        for (String ext : folderExt) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return (mission.equals("ERS1") || mission.equals("ERS2")) && !ProductFileHandler.isSingleFile(entry);
    }

    public static interface ProductFileHandlerListener {
        public void notifyMSG(ProductFileHandler var1, MSG var2);

        public static enum MSG {
            DONE;

        }
    }

    public static enum TYPE {
        COPY_TO,
        MOVE_TO,
        DELETE;

    }
}

