/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

public final class AsarAbstractMetadata {
    public static final String ABSTRACTED_METADATA_ROOT_NAME = "Abstracted_Metadata";
    private static final String METADATA_VERSION = "5.0";
    private final String _productType;
    private final String _version;
    private final File _file;

    AsarAbstractMetadata(String type, String ver, File file) {
        this._productType = type;
        this._version = ver;
        this._file = file;
    }

    void addAbstractedMetadataHeader(Product product, MetadataElement root) {
        MetadataElement dopplerCentroidCoeffsADS;
        MetadataElement dsd;
        MetadataElement ads;
        MetadataElement mppAds;
        MetadataElement absRoot = new MetadataElement(ABSTRACTED_METADATA_ROOT_NAME);
        product.getMetadataRoot().addElementAt(absRoot, 0);
        MetadataElement mph = root.getElement("MPH");
        MetadataElement sph = root.getElement("SPH");
        String productType = product.getProductType();
        boolean waveProduct = false;
        if (productType.equals("ASA_WVI_1P") || productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVW_2P")) {
            waveProduct = true;
        }
        if ((mppAds = root.getElement("MAIN_PROCESSING_PARAMS_ADS")) != null && (ads = mppAds.getElement("MAIN_PROCESSING_PARAMS_ADS.1")) != null) {
            mppAds = ads;
        }
        AsarAbstractMetadata.addAbstractedAttribute("PRODUCT", mph.getAttributeString("PRODUCT", ""), absRoot, "Product name");
        AsarAbstractMetadata.addAbstractedAttribute("PRODUCT_TYPE", this._productType, absRoot, "Product type");
        AsarAbstractMetadata.addAbstractedAttribute("SPH_DESCRIPTOR", sph.getAttributeString("SPH_DESCRIPTOR", ""), absRoot, "Description");
        AsarAbstractMetadata.addAbstractedAttribute("MISSION", AsarAbstractMetadata.getMission(this._productType, this._file), absRoot, "Satellite mission");
        String mode = "Stripmap";
        if (productType.startsWith("ASA_WS")) {
            mode = "ScanSAR";
        }
        AsarAbstractMetadata.addAbstractedAttribute("ACQUISITION_MODE", mode, absRoot, "Acquisition mode");
        AsarAbstractMetadata.addAbstractedAttribute("BEAMS", " ", absRoot, "Beams used");
        if (waveProduct) {
            AsarAbstractMetadata.addAbstractedAttribute("SWATH", sph.getAttributeString("SWATH_1", ""), absRoot, "Swath name");
        } else {
            AsarAbstractMetadata.addAbstractedAttribute("SWATH", sph.getAttributeString("SWATH", ""), absRoot, "Swath Name");
        }
        AsarAbstractMetadata.addAbstractedAttribute("PROC_TIME", mph.getAttributeUTC("PROC_TIME", new ProductData.UTC(0.0)), absRoot, "Processed time");
        AsarAbstractMetadata.addAbstractedAttribute("Processing_system_identifier", mph.getAttributeString("SOFTWARE_VER", ""), absRoot, "Processing system identifier");
        AsarAbstractMetadata.addAbstractedAttribute(mph, "CYCLE", absRoot, "Cycle");
        AsarAbstractMetadata.addAbstractedAttribute(mph, "REL_ORBIT", absRoot, "Track");
        AsarAbstractMetadata.addAbstractedAttribute(mph, "ABS_ORBIT", absRoot, "Orbit");
        AsarAbstractMetadata.addAbstractedAttribute("STATE_VECTOR_TIME", mph.getAttributeUTC("STATE_VECTOR_TIME", new ProductData.UTC(0.0)), absRoot, "Time of orbit state vector");
        AsarAbstractMetadata.addAbstractedAttribute("VECTOR_SOURCE", mph.getAttributeString("VECTOR_SOURCE", ""), absRoot, "State vector source");
        AsarAbstractMetadata.addAbstractedAttribute("NUM_SLICES", mph.getAttributeInt("NUM_SLICES", 0), "", absRoot, "Number of slices");
        if (waveProduct) {
            AsarAbstractMetadata.addAbstractedAttribute("first_line_time", sph.getAttributeUTC("first_cell_time", new ProductData.UTC(0.0)), absRoot, "First cell time");
            AsarAbstractMetadata.addAbstractedAttribute("last_line_time", sph.getAttributeUTC("last_cell_time", new ProductData.UTC(0.0)), absRoot, "Last cell time");
            AsarAbstractMetadata.addAbstractedAttribute("first_near_lat", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_near_long", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_far_lat", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_far_long", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_near_lat", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_near_long", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_far_lat", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_far_long", 0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute(sph, "PASS", absRoot, "ASCENDING or DESCENDING");
            AsarAbstractMetadata.addAbstractedAttribute("SAMPLE_TYPE", " ", absRoot, "DETECTED or COMPLEX");
            String mds1_tx_rx_polar = sph.getAttributeString("tx_rx_polar", "");
            mds1_tx_rx_polar = mds1_tx_rx_polar.replace("/", "");
            AsarAbstractMetadata.addAbstractedAttribute("mds1_tx_rx_polar", mds1_tx_rx_polar, absRoot, "Polarization");
            AsarAbstractMetadata.addAbstractedAttribute("mds2_tx_rx_polar", "", absRoot, "Polarization");
            AsarAbstractMetadata.addAbstractedAttribute("mds3_tx_rx_polar", "", absRoot, "Polarization");
            AsarAbstractMetadata.addAbstractedAttribute("mds4_tx_rx_polar", "", absRoot, "Polarization");
        } else {
            AsarAbstractMetadata.addAbstractedAttribute("first_line_time", sph.getAttributeUTC("first_line_time", new ProductData.UTC(0.0)), absRoot, "First zero doppler azimuth time");
            AsarAbstractMetadata.addAbstractedAttribute("last_line_time", sph.getAttributeUTC("last_line_time", new ProductData.UTC(0.0)), absRoot, "Last zero doppler azimuth time");
            double million = 1000000.0;
            AsarAbstractMetadata.addAbstractedAttribute("first_near_lat", sph.getAttributeDouble("first_near_lat", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_near_long", sph.getAttributeDouble("first_near_long", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_far_lat", sph.getAttributeDouble("first_far_lat", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("first_far_long", sph.getAttributeDouble("first_far_long", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_near_lat", sph.getAttributeDouble("last_near_lat", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_near_long", sph.getAttributeDouble("last_near_long", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_far_lat", sph.getAttributeDouble("last_far_lat", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("last_far_long", sph.getAttributeDouble("last_far_long", 0.0) / 1000000.0, "deg", absRoot, "");
            AsarAbstractMetadata.addAbstractedAttribute("PASS", sph.getAttributeString("PASS", ""), absRoot, "ASCENDING or DESCENDING");
            AsarAbstractMetadata.addAbstractedAttribute("SAMPLE_TYPE", sph.getAttributeString("SAMPLE_TYPE").trim(), absRoot, "DETECTED or COMPLEX");
            String mds1_tx_rx_polar = sph.getAttributeString("mds1_tx_rx_polar", "");
            mds1_tx_rx_polar = mds1_tx_rx_polar.replace("/", "");
            AsarAbstractMetadata.addAbstractedAttribute("mds1_tx_rx_polar", mds1_tx_rx_polar, absRoot, "Polarization");
            String mds2_tx_rx_polar = sph.getAttributeString("mds2_tx_rx_polar", "");
            mds2_tx_rx_polar = mds2_tx_rx_polar.replace("/", "");
            AsarAbstractMetadata.addAbstractedAttribute("mds2_tx_rx_polar", mds2_tx_rx_polar, absRoot, "Polarization");
            AsarAbstractMetadata.addAbstractedAttribute("mds3_tx_rx_polar", "", absRoot, "Polarization");
            AsarAbstractMetadata.addAbstractedAttribute("mds4_tx_rx_polar", "", absRoot, "Polarization");
        }
        AsarAbstractMetadata.addAbstractedAttribute("polsar_data", "0", absRoot, "Polarimetric Matrix");
        AsarAbstractMetadata.addAbstractedAttribute("algorithm", sph.getAttributeString("ALGORITHM", ""), absRoot, "Processing algorithm");
        AsarAbstractMetadata.addAbstractedAttribute("azimuth_looks", sph.getAttributeDouble("azimuth_looks", 0.0), "", absRoot, "");
        AsarAbstractMetadata.addAbstractedAttribute("range_looks", sph.getAttributeDouble("range_looks", 0.0), "", absRoot, "");
        AsarAbstractMetadata.addAbstractedAttribute("range_spacing", sph.getAttributeDouble("range_spacing", 0.0), "m", absRoot, "Range sample spacing");
        AsarAbstractMetadata.addAbstractedAttribute("azimuth_spacing", sph.getAttributeDouble("azimuth_spacing", 0.0), "m", absRoot, "Azimuth sample spacing");
        if (mppAds != null) {
            AsarAbstractMetadata.addAbstractedAttribute("pulse_repetition_frequency", AsarAbstractMetadata.getPulseRepetitionFreq(mppAds), "Hz", absRoot, "PRF");
            AsarAbstractMetadata.addAbstractedAttribute("radar_frequency", mppAds.getAttributeDouble("radar_freq", 0.0) / 1000000.0, "MHz", absRoot, "Radar frequency");
        } else {
            AsarAbstractMetadata.addAbstractedAttribute("pulse_repetition_frequency", 0, "Hz", absRoot, "PRF");
            AsarAbstractMetadata.addAbstractedAttribute("radar_frequency", 0, "MHz", absRoot, "Radar frequency");
        }
        AsarAbstractMetadata.addAbstractedAttribute("line_time_interval", sph.getAttributeDouble("line_time_interval", 0.0), "s", absRoot, "");
        AsarAbstractMetadata.addAbstractedAttribute("total_size", (int)((float)product.getRawStorageSize() / 1048576.0f), "MB", absRoot, "Total product size");
        if (mppAds != null) {
            MetadataElement gg1;
            AsarAbstractMetadata.addAbstractedAttribute("num_output_lines", product.getSceneRasterHeight(), "lines", absRoot, "Raster height");
            AsarAbstractMetadata.addAbstractedAttribute("num_samples_per_line", product.getSceneRasterWidth(), "samples", absRoot, "Raster width");
            AsarAbstractMetadata.addAbstractedAttribute("subset_offset_x", 0, "samples", absRoot, "X coordinate of UL corner of subset in original image");
            AsarAbstractMetadata.addAbstractedAttribute("subset_offset_y", 0, "samples", absRoot, "Y coordinate of UL corner of subset in original image");
            AsarAbstractMetadata.addAbstractedAttribute(mppAds, "srgr_flag", absRoot, "SRGR applied");
            AsarAbstractMetadata.addAbstractedAttribute("avg_scene_height", mppAds.getAttributeDouble("avg_scene_height_ellpsoid", 0.0), "m", absRoot, "Average scene height ellipsoid");
            String mapProjection = "";
            String geoRefSystem = "";
            if (productType.contains("APG") || productType.contains("IMG")) {
                MetadataElement mapGads = root.getElement("MAP_PROJECTION_GADS");
                mapProjection = mapGads.getAttributeString("map_descriptor", "Geocoded");
                geoRefSystem = mapGads.getAttributeString("ellipsoid_name", "WGS84");
            }
            AsarAbstractMetadata.addAbstractedAttribute("map_projection", mapProjection, absRoot, "Map projection applied");
            AsarAbstractMetadata.addAbstractedAttribute("is_terrain_corrected", 0, "flag", absRoot, "orthorectification applied");
            AsarAbstractMetadata.addAbstractedAttribute("DEM", "", absRoot, "Digital Elevation Model used");
            AsarAbstractMetadata.addAbstractedAttribute("geo_ref_system", geoRefSystem, absRoot, "geographic reference system");
            AsarAbstractMetadata.addAbstractedAttribute("lat_pixel_res", 0.0, "deg", absRoot, "pixel resolution in geocoded image");
            AsarAbstractMetadata.addAbstractedAttribute("lon_pixel_res", 0.0, "deg", absRoot, "pixel resolution in geocoded image");
            MetadataElement gg = root.getElement("GEOLOCATION_GRID_ADS");
            double slantRangeDist = 0.0;
            if (gg != null && (gg1 = gg.getElement("GEOLOCATION_GRID_ADS.1")) != null) {
                double slantRangeTime = gg1.getAttributeDouble("ASAR_Geo_Grid_ADSR.sd/first_line_tie_points.slant_range_times");
                double halfLightSpeed = 1.49896229E8;
                slantRangeDist = slantRangeTime * 1.49896229E8 / 1.0E9;
            }
            AsarAbstractMetadata.addAbstractedAttribute("slant_range_to_first_pixel", slantRangeDist, "m", absRoot, "Slant range to 1st data sample");
            AsarAbstractMetadata.addAbstractedAttribute(mppAds, "ant_elev_corr_flag", absRoot, "Antenna elevation applied");
            AsarAbstractMetadata.addAbstractedAttribute(mppAds, "range_spread_comp_flag", absRoot, "range spread compensation applied");
            AsarAbstractMetadata.addAbstractedAttribute("replica_power_corr_flag", 20, "flag", "Replica pulse power correction applied", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("abs_calibration_flag", 20, "flag", "Product calibrated", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("calibration_factor", mppAds.getAttributeDouble("ASAR_Main_ADSR.sd/calibration_factors.1.ext_cal_fact", 0.0), "", absRoot, "Calibration constant");
            if (productType.startsWith("ASA_AP")) {
                AsarAbstractMetadata.addAbstractedAttribute("calibration_factor.2", mppAds.getAttributeDouble("ASAR_Main_ADSR.sd/calibration_factors.2.ext_cal_fact", 0.0), "", absRoot, "Calibration constant");
            }
            AsarAbstractMetadata.addAbstractedAttribute("inc_angle_comp_flag", 0, "flag", absRoot, "incidence angle compensation applied");
            AsarAbstractMetadata.addAbstractedAttribute("ref_inc_angle", 99999.0, "", absRoot, "Reference incidence angle");
            AsarAbstractMetadata.addAbstractedAttribute("ref_slant_range", 99999.0, "", absRoot, "Reference slant range");
            AsarAbstractMetadata.addAbstractedAttribute("ref_slant_range_exp", 99999.0, "", absRoot, "Reference slant range exponent");
            AsarAbstractMetadata.addAbstractedAttribute("rescaling_factor", 99999.0, "", absRoot, "Rescaling factor");
            AsarAbstractMetadata.addAbstractedAttribute("range_sampling_rate", mppAds.getAttributeDouble("range_samp_rate", 0.0) / 1000000.0, "MHz", absRoot, "Range Sampling Rate");
            AsarAbstractMetadata.addAbstractedAttribute("range_bandwidth", mppAds.getAttributeDouble("ASAR_Main_ADSR.sd/bandwidth.tot_bw_range", 0.0) / 1000000.0, "MHz", absRoot, "Bandwidth total in range");
            AsarAbstractMetadata.addAbstractedAttribute("azimuth_bandwidth", mppAds.getAttributeDouble("to_bw_az", 0.0), "Hz", absRoot, "Bandwidth total in azimuth");
            AsarAbstractMetadata.addAbstractedAttribute("multilook_flag", 20, "flag", "Product multilooked", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("coregistered_stack", 20, "flag", "Coregistration applied", absRoot);
        } else {
            AsarAbstractMetadata.addAbstractedAttribute("num_output_lines", 0, "lines", absRoot, "Raster height");
            AsarAbstractMetadata.addAbstractedAttribute("num_samples_per_line", 0, "samples", absRoot, "Raster width");
            AsarAbstractMetadata.addAbstractedAttribute("subset_offset_x", 0, "samples", absRoot, "X coordinate of UL corner of subset in original image");
            AsarAbstractMetadata.addAbstractedAttribute("subset_offset_y", 0, "samples", absRoot, "Y coordinate of UL corner of subset in original image");
            AsarAbstractMetadata.addAbstractedAttribute("num_samples_per_line", 0, "", absRoot, "");
            if (waveProduct) {
                AsarAbstractMetadata.addAbstractedAttribute("srgr_flag", sph.getAttributeInt("SR_GR", 0), "flag", absRoot, "SRGR applied");
            } else {
                AsarAbstractMetadata.addAbstractedAttribute("srgr_flag", 0, "", absRoot, "SRGR applied");
            }
            AsarAbstractMetadata.addAbstractedAttribute("avg_scene_height", 0, "m", absRoot, "Average scene height ellipsoid");
            AsarAbstractMetadata.addAbstractedAttribute("map_projection", " ", absRoot, "Map projection applied");
            AsarAbstractMetadata.addAbstractedAttribute("is_terrain_corrected", 0, "flag", absRoot, "orthorectification applied");
            AsarAbstractMetadata.addAbstractedAttribute("DEM", "", absRoot, "Digital Elevation Model used");
            AsarAbstractMetadata.addAbstractedAttribute("geo_ref_system", "", absRoot, "geographic reference system");
            AsarAbstractMetadata.addAbstractedAttribute("lat_pixel_res", 0.0, "deg", absRoot, "pixel resolution in geocoded image");
            AsarAbstractMetadata.addAbstractedAttribute("lon_pixel_res", 0.0, "deg", absRoot, "pixel resolution in geocoded image");
            AsarAbstractMetadata.addAbstractedAttribute("slant_range_to_first_pixel", 0, "m", absRoot, "Slant range to 1st data sample");
            if (waveProduct) {
                AsarAbstractMetadata.addAbstractedAttribute("ant_elev_corr_flag", sph.getAttributeInt("antenna_corr", 0), "flag", absRoot, "Antenna elevation applied");
            } else {
                AsarAbstractMetadata.addAbstractedAttribute("ant_elev_corr_flag", 0, "", absRoot, "Antenna elevation applied");
            }
            AsarAbstractMetadata.addAbstractedAttribute("range_spread_comp_flag", 0, "", absRoot, "range spread compensation applied");
            AsarAbstractMetadata.addAbstractedAttribute("replica_power_corr_flag", 20, "flag", "Replica pulse power correction applied", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("abs_calibration_flag", 20, "flag", "Product calibrated", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("calibration_factor", 0, "", absRoot, "Calibration constant");
            AsarAbstractMetadata.addAbstractedAttribute("inc_angle_comp_flag", 0, "flag", absRoot, "incidence angle compensation applied");
            AsarAbstractMetadata.addAbstractedAttribute("ref_inc_angle", 99999.0, "", absRoot, "Reference incidence angle");
            AsarAbstractMetadata.addAbstractedAttribute("ref_slant_range", 99999.0, "", absRoot, "Reference slant range");
            AsarAbstractMetadata.addAbstractedAttribute("ref_slant_range_exp", 99999.0, "", absRoot, "Reference slant range exponent");
            AsarAbstractMetadata.addAbstractedAttribute("rescaling_factor", 99999.0, "", absRoot, "Rescaling factor");
            AsarAbstractMetadata.addAbstractedAttribute("range_sampling_rate", 0, "MHz", absRoot, "Range Sampling Rate");
            AsarAbstractMetadata.addAbstractedAttribute("multilook_flag", 20, "flag", "Product multilooked", absRoot);
            AsarAbstractMetadata.addAbstractedAttribute("coregistered_stack", 20, "flag", "Coregistration applied", absRoot);
        }
        MetadataElement chipADS = root.getElement("CHIRP_PARAMS_ADS");
        if (chipADS != null) {
            AsarAbstractMetadata.addAbstractedAttribute("chirp_power", chipADS.getAttributeDouble("chirp_power", 0.0), "dB", absRoot, "Chirp power");
        }
        if ((dsd = root.getElement("DSD")) != null) {
            MetadataElement dsd18;
            MetadataElement dsd17 = dsd.getElement("DSD.17");
            if (dsd17 != null) {
                AsarAbstractMetadata.addAbstractedAttribute("external_calibration_file", dsd17.getAttributeString("FILE_NAME", ""), absRoot, "External calibration file used");
            }
            if ((dsd18 = dsd.getElement("DSD.18")) != null) {
                AsarAbstractMetadata.addAbstractedAttribute("orbit_state_vector_file", dsd18.getAttributeString("FILE_NAME", ""), absRoot, "Orbit file used");
            }
        }
        AsarAbstractMetadata.addOrbitStateVectors(root, absRoot);
        MetadataElement srgrADS = root.getElement("SR_GR_ADS");
        if (srgrADS != null) {
            AsarAbstractMetadata.addSRGRCoefficients(srgrADS, absRoot);
        }
        if ((dopplerCentroidCoeffsADS = root.getElement("DOP_CENTROID_COEFFS_ADS")) != null) {
            AsarAbstractMetadata.addDopplerCentroidCoefficients(dopplerCentroidCoeffsADS, absRoot);
        }
        AsarAbstractMetadata.addAbstractedAttribute("abstracted_metadata_version", METADATA_VERSION, absRoot, "AbsMetadata version");
    }

    public static String getMission(String productType, File file) {
        if (productType.startsWith("SAR")) {
            String filename = file.toString().toUpperCase();
            if (filename.endsWith("E2") || filename.endsWith("E2.ZIP")) {
                return "ERS2";
            }
            return "ERS1";
        }
        return "ENVISAT";
    }

    private static void addAbstractedAttribute(String tag, String value, MetadataElement dest, String desc) {
        if (value == null || value.isEmpty()) {
            value = " ";
        }
        MetadataAttribute attribute = new MetadataAttribute(tag, 41, 1);
        attribute.getData().setElems((Object)value);
        attribute.setDescription(desc);
        dest.addAttribute(attribute);
    }

    private static void addAbstractedAttribute(String tag, ProductData.UTC value, MetadataElement dest, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, 51, 1);
        attribute.getData().setElems((Object)value.getArray());
        attribute.setUnit("utc");
        attribute.setDescription(desc);
        dest.addAttribute(attribute);
    }

    private static void addAbstractedAttribute(String tag, int value, String unit, MetadataElement dest, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, 12, 1);
        attribute.getData().setElemInt(value);
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        dest.addAttribute(attribute);
    }

    private static void addAbstractedAttribute(String tag, double value, String unit, MetadataElement dest, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, 31, 1);
        attribute.getData().setElems((Object)new double[]{value});
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        dest.addAttribute(attribute);
    }

    private static MetadataAttribute addAbstractedAttribute(String tag, int dataType, String unit, String desc, MetadataElement dest) {
        MetadataAttribute attribute = new MetadataAttribute(tag, dataType, 1);
        if (dataType == 41) {
            attribute.getData().setElems((Object)" ");
        }
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        attribute.setReadOnly(false);
        dest.addAttribute(attribute);
        return attribute;
    }

    private static void addAbstractedAttribute(MetadataElement src, String tag, MetadataElement dest, String desc) {
        MetadataAttribute attrib = src.getAttribute(tag);
        if (attrib != null) {
            MetadataAttribute copiedAttrib = attrib.createDeepClone();
            copiedAttrib.setReadOnly(false);
            copiedAttrib.setDescription(desc);
            dest.addAttribute(copiedAttrib);
        }
    }

    private static double getPulseRepetitionFreq(MetadataElement mppAds) {
        double prf = mppAds.getAttributeDouble("ASAR_Main_ADSR.sd/image_parameters.prf_value", 0.0);
        if (prf == 0.0) {
            prf = mppAds.getAttributeDouble("ASAR_Main_ADSR.sd/image_parameters_IODD_4A.prf_value", 0.0);
        }
        return prf;
    }

    private static void addOrbitStateVectors(MetadataElement root, MetadataElement dest) {
        MetadataElement orbitListElem = new MetadataElement("Orbit_State_Vectors");
        dest.addElement(orbitListElem);
        MetadataElement rootMPPAds = root.getElement("MAIN_PROCESSING_PARAMS_ADS");
        ArrayList<MetadataElement> mppList = new ArrayList<MetadataElement>(10);
        if (rootMPPAds != null) {
            int numElem = rootMPPAds.getNumElements();
            if (numElem == 0) {
                mppList.add(rootMPPAds);
            } else {
                for (int i = 1; i <= numElem; ++i) {
                    MetadataElement ads = rootMPPAds.getElement("MAIN_PROCESSING_PARAMS_ADS." + i);
                    if (ads == null) continue;
                    mppList.add(ads);
                }
            }
        }
        int i = 1;
        for (MetadataElement mppAds : mppList) {
            AsarAbstractMetadata.addVector(mppAds, orbitListElem, "ASAR_Main_ADSR.sd/orbit_state_vectors.1", "orbit_vector" + i++);
            AsarAbstractMetadata.addVector(mppAds, orbitListElem, "ASAR_Main_ADSR.sd/orbit_state_vectors.2", "orbit_vector" + i++);
            AsarAbstractMetadata.addVector(mppAds, orbitListElem, "ASAR_Main_ADSR.sd/orbit_state_vectors.3", "orbit_vector" + i++);
            AsarAbstractMetadata.addVector(mppAds, orbitListElem, "ASAR_Main_ADSR.sd/orbit_state_vectors.4", "orbit_vector" + i++);
            AsarAbstractMetadata.addVector(mppAds, orbitListElem, "ASAR_Main_ADSR.sd/orbit_state_vectors.5", "orbit_vector" + i++);
        }
    }

    private static void addVector(MetadataElement mppAds, MetadataElement orbitListElem, String orbitPrefix, String tag) {
        double zVel;
        double yVel;
        double xVel;
        double zPos;
        double yPos;
        double xPos;
        ProductData.UTC utcTime;
        try {
            utcTime = mppAds.getAttributeUTC(orbitPrefix + ".state_vect_time_1");
            xPos = mppAds.getAttributeDouble(orbitPrefix + ".x_pos_1") / 100.0;
            yPos = mppAds.getAttributeDouble(orbitPrefix + ".y_pos_1") / 100.0;
            zPos = mppAds.getAttributeDouble(orbitPrefix + ".z_pos_1") / 100.0;
            xVel = mppAds.getAttributeDouble(orbitPrefix + ".x_vel_1") / 100000.0;
            yVel = mppAds.getAttributeDouble(orbitPrefix + ".y_vel_1") / 100000.0;
            zVel = mppAds.getAttributeDouble(orbitPrefix + ".z_vel_1") / 100000.0;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        MetadataElement orbitElem = new MetadataElement(tag);
        orbitListElem.addElement(orbitElem);
        AsarAbstractMetadata.addAbstractedAttribute("time", utcTime, orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("x_pos", xPos, "", orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("y_pos", yPos, "", orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("z_pos", zPos, "", orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("x_vel", xVel, "", orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("y_vel", yVel, "", orbitElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("z_vel", zVel, "", orbitElem, "");
    }

    private static void addSRGRCoefficients(MetadataElement srgrAds, MetadataElement dest) {
        MetadataElement srgrListElem = new MetadataElement("SRGR_Coefficients");
        dest.addElement(srgrListElem);
        int listCnt = 1;
        if (srgrAds.getNumElements() == 0) {
            AsarAbstractMetadata.addOneSetSRGRCoefficients(srgrAds, srgrListElem, listCnt);
        } else {
            for (MetadataElement srgrSrc : srgrAds.getElements()) {
                AsarAbstractMetadata.addOneSetSRGRCoefficients(srgrSrc, srgrListElem, listCnt++);
            }
        }
    }

    private static void addOneSetSRGRCoefficients(MetadataElement srgrSrc, MetadataElement srgrListElem, int listCnt) {
        double origin;
        ProductData.UTC utcTime;
        ArrayList<Double> coefList = new ArrayList<Double>(5);
        try {
            utcTime = srgrSrc.getAttributeUTC("zero_doppler_time");
            origin = srgrSrc.getAttributeDouble("ground_range_origin");
            MetadataAttribute srgrCoefAttrib = srgrSrc.getAttribute("srgr_coeff");
            ProductData data = srgrCoefAttrib.getData();
            int numElems = data.getNumElems();
            for (int i = 0; i < numElems; ++i) {
                coefList.add(data.getElemDoubleAt(i));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        MetadataElement srgrElem = new MetadataElement("srgr_coef_list." + listCnt);
        srgrListElem.addElement(srgrElem);
        AsarAbstractMetadata.addAbstractedAttribute("zero_doppler_time", utcTime, srgrElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("ground_range_origin", origin, "m", srgrElem, "");
        int coefCnt = 1;
        for (Double value : coefList) {
            MetadataElement coefElem = new MetadataElement("coefficient." + coefCnt);
            ++coefCnt;
            srgrElem.addElement(coefElem);
            AsarAbstractMetadata.addAbstractedAttribute("srgr_coef", value, "", coefElem, "");
        }
    }

    private static void addDopplerCentroidCoefficients(MetadataElement dopplerCentroidCoeffsADS, MetadataElement dest) {
        MetadataElement dopplerCentroidCoeffsListElem = new MetadataElement("Doppler_Centroid_Coefficients");
        dest.addElement(dopplerCentroidCoeffsListElem);
        int listCnt = 1;
        if (dopplerCentroidCoeffsADS.getNumElements() == 0) {
            AsarAbstractMetadata.addOneSetDopplerCentroidCoefficients(dopplerCentroidCoeffsADS, dopplerCentroidCoeffsListElem, listCnt);
        } else {
            for (MetadataElement dopplerCentroidSrc : dopplerCentroidCoeffsADS.getElements()) {
                AsarAbstractMetadata.addOneSetDopplerCentroidCoefficients(dopplerCentroidSrc, dopplerCentroidCoeffsListElem, listCnt++);
            }
        }
    }

    private static void addOneSetDopplerCentroidCoefficients(MetadataElement dopplerCentroidSrc, MetadataElement dopplerCentroidCoeffsListElem, int listCnt) {
        double origin;
        ProductData.UTC utcTime;
        ArrayList<Double> coefList = new ArrayList<Double>(5);
        try {
            utcTime = dopplerCentroidSrc.getAttributeUTC("zero_doppler_time");
            origin = dopplerCentroidSrc.getAttributeDouble("slant_range_time");
            MetadataAttribute dopCoefAttrib = dopplerCentroidSrc.getAttribute("dop_coef");
            ProductData data = dopCoefAttrib.getData();
            int numElems = data.getNumElems();
            for (int i = 0; i < numElems; ++i) {
                coefList.add(data.getElemDoubleAt(i));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        MetadataElement dopElem = new MetadataElement("dop_coef_list." + listCnt);
        dopplerCentroidCoeffsListElem.addElement(dopElem);
        AsarAbstractMetadata.addAbstractedAttribute("zero_doppler_time", utcTime, dopElem, "");
        AsarAbstractMetadata.addAbstractedAttribute("slant_range_time", origin, "ns", dopElem, "");
        int coefCnt = 1;
        for (Double value : coefList) {
            MetadataElement coefElem = new MetadataElement("coefficient." + coefCnt);
            ++coefCnt;
            dopElem.addElement(coefElem);
            AsarAbstractMetadata.addAbstractedAttribute("dop_coef", value, "", coefElem, "");
        }
    }
}

