/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.media.jai.JAI;
import org.apache.commons.lang.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.smart.configurator.JavaSystemInfos;
import org.esa.snap.smart.configurator.VMParameters;

public class PerformanceParameters {
    private static final String SYSPROP_READER_TILE_WIDTH = "snap.dataio.reader.tileWidth";
    private static final String SYSPROP_READER_TILE_HEIGHT = "snap.dataio.reader.tileHeight";
    private static final String PROPERTY_JAI_CACHE_SIZE = "snap.jai.tileCacheSize";
    private VMParameters vmParameters;
    private Path cachePath;
    private int nbThreads;
    private String tileWidth;
    private String tileHeight;
    private int cacheSize;

    public PerformanceParameters() {
        this.vmParameters = new VMParameters("");
    }

    public PerformanceParameters(PerformanceParameters clone) {
        this.setVMParameters(clone.vmParameters.toString());
        this.setCachePath(clone.getCachePath());
        this.setNbThreads(clone.getNbThreads());
        this.setTileHeight(clone.getTileHeight());
        this.setTileWidth(clone.getTileWidth());
        this.setCacheSize(clone.getCacheSize());
    }

    public void setVmXMX(long vmXMX) {
        this.vmParameters.setVmXMX(vmXMX);
    }

    public void setVmXMS(long vmXMS) {
        this.vmParameters.setVmXMS(vmXMS);
    }

    public long getVmXMX() {
        return this.vmParameters.getVmXMX();
    }

    public Path getCachePath() {
        return this.cachePath;
    }

    public void setCachePath(Path largeTileCache) {
        this.cachePath = largeTileCache;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public void setNbThreads(int nbThreads) {
        this.nbThreads = nbThreads;
    }

    public String getVMParameters() {
        return this.vmParameters.toString();
    }

    public void setVMParameters(String vmParametersLine) {
        this.vmParameters = new VMParameters(vmParametersLine);
    }

    public String getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(String tileWidth) {
        this.tileWidth = tileWidth;
    }

    public String getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(String tileHeight) {
        this.tileHeight = tileHeight;
    }

    public String getTileDimension() {
        if (this.tileHeight == null || this.tileWidth == null) {
            return null;
        }
        String dimension = this.tileWidth;
        if (this.tileHeight.compareTo(this.tileWidth) != 0) {
            dimension = dimension + "," + this.tileHeight;
        }
        return dimension;
    }

    public void setTileDimension(String dimension) {
        this.tileWidth = PerformanceParameters.getWidthFromTileDimensionString(dimension);
        this.tileHeight = PerformanceParameters.getHeightFromTileDimensionString(dimension);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    static synchronized PerformanceParameters loadConfiguration() {
        Config configuration = Config.instance().load();
        Preferences preferences = configuration.preferences();
        PerformanceParameters actualParameters = new PerformanceParameters();
        VMParameters netBeansVmParameters = VMParameters.load();
        actualParameters.setVMParameters(netBeansVmParameters.toString());
        actualParameters.setCachePath(SystemUtils.getCacheDir().toPath());
        int defaultNbThreads = JavaSystemInfos.getInstance().getNbCPUs();
        actualParameters.setNbThreads(preferences.getInt(SystemUtils.SNAP_PARALLELISM_PROPERTY_NAME, defaultNbThreads));
        actualParameters.setTileWidth(preferences.get(SYSPROP_READER_TILE_WIDTH, null));
        actualParameters.setTileHeight(preferences.get(SYSPROP_READER_TILE_HEIGHT, null));
        actualParameters.setCacheSize(preferences.getInt(PROPERTY_JAI_CACHE_SIZE, 1024));
        return actualParameters;
    }

    static synchronized void saveConfiguration(PerformanceParameters confToSave) throws IOException, BackingStoreException {
        if (!PerformanceParameters.loadConfiguration().getVMParameters().equals(confToSave.getVMParameters())) {
            confToSave.vmParameters.save();
        }
        EngineConfig configuration = EngineConfig.instance().load();
        Preferences preferences = configuration.preferences();
        Path cachePath = confToSave.getCachePath();
        if (!Files.exists(cachePath, new LinkOption[0])) {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        if (Files.exists(cachePath, new LinkOption[0])) {
            preferences.put(SystemUtils.SNAP_CACHE_DIR_PROPERTY_NAME, cachePath.toAbsolutePath().toString());
        } else {
            SystemUtils.LOG.severe("Directory for cache path does not exist");
        }
        JAI ff = JAI.getDefaultInstance();
        int parallelism = confToSave.getNbThreads();
        int jaiCacheSize = confToSave.getCacheSize();
        String tileWidth = confToSave.getTileWidth();
        String tileHeight = confToSave.getTileHeight();
        preferences.putInt(SystemUtils.SNAP_PARALLELISM_PROPERTY_NAME, parallelism);
        preferences.putInt(PROPERTY_JAI_CACHE_SIZE, jaiCacheSize);
        preferences.flush();
        JAIUtils.setDefaultTileCacheCapacity((int)jaiCacheSize);
        JAI.getDefaultInstance().getTileScheduler().setParallelism(parallelism);
    }

    public static String getWidthFromTileDimensionString(String dimension) {
        if (dimension == null) {
            return null;
        }
        String[] splitted = StringUtils.split((String)dimension, (char)',');
        if (splitted.length <= 0) {
            return null;
        }
        return splitted[0];
    }

    public static String getHeightFromTileDimensionString(String dimension) {
        if (dimension == null) {
            return null;
        }
        String[] splitted = StringUtils.split((String)dimension, (char)',');
        if (splitted.length <= 0) {
            return null;
        }
        if (splitted.length > 1) {
            return splitted[1];
        }
        return splitted[0];
    }

    public static String getDimensionStringFromWidthAndHeight(String width, String height) {
        if (height == null || width == null) {
            return null;
        }
        if (height.compareTo(width) == 0) {
            return height;
        }
        return width + "," + height;
    }

    public static boolean isValidDimension(String dimension) {
        if (dimension == null) {
            return false;
        }
        String[] splitted = StringUtils.split((String)dimension, (char)',');
        if (splitted.length > 2 || splitted.length <= 0) {
            return false;
        }
        for (String dimensionSubstring : splitted) {
            if (PerformanceParameters.isValidDimensionSubstring(dimensionSubstring)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidDimensionSubstring(String dimensionSubstring) {
        block4: {
            if (dimensionSubstring == null) {
                return false;
            }
            try {
                int width = Integer.parseInt(dimensionSubstring);
                if (width <= 0) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                if (dimensionSubstring.compareTo("*") == 0) break block4;
                return false;
            }
        }
        return true;
    }
}

