/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import org.esa.snap.smart.configurator.PerformanceParameters;

public class BenchmarkSingleCalculus
implements Comparable<BenchmarkSingleCalculus> {
    private String tileWidth;
    private String tileHeight;
    private int cacheSize;
    private int nbThreads;
    private Long executionTime;
    private boolean hideOutput;
    private int executionOrder;

    public BenchmarkSingleCalculus(String tileHeight, String tileWidth, int cacheSize, int nbThreads) {
        this(tileHeight, tileWidth, cacheSize, nbThreads, false);
    }

    public BenchmarkSingleCalculus(String dimension, int cacheSize, int nbThreads) {
        this(dimension, cacheSize, nbThreads, false);
    }

    public BenchmarkSingleCalculus(String tileHeight, String tileWidth, int cacheSize, int nbThreads, boolean hideOutput) {
        this.tileHeight = tileHeight;
        this.tileWidth = tileWidth;
        this.cacheSize = cacheSize;
        this.nbThreads = nbThreads;
        this.hideOutput = hideOutput;
        this.executionTime = null;
    }

    public BenchmarkSingleCalculus(String dimension, int cacheSize, int nbThreads, boolean hideOutput) {
        this(PerformanceParameters.getHeightFromTileDimensionString(dimension), PerformanceParameters.getWidthFromTileDimensionString(dimension), cacheSize, nbThreads, hideOutput);
    }

    public String toString() {
        String toDiaplay = "(" + this.getDimensionString() + ", " + this.getCacheSize() + ", " + this.nbThreads + ") = ";
        toDiaplay = this.executionTime != null ? toDiaplay + this.executionTime + " ms" : toDiaplay + "not computed";
        return toDiaplay;
    }

    public static String[] getColumnNames() {
        String[] columnsNames = new String[]{"Execution Order", "Tile Width", "Tile Height", "Cache size", "Nb threads", "Execution time"};
        return columnsNames;
    }

    public static String[] getColumnNamesWithoutTileSize() {
        String[] columnsNames = new String[]{"Execution Order", "Cache size", "Nb threads", "Execution time"};
        return columnsNames;
    }

    public int[] getData() {
        int execution = -1;
        if (this.executionTime != null) {
            execution = this.executionTime.intValue();
        }
        int tileHeight = -1;
        int tileWidth = -1;
        try {
            tileHeight = Integer.parseInt(this.tileHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tileWidth = Integer.parseInt(this.tileWidth);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] calculus = new int[]{this.executionOrder, tileWidth, tileHeight, this.cacheSize, this.nbThreads, execution};
        return calculus;
    }

    public int[] getDataWithoutTileSize() {
        int execution = -1;
        if (this.executionTime != null) {
            execution = this.executionTime.intValue();
        }
        int[] calculus = new int[]{this.executionOrder, this.cacheSize, this.nbThreads, execution};
        return calculus;
    }

    @Override
    public int compareTo(BenchmarkSingleCalculus compareBenchmarkSingleCalcul) {
        Long compareExecutionTime = compareBenchmarkSingleCalcul.executionTime;
        int order = compareExecutionTime == null && this.executionTime == null ? 0 : (compareExecutionTime == null ? -1 : (this.executionTime == null ? 1 : (compareExecutionTime < this.executionTime ? 1 : -1)));
        return order;
    }

    public String getTileWidth() {
        return this.tileWidth;
    }

    public String getTileHeight() {
        return this.tileHeight;
    }

    public String getDimensionString() {
        return PerformanceParameters.getDimensionStringFromWidthAndHeight(this.tileWidth, this.tileHeight);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setHideOutput(boolean hide) {
        this.hideOutput = hide;
    }

    public boolean isHidden() {
        return this.hideOutput;
    }

    public boolean hasIdenticalParameters(BenchmarkSingleCalculus benchmarkSingleCalculus) {
        if (this.nbThreads != benchmarkSingleCalculus.getNbThreads()) {
            return false;
        }
        if (this.cacheSize != benchmarkSingleCalculus.getCacheSize()) {
            return false;
        }
        return this.hideOutput == benchmarkSingleCalculus.isHidden();
    }

    public void setExecutionOrder(int executionOrder) {
        this.executionOrder = executionOrder;
    }
}

