/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.tile;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TileUtilities {
    public static final String EDITOR_MODE_NAME_FORMAT = "editor_r%dc%d";
    public static final int MAX_TILE_ROW_COUNT = 16;
    public static final int MAX_TILE_COLUMN_COUNT = 16;

    public static boolean openInEditorMode(TopComponent topComponent, int rowIndex, int colIndex) {
        String modeName = String.format(EDITOR_MODE_NAME_FORMAT, rowIndex, colIndex);
        return TileUtilities.openInMode(topComponent, modeName);
    }

    public static boolean openInMode(TopComponent topComponent, String modeName) {
        Mode mode = WindowManager.getDefault().findMode(modeName);
        if (mode != null) {
            if (!Arrays.asList(mode.getTopComponents()).contains(topComponent)) {
                if (mode.dockInto(topComponent)) {
                    topComponent.open();
                    return true;
                }
            } else {
                topComponent.open();
                return true;
            }
        }
        return false;
    }

    public static int countOpenEditorWindows() {
        int count = 0;
        WindowManager wm = WindowManager.getDefault();
        Set opened = wm.getRegistry().getOpened();
        for (TopComponent openedWindow : opened) {
            if (!wm.isEditorTopComponent(openedWindow)) continue;
            ++count;
        }
        return count;
    }

    public static List<TopComponent> findOpenEditorWindows() {
        return TileUtilities.findOpenEditorWindows((win1, win2) -> {
            String name1 = win1.getDisplayName();
            String name2 = win2.getDisplayName();
            return (name1 != null ? name1 : "").compareTo(name2 != null ? name2 : "");
        });
    }

    public static List<TopComponent> findOpenEditorWindows(Comparator<TopComponent> comparator) {
        ArrayList<TopComponent> editorWindows = new ArrayList<TopComponent>();
        Set openedWindows = WindowManager.getDefault().getRegistry().getOpened();
        editorWindows.addAll(openedWindows.stream().filter(topComponent -> WindowManager.getDefault().isEditorTopComponent(topComponent)).collect(Collectors.toList()));
        if (comparator != null) {
            editorWindows.sort(comparator);
        }
        return editorWindows;
    }

    public static Dimension computeMatrixSizeForEqualAreaTiling(int windowCount) {
        double minDeltaValue = Double.POSITIVE_INFINITY;
        int bestRowCount = -1;
        int bestColCount = -1;
        block0: for (int rowCount = 1; rowCount <= Math.min(windowCount, 16); ++rowCount) {
            for (int colCount = 1; colCount <= Math.min(windowCount, 16); ++colCount) {
                double deltaCount;
                double deltaRatio;
                double deltaValue;
                if (colCount * rowCount < windowCount || colCount * rowCount > 2 * windowCount || !((deltaValue = (deltaRatio = Math.abs(1.0 - (double)rowCount / (double)colCount)) + (deltaCount = Math.abs(1.0 - (double)(colCount * rowCount) / (double)windowCount))) < minDeltaValue)) continue;
                minDeltaValue = deltaValue;
                bestRowCount = rowCount;
                bestColCount = colCount;
                if (deltaValue == 0.0) continue block0;
            }
        }
        return new Dimension(bestColCount, bestRowCount);
    }
}

