/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.dimap.DimapHeaderWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.FilterBand;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.dataio.bigtiff.internal.GeoTiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffAscii;
import org.esa.snap.dataio.bigtiff.internal.TiffCode;
import org.esa.snap.dataio.bigtiff.internal.TiffDirectoryEntry;
import org.esa.snap.dataio.bigtiff.internal.TiffDirectoryEntrySet;
import org.esa.snap.dataio.bigtiff.internal.TiffDouble;
import org.esa.snap.dataio.bigtiff.internal.TiffLong;
import org.esa.snap.dataio.bigtiff.internal.TiffRational;
import org.esa.snap.dataio.bigtiff.internal.TiffShort;
import org.esa.snap.dataio.bigtiff.internal.TiffTag;
import org.esa.snap.dataio.bigtiff.internal.TiffValue;

public class TiffIFD {
    private static final int TIFF_COLORMAP_SIZE = 256;
    private static final int BYTES_FOR_NEXT_IFD_OFFSET = 4;
    private static final int BYTES_FOR_NUMBER_OF_ENTRIES = 2;
    private final TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
    private int maxElemSizeBandDataType;

    public TiffIFD(Product product) {
        this.initEntrys(product);
    }

    public void write(ImageOutputStream ios, long ifdOffset, long nextIfdOffset) throws IOException {
        Guardian.assertGreaterThan((String)"ifdOffset", (long)ifdOffset, (long)-1L);
        this.computeOffsets(ifdOffset);
        ios.seek(ifdOffset);
        TiffDirectoryEntry[] entries = this.entrySet.getEntries();
        new TiffShort(entries.length).write(ios);
        long entryPosition = ios.getStreamPosition();
        for (TiffDirectoryEntry entry : entries) {
            ios.seek(entryPosition);
            entry.write(ios);
            entryPosition += 12L;
        }
        this.writeNextIfdOffset(ios, ifdOffset, nextIfdOffset);
    }

    private void writeNextIfdOffset(ImageOutputStream ios, long ifdOffset, long nextIfdOffset) throws IOException {
        ios.seek(this.getPosForNextIfdOffset(ifdOffset));
        new TiffLong(nextIfdOffset).write(ios);
    }

    private long getPosForNextIfdOffset(long ifdOffset) {
        return ifdOffset + this.getRequiredIfdSize() - 4L;
    }

    public TiffDirectoryEntry getEntry(TiffShort tag) {
        return this.entrySet.getEntry(tag);
    }

    public long getRequiredIfdSize() {
        TiffDirectoryEntry[] entries = this.entrySet.getEntries();
        return 2 + entries.length * 12 + 4;
    }

    public long getRequiredReferencedValuesSize() {
        TiffDirectoryEntry[] entries = this.entrySet.getEntries();
        long size = 0L;
        for (TiffDirectoryEntry entry : entries) {
            if (!entry.mustValuesBeReferenced()) continue;
            size += entry.getValuesSizeInBytes();
        }
        return size;
    }

    public long getRequiredSizeForStrips() {
        TiffLong[] counts = (TiffLong[])this.getEntry(TiffTag.STRIP_BYTE_COUNTS).getValues();
        long size = 0L;
        for (TiffLong count : counts) {
            size += count.getValue();
        }
        return size;
    }

    public long getRequiredEntireSize() {
        return this.getRequiredIfdSize() + this.getRequiredReferencedValuesSize() + this.getRequiredSizeForStrips();
    }

    private void computeOffsets(long ifdOffset) {
        TiffDirectoryEntry[] entries = this.entrySet.getEntries();
        long valuesOffset = this.computeStartOffsetForValues(entries.length, ifdOffset);
        for (TiffDirectoryEntry entry : entries) {
            if (!entry.mustValuesBeReferenced()) continue;
            entry.setValuesOffset(valuesOffset);
            valuesOffset += entry.getValuesSizeInBytes();
        }
        this.moveStripsTo(valuesOffset);
    }

    private void moveStripsTo(long stripsStart) {
        TiffLong[] values = (TiffLong[])this.getEntry(TiffTag.STRIP_OFFSETS).getValues();
        for (int i = 0; i < values.length; ++i) {
            long oldValue = values[i].getValue();
            long newValue = oldValue + stripsStart;
            values[i] = new TiffLong(newValue);
        }
    }

    private long computeStartOffsetForValues(int numEntries, long ifdOffset) {
        int bytesPerEntry = 12;
        int bytesForEntries = numEntries * 12;
        return ifdOffset + 2L + (long)bytesForEntries + 4L;
    }

    private void setEntry(TiffDirectoryEntry entry) {
        this.entrySet.set(entry);
    }

    public int getBandDataType() {
        return this.maxElemSizeBandDataType;
    }

    private void initEntrys(Product product) {
        this.maxElemSizeBandDataType = TiffIFD.getMaxElemSizeBandDataType(product.getBands());
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        this.setEntry(new TiffDirectoryEntry(TiffTag.IMAGE_WIDTH, new TiffLong(width)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.IMAGE_LENGTH, new TiffLong(height)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.BITS_PER_SAMPLE, this.calculateBitsPerSample(product)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.COMPRESSION, new TiffShort(1)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.IMAGE_DESCRIPTION, new TiffAscii(product.getName())));
        this.setEntry(new TiffDirectoryEntry(TiffTag.SAMPLES_PER_PIXEL, new TiffShort(TiffIFD.getNumBands(product))));
        this.setEntry(new TiffDirectoryEntry(TiffTag.STRIP_OFFSETS, this.calculateStripOffsets()));
        this.setEntry(new TiffDirectoryEntry(TiffTag.ROWS_PER_STRIP, new TiffLong(height)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.STRIP_BYTE_COUNTS, this.calculateStripByteCounts()));
        this.setEntry(new TiffDirectoryEntry(TiffTag.X_RESOLUTION, new TiffRational(1L, 1L)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.Y_RESOLUTION, new TiffRational(1L, 1L)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.RESOLUTION_UNIT, new TiffShort(1)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.PLANAR_CONFIGURATION, TiffCode.PLANAR_CONFIG_PLANAR));
        this.setEntry(new TiffDirectoryEntry(TiffTag.SAMPLE_FORMAT, this.calculateSampleFormat(product)));
        this.setEntry(new TiffDirectoryEntry(TiffTag.BEAM_METADATA, TiffIFD.getBeamMetadata(product)));
        TiffValue[] colorMap = null;
        if (TiffIFD.isValidColorMapProduct(product)) {
            colorMap = this.createColorMap(product);
        }
        if (colorMap != null) {
            this.setEntry(new TiffDirectoryEntry(TiffTag.PHOTOMETRIC_INTERPRETATION, TiffCode.PHOTOMETRIC_RGB_PALETTE));
            this.setEntry(new TiffDirectoryEntry(TiffTag.COLOR_MAP, colorMap));
        } else {
            this.setEntry(new TiffDirectoryEntry(TiffTag.PHOTOMETRIC_INTERPRETATION, TiffCode.PHOTOMETRIC_BLACK_IS_ZERO));
        }
        this.addGeoTiffTags(product);
    }

    private static int getNumBands(Product product) {
        Band[] bands = product.getBands();
        ArrayList<Band> bandList = new ArrayList<Band>(bands.length);
        for (Band band : bands) {
            if (!TiffIFD.shouldWriteNode((ProductNode)band)) continue;
            bandList.add(band);
        }
        return bandList.size();
    }

    private TiffShort[] createColorMap(Product product) {
        ImageInfo imageInfo = product.getBandAt(0).getImageInfo(null, ProgressMonitor.NULL);
        ColorPaletteDef paletteDef = imageInfo.getColorPaletteDef();
        Object[] redColor = new TiffShort[256];
        Arrays.fill(redColor, new TiffShort(0));
        Object[] greenColor = new TiffShort[256];
        Arrays.fill(greenColor, new TiffShort(0));
        Object[] blueColor = new TiffShort[256];
        Arrays.fill(blueColor, new TiffShort(0));
        float factor = 257.0f;
        for (ColorPaletteDef.Point point : paletteDef.getPoints()) {
            Color color = point.getColor();
            int red = (int)((float)color.getRed() * 257.0f);
            int green = (int)((float)color.getGreen() * 257.0f);
            int blue = (int)((float)color.getBlue() * 257.0f);
            int mapIndex = (int)Math.floor(point.getSample());
            redColor[mapIndex] = new TiffShort(red);
            greenColor[mapIndex] = new TiffShort(green);
            blueColor[mapIndex] = new TiffShort(blue);
        }
        TiffShort[] colorMap = new TiffShort[768];
        System.arraycopy(redColor, 0, colorMap, 0, redColor.length);
        System.arraycopy(greenColor, 0, colorMap, 256, greenColor.length);
        System.arraycopy(blueColor, 0, colorMap, 512, blueColor.length);
        return colorMap;
    }

    private static boolean isValidColorMapProduct(Product product) {
        return TiffIFD.getNumBands(product) == 1 && product.getBandAt(0).getIndexCoding() != null && product.getBandAt(0).getDataType() == 20;
    }

    static TiffAscii getBeamMetadata(Product product) {
        StringWriter stringWriter = new StringWriter();
        DimapHeaderWriter writer = new DimapHeaderWriter(product, (Writer)stringWriter, "");
        writer.writeHeader();
        writer.close();
        return new TiffAscii(stringWriter.getBuffer().toString());
    }

    private void addGeoTiffTags(Product product) {
        double[] modelTransformation;
        GeoTIFFMetadata geoTIFFMetadata = ProductUtils.createGeoTIFFMetadata((Product)product);
        if (geoTIFFMetadata == null) {
            return;
        }
        int numEntries = geoTIFFMetadata.getNumGeoKeyEntries();
        TiffValue[] directoryTagValues = new TiffShort[numEntries * 4];
        ArrayList<TiffDouble> doubleValues = new ArrayList<TiffDouble>();
        ArrayList<String> asciiValues = new ArrayList<String>();
        for (int i = 0; i < numEntries; ++i) {
            GeoTIFFMetadata.KeyEntry entry = geoTIFFMetadata.getGeoKeyEntryAt(i);
            int[] data = entry.getData();
            for (int j = 0; j < data.length; ++j) {
                directoryTagValues[i * 4 + j] = new TiffShort(data[j]);
            }
            if (data[1] == TiffTag.GeoDoubleParamsTag.getValue()) {
                directoryTagValues[i * 4 + 3] = new TiffShort(doubleValues.size());
                double[] geoDoubleParams = geoTIFFMetadata.getGeoDoubleParams(data[0]);
                for (Object geoDoubleParam : (Object)geoDoubleParams) {
                    doubleValues.add(new TiffDouble((double)geoDoubleParam));
                }
            }
            if (data[1] != TiffTag.GeoAsciiParamsTag.getValue()) continue;
            int sizeInBytes = 0;
            for (String asciiValue : asciiValues) {
                sizeInBytes += asciiValue.length() + 1;
            }
            directoryTagValues[i * 4 + 3] = new TiffShort(sizeInBytes);
            asciiValues.add(geoTIFFMetadata.getGeoAsciiParam(data[0]));
        }
        this.setEntry(new TiffDirectoryEntry(TiffTag.GeoKeyDirectoryTag, directoryTagValues));
        if (!doubleValues.isEmpty()) {
            TiffValue[] tiffDoubles = doubleValues.toArray(new TiffDouble[doubleValues.size()]);
            this.setEntry(new TiffDirectoryEntry(TiffTag.GeoDoubleParamsTag, tiffDoubles));
        }
        if (!asciiValues.isEmpty()) {
            String[] tiffAsciies = asciiValues.toArray(new String[asciiValues.size()]);
            this.setEntry(new TiffDirectoryEntry(TiffTag.GeoAsciiParamsTag, new GeoTiffAscii(tiffAsciies)));
        }
        if (!TiffIFD.isZeroArray(modelTransformation = geoTIFFMetadata.getModelTransformation())) {
            this.setEntry(new TiffDirectoryEntry(TiffTag.ModelTransformationTag, TiffIFD.toTiffDoubles(modelTransformation)));
        } else {
            int numModelTiePoints;
            double[] modelPixelScale = geoTIFFMetadata.getModelPixelScale();
            if (!TiffIFD.isZeroArray(modelPixelScale)) {
                this.setEntry(new TiffDirectoryEntry(TiffTag.ModelPixelScaleTag, TiffIFD.toTiffDoubles(modelPixelScale)));
            }
            if ((numModelTiePoints = geoTIFFMetadata.getNumModelTiePoints()) > 0) {
                TiffValue[] tiePoints = new TiffDouble[numModelTiePoints * 6];
                for (int i = 0; i < numModelTiePoints; ++i) {
                    GeoTIFFMetadata.TiePoint modelTiePoint = geoTIFFMetadata.getModelTiePointAt(i);
                    double[] data = modelTiePoint.getData();
                    for (int j = 0; j < data.length; ++j) {
                        tiePoints[i * 6 + j] = new TiffDouble(data[j]);
                    }
                }
                this.setEntry(new TiffDirectoryEntry(TiffTag.ModelTiepointTag, tiePoints));
            }
        }
    }

    private static TiffDouble[] toTiffDoubles(double[] a) {
        TiffDouble[] td = new TiffDouble[a.length];
        for (int i = 0; i < a.length; ++i) {
            td[i] = new TiffDouble(a[i]);
        }
        return td;
    }

    private static boolean isZeroArray(double[] a) {
        for (double v : a) {
            if (v == 0.0) continue;
            return false;
        }
        return true;
    }

    static int getMaxElemSizeBandDataType(Band[] bands) {
        int maxSignedIntType = -1;
        int maxUnsignedIntType = -1;
        int maxFloatType = -1;
        for (Band band : bands) {
            int dt = band.getDataType();
            if (ProductData.isIntType((int)dt)) {
                if (ProductData.isUIntType((int)dt)) {
                    maxUnsignedIntType = Math.max(maxUnsignedIntType, dt);
                } else {
                    maxSignedIntType = Math.max(maxSignedIntType, dt);
                }
            }
            if (!ProductData.isFloatingPointType((int)dt)) continue;
            maxFloatType = Math.max(maxFloatType, dt);
        }
        if (maxFloatType != -1) {
            if (maxUnsignedIntType == 22 || maxSignedIntType == 12) {
                return 31;
            }
            return maxFloatType;
        }
        if (maxUnsignedIntType != -1) {
            if (maxSignedIntType == -1) {
                return maxUnsignedIntType;
            }
            if (ProductData.getElemSize((int)maxUnsignedIntType) >= ProductData.getElemSize((int)maxSignedIntType)) {
                int returnType = maxUnsignedIntType - 10 + 1;
                if (returnType > 12) {
                    return 31;
                }
                return returnType;
            }
        }
        if (maxSignedIntType != -1) {
            return maxSignedIntType;
        }
        return 32;
    }

    private TiffShort[] calculateSampleFormat(Product product) {
        int dataType = this.getBandDataType();
        TiffShort sampleFormat = ProductData.isUIntType((int)dataType) ? TiffCode.SAMPLE_FORMAT_UINT : (ProductData.isIntType((int)dataType) ? TiffCode.SAMPLE_FORMAT_INT : TiffCode.SAMPLE_FORMAT_FLOAT);
        TiffShort[] tiffValues = new TiffShort[TiffIFD.getNumBands(product)];
        for (int i = 0; i < tiffValues.length; ++i) {
            tiffValues[i] = sampleFormat;
        }
        return tiffValues;
    }

    private TiffLong[] calculateStripByteCounts() {
        TiffValue[] bitsPerSample = this.getBitsPerSampleValues();
        TiffLong[] tiffValues = new TiffLong[bitsPerSample.length];
        for (int i = 0; i < tiffValues.length; ++i) {
            long byteCount = this.getByteCount(bitsPerSample, i);
            tiffValues[i] = new TiffLong(byteCount);
        }
        return tiffValues;
    }

    private TiffLong[] calculateStripOffsets() {
        TiffValue[] bitsPerSample = this.getBitsPerSampleValues();
        TiffLong[] tiffValues = new TiffLong[bitsPerSample.length];
        long offset = 0L;
        for (int i = 0; i < tiffValues.length; ++i) {
            tiffValues[i] = new TiffLong(offset);
            long byteCount = this.getByteCount(bitsPerSample, i);
            offset += byteCount;
        }
        return tiffValues;
    }

    private long getByteCount(TiffValue[] bitsPerSample, int i) {
        long bytesPerSample = ((TiffShort)bitsPerSample[i]).getValue() / 8;
        return this.getWidth() * this.getHeight() * bytesPerSample;
    }

    private TiffShort[] calculateBitsPerSample(Product product) {
        int dataType = this.getBandDataType();
        int elemSize = ProductData.getElemSize((int)dataType);
        TiffShort[] tiffValues = new TiffShort[TiffIFD.getNumBands(product)];
        for (int i = 0; i < tiffValues.length; ++i) {
            tiffValues[i] = new TiffShort(8 * elemSize);
        }
        return tiffValues;
    }

    private TiffValue[] getBitsPerSampleValues() {
        return this.getEntry(TiffTag.BITS_PER_SAMPLE).getValues();
    }

    private long getHeight() {
        return ((TiffLong)this.getEntry(TiffTag.IMAGE_LENGTH).getValues()[0]).getValue();
    }

    private long getWidth() {
        return ((TiffLong)this.getEntry(TiffTag.IMAGE_WIDTH).getValues()[0]).getValue();
    }

    static boolean shouldWriteNode(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        return !(node instanceof FilterBand);
    }
}

