/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.TableLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.ui.AppContext;

public class DefaultIOParametersPanel
extends JPanel {
    private ArrayList<SourceProductSelector> sourceProductSelectorList;
    private HashMap<SourceProductDescriptor, SourceProductSelector> sourceProductSelectorMap;
    private AppContext appContext;

    public DefaultIOParametersPanel(AppContext appContext, OperatorDescriptor descriptor, TargetProductSelector targetProductSelector, boolean targetProductSelectorDisplay) {
        this.appContext = appContext;
        this.sourceProductSelectorList = new ArrayList(3);
        this.sourceProductSelectorMap = new HashMap(3);
        this.createSourceProductSelectors(descriptor);
        if (!this.sourceProductSelectorList.isEmpty()) {
            this.setSourceProductSelectorLabels();
            this.setSourceProductSelectorToolTipTexts();
        }
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        this.setLayout((LayoutManager)tableLayout);
        int countSPS = this.sourceProductSelectorList.size();
        if (countSPS == 1) {
            for (SourceProductSelector selector : this.sourceProductSelectorList) {
                this.add(selector.createDefaultPanel());
            }
        } else {
            TableLayout tableLayoutSPS = new TableLayout(1);
            tableLayoutSPS.setTableAnchor(TableLayout.Anchor.WEST);
            tableLayoutSPS.setTableWeightX(Double.valueOf(1.0));
            tableLayoutSPS.setTableFill(TableLayout.Fill.HORIZONTAL);
            JPanel panel = new JPanel((LayoutManager)tableLayoutSPS);
            panel.setBorder(BorderFactory.createTitledBorder("Source Products"));
            for (SourceProductSelector selector : this.sourceProductSelectorList) {
                panel.add(selector.createDefaultPanel(""));
            }
            this.add(panel);
        }
        if (targetProductSelectorDisplay) {
            this.add(targetProductSelector.createDefaultPanel());
        }
        this.add(tableLayout.createVerticalSpacer());
    }

    public DefaultIOParametersPanel(AppContext appContext, OperatorDescriptor descriptor, TargetProductSelector targetProductSelector) {
        this(appContext, descriptor, targetProductSelector, true);
    }

    @Deprecated
    public DefaultIOParametersPanel(AppContext appContext, OperatorSpi operatorSpi, TargetProductSelector targetProductSelector) {
        this(appContext, operatorSpi.getOperatorDescriptor(), targetProductSelector);
    }

    public ArrayList<SourceProductSelector> getSourceProductSelectorList() {
        return this.sourceProductSelectorList;
    }

    public void initSourceProductSelectors() {
        for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
            sourceProductSelector.initProducts();
        }
    }

    public void releaseSourceProductSelectors() {
        for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
            sourceProductSelector.releaseProducts();
        }
    }

    public HashMap<String, Product> createSourceProductsMap() {
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>(8);
        for (SourceProductDescriptor descriptor : this.sourceProductSelectorMap.keySet()) {
            SourceProductSelector selector = this.sourceProductSelectorMap.get(descriptor);
            String alias = descriptor.getAlias();
            String key = alias != null ? alias : descriptor.getName();
            sourceProducts.put(key, selector.getSelectedProduct());
        }
        return sourceProducts;
    }

    private void createSourceProductSelectors(OperatorDescriptor operatorDescriptor) {
        for (SourceProductDescriptor descriptor : operatorDescriptor.getSourceProductDescriptors()) {
            AnnotatedSourceProductFilter productFilter = new AnnotatedSourceProductFilter(descriptor);
            SourceProductSelector sourceProductSelector = new SourceProductSelector(this.appContext, descriptor.isOptional());
            sourceProductSelector.setProductFilter(productFilter);
            this.sourceProductSelectorList.add(sourceProductSelector);
            this.sourceProductSelectorMap.put(descriptor, sourceProductSelector);
        }
    }

    private void setSourceProductSelectorLabels() {
        for (SourceProductDescriptor descriptor : this.sourceProductSelectorMap.keySet()) {
            SourceProductSelector selector = this.sourceProductSelectorMap.get(descriptor);
            String label = descriptor.getLabel();
            String alias = descriptor.getAlias();
            if (label == null && alias != null) {
                label = alias;
            }
            if (label == null) {
                label = PropertyDescriptor.createDisplayName((String)descriptor.getName());
            }
            if (!label.endsWith(":")) {
                label = label + ":";
            }
            if (descriptor.isOptional()) {
                label = label + " (optional)";
            }
            selector.getProductNameLabel().setText(label);
        }
    }

    private void setSourceProductSelectorToolTipTexts() {
        for (SourceProductDescriptor descriptor : this.sourceProductSelectorMap.keySet()) {
            String description = descriptor.getDescription();
            if (description == null) continue;
            SourceProductSelector selector = this.sourceProductSelectorMap.get(descriptor);
            selector.getProductNameComboBox().setToolTipText(description);
        }
    }

    private static class AnnotatedSourceProductFilter
    implements ProductFilter {
        private final SourceProductDescriptor productDescriptor;

        private AnnotatedSourceProductFilter(SourceProductDescriptor productDescriptor) {
            this.productDescriptor = productDescriptor;
        }

        public boolean accept(Product product) {
            String productType = this.productDescriptor.getProductType();
            if (productType != null && !product.getProductType().matches(productType)) {
                return false;
            }
            for (String bandName : this.productDescriptor.getBands()) {
                if (product.containsBand(bandName)) continue;
                return false;
            }
            return true;
        }
    }
}

