/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.docwin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.Action;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.netbeans.docwin.NotifiableComponent;
import org.esa.snap.netbeans.docwin.WorkspaceTopComponent;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public abstract class DocumentTopComponent<D, V>
extends TopComponent
implements DocumentWindow<D, V>,
NotifiableComponent {
    private static final Logger LOG = Logger.getLogger(DocumentTopComponent.class.getName());
    private final D document;
    private final InstanceContent dynamicContent;

    public DocumentTopComponent(D document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        this.document = document;
        this.dynamicContent = new InstanceContent();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{document}), new AbstractLookup((AbstractLookup.Content)this.dynamicContent)}));
    }

    protected InstanceContent getDynamicContent() {
        return this.dynamicContent;
    }

    @Override
    public final D getDocument() {
        return this.document;
    }

    @Override
    public final TopComponent getTopComponent() {
        return this;
    }

    @Override
    public final boolean isSelected() {
        return DocumentWindowManager.getDefault().getSelectedWindow() == this;
    }

    @Override
    public void requestSelected() {
        if (this.isOpened()) {
            this.requestActive();
        } else {
            this.requestVisible();
            DocumentWindowManager.getDefault().requestSelected(this);
        }
    }

    public Action[] getActions() {
        Action[] baseActions = super.getActions();
        Action[] extraActions = WorkspaceTopComponent.getExtraActions(this);
        if (extraActions.length > 0) {
            ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(baseActions));
            if (!actions.isEmpty()) {
                actions.add(null);
            }
            actions.addAll(Arrays.asList(extraActions));
            return actions.toArray(new Action[actions.size()]);
        }
        return baseActions;
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
    }

    @Override
    public void componentShowing() {
    }

    @Override
    public void componentHidden() {
    }

    @Override
    public void componentActivated() {
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void componentSelected() {
        this.updateSelectedState();
    }

    @Override
    public void componentDeselected() {
        this.updateSelectedState();
    }

    @Override
    public void documentClosing() {
        DocumentWindowManager.getDefault().closeWindow(this);
    }

    protected void updateSelectedState() {
        this.repaint();
    }
}

