/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.awt.Rectangle;

public class FilterWindow {
    public static final String SIZE_3x3 = "3x3";
    public static final String SIZE_5x5 = "5x5";
    public static final String SIZE_7x7 = "7x7";
    public static final String SIZE_9x9 = "9x9";
    public static final String SIZE_11x11 = "11x11";
    public static final String SIZE_13x13 = "13x13";
    public static final String SIZE_15x15 = "15x15";
    public static final String SIZE_17x17 = "17x17";
    private final int windowSizeX;
    private final int windowSizeY;
    private final int halfWindowSizeX;
    private final int halfWindowSizeY;

    public FilterWindow(String windowSizeStr) {
        this(FilterWindow.parseWindowSize(windowSizeStr));
    }

    public FilterWindow(int size) {
        this(size, size);
    }

    public FilterWindow(int sizeX, int sizeY) {
        this.windowSizeX = sizeX;
        this.windowSizeY = sizeY;
        this.halfWindowSizeX = sizeX / 2;
        this.halfWindowSizeY = sizeY / 2;
    }

    public int getWindowSize() {
        return this.windowSizeX;
    }

    public int getWindowSizeX() {
        return this.windowSizeX;
    }

    public int getWindowSizeY() {
        return this.windowSizeY;
    }

    public int getHalfWindowSize() {
        return this.halfWindowSizeX;
    }

    public int getHalfWindowSizeX() {
        return this.halfWindowSizeX;
    }

    public int getHalfWindowSizeY() {
        return this.halfWindowSizeY;
    }

    public static int parseWindowSize(String windowSizeStr) {
        switch (windowSizeStr) {
            case "3x3": {
                return 3;
            }
            case "5x5": {
                return 5;
            }
            case "7x7": {
                return 7;
            }
            case "9x9": {
                return 9;
            }
            case "11x11": {
                return 11;
            }
            case "13x13": {
                return 13;
            }
            case "15x15": {
                return 15;
            }
            case "17x17": {
                return 17;
            }
        }
        return 0;
    }

    public Rectangle getSourceTileRectangle(int x0, int y0, int w, int h, int sourceImageWidth, int sourceImageHeight) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfWindowSizeX) {
            sx0 -= this.halfWindowSizeX;
            sw += this.halfWindowSizeX;
        }
        if (y0 >= this.halfWindowSizeY) {
            sy0 -= this.halfWindowSizeY;
            sh += this.halfWindowSizeY;
        }
        if (x0 + w + this.halfWindowSizeX <= sourceImageWidth) {
            sw += this.halfWindowSizeX;
        }
        if (y0 + h + this.halfWindowSizeY <= sourceImageHeight) {
            sh += this.halfWindowSizeY;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }
}

