/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.esa.snap.graphbuilder.rcp.wizards.WizardPanel;

public abstract class AbstractInstructPanel
extends WizardPanel {
    private final String title;
    protected BufferedImage image = null;
    protected int imgPosX = 0;
    protected int imgPosY = 0;

    public AbstractInstructPanel(String title) {
        super("Instructions");
        this.title = title;
        this.createPanel();
    }

    @Override
    public void returnFromLaterStep() {
    }

    @Override
    public boolean canRedisplayNextPanel() {
        return true;
    }

    @Override
    public boolean hasNextPanel() {
        return true;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public abstract WizardPanel getNextPanel();

    @Override
    public boolean validateInput() {
        return true;
    }

    protected abstract String getDescription();

    protected abstract String getInstructions();

    private void createPanel() {
        JPanel instructPanel1 = new JPanel(new BorderLayout(2, 2));
        instructPanel1.setBorder(BorderFactory.createTitledBorder(this.title));
        JTextPane desciptionPane = new JTextPane();
        desciptionPane.setBackground(instructPanel1.getBackground());
        desciptionPane.setText(this.getDescription());
        instructPanel1.add((Component)desciptionPane, "North");
        this.add((Component)instructPanel1, "North");
        JPanel instructPanel2 = new JPanel(new BorderLayout(2, 2));
        instructPanel2.setBorder(BorderFactory.createTitledBorder("Instructions"));
        JTextPane instructionPane = new JTextPane();
        instructionPane.setBackground(instructPanel2.getBackground());
        instructionPane.setText(this.getInstructions());
        instructPanel2.add((Component)instructionPane, "Center");
        this.add((Component)instructPanel2, "Center");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.image != null) {
            g.drawImage(this.image, this.imgPosX, this.imgPosY, null);
        }
    }
}

