/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;

public class GraphNodeList {
    private final List<GraphNode> nodeList = new ArrayList<GraphNode>(10);

    List<GraphNode> getGraphNodes() {
        return this.nodeList;
    }

    void clear() {
        this.nodeList.clear();
    }

    public void add(GraphNode newGraphNode) {
        this.nodeList.add(newGraphNode);
    }

    public void remove(GraphNode node) {
        for (GraphNode n : this.nodeList) {
            n.disconnectOperatorSources(node.getID());
        }
        this.nodeList.remove(node);
    }

    public GraphNode findGraphNode(String id) {
        for (GraphNode n : this.nodeList) {
            if (!n.getID().equals(id)) continue;
            return n;
        }
        return null;
    }

    public GraphNode findGraphNodeByOperator(String operatorName) {
        for (GraphNode n : this.nodeList) {
            if (!n.getOperatorName().equals(operatorName)) continue;
            return n;
        }
        return null;
    }

    boolean isGraphComplete() {
        int nodesWithoutSources = 0;
        for (GraphNode n : this.nodeList) {
            if (n.HasSources()) continue;
            ++nodesWithoutSources;
            if (this.IsNodeASource(n)) continue;
            return false;
        }
        return nodesWithoutSources != this.nodeList.size();
    }

    public void assignParameters(XppDom presentationXML) throws GraphException {
        for (GraphNode n : this.nodeList) {
            if (n.GetOperatorUI() == null) continue;
            n.AssignParameters(presentationXML);
        }
    }

    void updateGraphNodes(GraphContext graphContext) throws GraphException {
        if (graphContext != null) {
            for (GraphNode n : this.nodeList) {
                NodeContext context = graphContext.getNodeContext(n.getNode());
                if (context.getOperator() != null) {
                    n.setSourceProducts(context.getSourceProducts());
                }
                n.updateParameters();
            }
        }
    }

    public boolean IsNodeASource(GraphNode sourceNode) {
        for (GraphNode n : this.nodeList) {
            if (!n.isNodeSource(sourceNode)) continue;
            return true;
        }
        return false;
    }

    public GraphNode[] findConnectedNodes(GraphNode sourceNode) {
        ArrayList<GraphNode> connectedNodes = new ArrayList<GraphNode>();
        for (GraphNode n : this.nodeList) {
            if (!n.isNodeSource(sourceNode)) continue;
            connectedNodes.add(n);
        }
        return connectedNodes.toArray(new GraphNode[connectedNodes.size()]);
    }

    public void switchConnections(GraphNode oldNode, String newNodeID) {
        GraphNode[] connectedNodes;
        for (GraphNode node : connectedNodes = this.findConnectedNodes(oldNode)) {
            node.connectOperatorSource(newNodeID);
        }
    }
}

