/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;

public class GraphNode {
    private final Node node;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>(10);
    private OperatorUI operatorUI = null;
    private int nodeWidth = 60;
    private int nodeHeight = 25;
    private int halfNodeHeight = 0;
    private int halfNodeWidth = 0;
    private static final int hotSpotSize = 10;
    private static final int halfHotSpotSize = 5;
    private int hotSpotOffset = 0;
    private Point displayPosition = new Point(0, 0);
    private XppDom displayParameters;
    private static Color shadowColor = new Color(0, 0, 0, 64);

    public GraphNode(Node n) throws IllegalArgumentException {
        this.node = n;
        this.displayParameters = new XppDom("node");
        this.displayParameters.setAttribute("id", this.node.getId());
        this.initParameters();
    }

    public void setOperatorUI(OperatorUI ui) {
        this.operatorUI = ui;
    }

    public OperatorUI GetOperatorUI() {
        return this.operatorUI;
    }

    private void initParameters() throws IllegalArgumentException {
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(this.node.getOperatorName());
        if (operatorSpi == null) {
            return;
        }
        ParameterDescriptorFactory parameterDescriptorFactory = new ParameterDescriptorFactory();
        PropertyContainer valueContainer = PropertyContainer.createMapBacked(this.parameterMap, (Class)operatorSpi.getOperatorClass(), (PropertyDescriptorFactory)parameterDescriptorFactory);
        DomElement config = this.node.getConfiguration();
        int count = config.getChildCount();
        for (int i = 0; i < count; ++i) {
            DomElement child = config.getChild(i);
            String name = child.getName();
            String value = child.getValue();
            if (name == null || value == null) continue;
            try {
                if (child.getChildCount() == 0) {
                    Converter converter = GraphNode.getConverter(valueContainer, name);
                    if (converter == null) {
                        String msg = "Graph parameter " + name + " not found for Operator " + operatorSpi.getOperatorAlias();
                        SystemUtils.LOG.warning(msg);
                        continue;
                    }
                    this.parameterMap.put(name, converter.parse(value));
                    continue;
                }
                DomConverter domConverter = GraphNode.getDomConverter(valueContainer, name);
                if (domConverter != null) {
                    try {
                        Object obj = domConverter.convertDomToValue(child, null);
                        this.parameterMap.put(name, obj);
                    }
                    catch (Exception e) {
                        SystemUtils.LOG.warning(e.getMessage());
                    }
                    continue;
                }
                Converter converter = GraphNode.getConverter(valueContainer, name);
                Object[] objArray = new Object[child.getChildCount()];
                int c = 0;
                for (DomElement ch : (DomElement[])child.getChildren()) {
                    String v = ch.getValue();
                    objArray[c++] = converter != null ? converter.parse(v) : v;
                }
                this.parameterMap.put(name, objArray);
                continue;
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException(name);
            }
        }
    }

    private static Converter getConverter(PropertyContainer valueContainer, String name) {
        Property[] properties;
        for (Property p : properties = valueContainer.getProperties()) {
            PropertyDescriptor descriptor = p.getDescriptor();
            if (descriptor == null || !descriptor.getName().equals(name) && (descriptor.getAlias() == null || !descriptor.getAlias().equals(name))) continue;
            return descriptor.getConverter();
        }
        return null;
    }

    private static DomConverter getDomConverter(PropertyContainer valueContainer, String name) {
        Property[] properties;
        for (Property p : properties = valueContainer.getProperties()) {
            PropertyDescriptor descriptor = p.getDescriptor();
            if (descriptor == null || !descriptor.getName().equals(name) && (descriptor.getAlias() == null || !descriptor.getAlias().equals(name))) continue;
            return descriptor.getDomConverter();
        }
        return null;
    }

    void setDisplayParameters(XppDom presentationXML) {
        for (XppDom params : presentationXML.getChildren()) {
            String id = params.getAttribute("id");
            if (id == null || !id.equals(this.node.getId())) continue;
            this.displayParameters = params;
            XppDom dpElem = this.displayParameters.getChild("displayPosition");
            if (dpElem != null) {
                this.displayPosition.x = (int)Float.parseFloat(dpElem.getAttribute("x"));
                this.displayPosition.y = (int)Float.parseFloat(dpElem.getAttribute("y"));
            }
            return;
        }
    }

    void updateParameters() throws GraphException {
        if (this.operatorUI != null) {
            XppDomElement config = new XppDomElement("parameters");
            this.updateParameterMap(config);
            this.node.setConfiguration((DomElement)config);
        }
    }

    void AssignParameters(XppDom presentationXML) throws GraphException {
        this.updateParameters();
        this.AssignDisplayParameters(presentationXML);
    }

    void AssignDisplayParameters(XppDom presentationXML) {
        XppDom dpElem;
        XppDom nodeElem = null;
        for (XppDom elem : presentationXML.getChildren()) {
            String id = elem.getAttribute("id");
            if (id == null || !id.equals(this.node.getId())) continue;
            nodeElem = elem;
            break;
        }
        if (nodeElem == null) {
            presentationXML.addChild(this.displayParameters);
        }
        if ((dpElem = this.displayParameters.getChild("displayPosition")) == null) {
            dpElem = new XppDom("displayPosition");
            this.displayParameters.addChild(dpElem);
        }
        dpElem.setAttribute("y", String.valueOf(this.displayPosition.getY()));
        dpElem.setAttribute("x", String.valueOf(this.displayPosition.getX()));
    }

    public Point getPos() {
        return this.displayPosition;
    }

    public void setPos(Point p) {
        this.displayPosition = p;
    }

    public Node getNode() {
        return this.node;
    }

    public int getWidth() {
        return this.nodeWidth;
    }

    public int getHeight() {
        return this.nodeHeight;
    }

    public static int getHotSpotSize() {
        return 10;
    }

    int getHalfNodeWidth() {
        return this.halfNodeWidth;
    }

    public int getHalfNodeHeight() {
        return this.halfNodeHeight;
    }

    private void setSize(int width, int height) {
        this.nodeWidth = width;
        this.nodeHeight = height;
        this.halfNodeHeight = this.nodeHeight / 2;
        this.halfNodeWidth = this.nodeWidth / 2;
        this.hotSpotOffset = this.halfNodeHeight - 5;
    }

    public int getHotSpotOffset() {
        return this.hotSpotOffset;
    }

    public String getID() {
        return this.node.getId();
    }

    public String getOperatorName() {
        return this.node.getOperatorName();
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public void connectOperatorSource(String id) {
        this.disconnectOperatorSources(id);
        String cntStr = "";
        if (this.node.getSources().length > 0) {
            cntStr = "." + this.node.getSources().length;
        }
        NodeSource ns = new NodeSource("sourceProduct" + cntStr, id);
        this.node.addSource(ns);
    }

    public void disconnectOperatorSources(String id) {
        for (NodeSource ns : this.node.getSources()) {
            if (!ns.getSourceNodeId().equals(id)) continue;
            this.node.removeSource(ns);
        }
    }

    public void disconnectAllSources() {
        NodeSource[] sources;
        for (NodeSource source : sources = this.node.getSources()) {
            this.node.removeSource(source);
        }
    }

    public boolean isNodeSource(GraphNode source) {
        for (NodeSource ns : this.node.getSources()) {
            if (!ns.getSourceNodeId().equals(source.getID())) continue;
            return true;
        }
        return false;
    }

    boolean HasSources() {
        return this.node.getSources().length > 0;
    }

    public UIValidation validateParameterMap() {
        if (this.operatorUI != null) {
            return this.operatorUI.validateParameters();
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    void setSourceProducts(Product[] products) {
        if (this.operatorUI != null) {
            this.operatorUI.setSourceProducts(products);
        }
    }

    void updateParameterMap(XppDomElement parentElement) throws GraphException {
        this.operatorUI.updateParameters();
        this.operatorUI.convertToDOM(parentElement);
    }

    public void drawNode(Graphics2D g, Color col) {
        int x = this.displayPosition.x;
        int y = this.displayPosition.y;
        g.setFont(g.getFont().deriveFont(1, 11.0f));
        FontMetrics metrics = g.getFontMetrics();
        String name = this.node.getId();
        Rectangle2D rect = metrics.getStringBounds(name, g);
        int stringWidth = (int)rect.getWidth();
        this.setSize(Math.max(stringWidth, 50) + 10, 25);
        int step = 4;
        int alpha = 96;
        for (int i = 0; i < step; ++i) {
            g.setColor(new Color(0, 0, 0, alpha - 32 * i));
            g.drawLine(x + i + 1, y + this.nodeHeight + i, x + this.nodeWidth + i - 1, y + this.nodeHeight + i);
            g.drawLine(x + this.nodeWidth + i, y + i, x + this.nodeWidth + i, y + this.nodeHeight + i);
        }
        Rectangle clipShape = new Rectangle(x, y, this.nodeWidth, this.nodeHeight);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setPaint(new GradientPaint(x, y, col, x + this.nodeWidth, y + this.nodeHeight, col.darker()));
        g.fill(clipShape);
        g.setColor(Color.blue);
        g.draw3DRect(x, y, this.nodeWidth - 1, this.nodeHeight - 1, true);
        g.setColor(Color.BLACK);
        g.drawString(name, x + (this.nodeWidth - stringWidth) / 2, y + 15);
    }

    public void drawHeadHotspot(Graphics g, Color col) {
        Point p = this.displayPosition;
        g.setColor(col);
        g.drawOval(p.x - 5, p.y + this.hotSpotOffset, 10, 10);
    }

    public void drawTailHotspot(Graphics g, Color col) {
        Point p = this.displayPosition;
        g.setColor(col);
        int x = p.x + this.nodeWidth;
        int y = p.y + this.halfNodeHeight;
        int[] xpoints = new int[]{x, x + this.hotSpotOffset, x, x};
        int[] ypoints = new int[]{y - 5, y, y + 5, y - 5};
        g.fillPolygon(xpoints, ypoints, xpoints.length);
    }

    public void drawConnectionLine(Graphics2D g, GraphNode src) {
        Point nodePos = this.displayPosition;
        Point srcPos = src.displayPosition;
        int nodeEndX = nodePos.x + this.nodeWidth;
        int nodeMidY = nodePos.y + this.halfNodeHeight;
        int srcEndX = srcPos.x + src.getWidth();
        int srcMidY = srcPos.y + src.getHalfNodeHeight();
        if (srcEndX <= nodePos.x) {
            if (srcPos.y > nodePos.y + this.nodeHeight) {
                GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y + this.nodeHeight, srcEndX, srcMidY);
            } else if (srcPos.y + src.getHeight() < nodePos.y) {
                GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y, srcEndX, srcMidY);
            } else {
                GraphNode.drawArrow(g, nodePos.x, nodeMidY, srcEndX, srcMidY);
            }
        } else if (srcPos.x >= nodeEndX) {
            if (srcPos.y > nodePos.y + this.nodeHeight) {
                GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y + this.nodeHeight, srcPos.x, srcPos.y + this.halfNodeHeight);
            } else if (srcPos.y + src.getHeight() < nodePos.y) {
                GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y, srcPos.x, srcPos.y + this.halfNodeHeight);
            } else {
                GraphNode.drawArrow(g, nodeEndX, nodeMidY, srcPos.x, srcPos.y + this.halfNodeHeight);
            }
        } else if (srcPos.y > nodePos.y + this.nodeHeight) {
            GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y + this.nodeHeight, srcPos.x + src.getHalfNodeWidth(), srcPos.y);
        } else {
            GraphNode.drawArrow(g, nodePos.x + this.halfNodeWidth, nodePos.y, srcPos.x + src.getHalfNodeWidth(), srcPos.y + src.getHeight());
        }
    }

    private static void drawArrow(Graphics2D g, int tailX, int tailY, int headX, int headY) {
        double t1 = Math.abs(headY - tailY);
        double t2 = Math.abs(headX - tailX);
        double theta = Math.atan(t1 / t2);
        if (headX >= tailX) {
            theta = headY > tailY ? Math.PI + theta : -(Math.PI + theta);
        } else if (headX < tailX && headY > tailY) {
            theta = Math.PI * 2 - theta;
        }
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        Point p2 = new Point(-8, -3);
        Point p3 = new Point(-8, 3);
        int x = (int)Math.round(cosTheta * (double)p2.x - sinTheta * (double)p2.y);
        p2.y = (int)Math.round(sinTheta * (double)p2.x + cosTheta * (double)p2.y);
        p2.x = x;
        x = (int)Math.round(cosTheta * (double)p3.x - sinTheta * (double)p3.y);
        p3.y = (int)Math.round(sinTheta * (double)p3.x + cosTheta * (double)p3.y);
        p3.x = x;
        p2.translate(tailX, tailY);
        p3.translate(tailX, tailY);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        g.drawLine(tailX, tailY, headX, headY);
        g.drawLine(tailX, tailY, p2.x, p2.y);
        g.drawLine(p3.x, p3.y, tailX, tailY);
        g.setStroke(oldStroke);
    }
}

