/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.support.BaseFileModel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;
import org.esa.snap.rcp.SnapApp;

public class FileModel
extends BaseFileModel
implements FileTableModel {
    @Override
    protected void setColumnData() {
        this.titles = new String[]{"File Name", "Type", "Acquisition", "Track", "Orbit"};
        this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
        this.widths = new int[]{75, 10, 20, 3, 5};
    }

    @Override
    protected BaseFileModel.TableData createFileStats(File file) {
        return new FileStats(file);
    }

    @Override
    protected BaseFileModel.TableData createFileStats(ProductEntry entry) {
        return new FileStats(entry);
    }

    private class FileStats
    extends BaseFileModel.TableData {
        FileStats(File file) {
            super(file);
        }

        FileStats(ProductEntry entry) {
            super(entry);
        }

        @Override
        protected synchronized void updateData(File file) throws IOException {
            this.data[0] = file.getName();
            Product product = this.getProductFromProductManager(file);
            if (product == null) {
                product = CommonReaders.readProduct((File)file);
            }
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            this.data[0] = product.getName();
            this.data[1] = product.getProductType();
            this.data[2] = OperatorUtils.getAcquisitionDate((MetadataElement)absRoot);
            this.data[3] = String.valueOf(absRoot.getAttributeInt("REL_ORBIT", 0));
            this.data[4] = String.valueOf(absRoot.getAttributeInt("ABS_ORBIT", 0));
        }

        @Override
        protected void updateData(ProductEntry entry) {
            this.data[0] = entry.getName();
            this.data[1] = entry.getProductType();
            this.data[2] = entry.getFirstLineTime().format();
            MetadataElement meta = entry.getMetadata();
            if (meta != null) {
                this.data[3] = String.valueOf(meta.getAttributeInt("REL_ORBIT", 0));
                this.data[4] = String.valueOf(meta.getAttributeInt("ABS_ORBIT", 0));
            }
        }

        private Product getProductFromProductManager(File file) {
            SnapApp app = SnapApp.getDefault();
            if (app != null) {
                Product[] products;
                for (Product p : products = app.getProductManager().getProducts()) {
                    if (!file.equals(p.getFileLocation())) continue;
                    return p;
                }
            }
            return null;
        }
    }
}

