/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.windows;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glayer.swing.LayerCanvasModel;
import com.bc.ceres.grender.AdjustableView;
import com.bc.ceres.grender.Viewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.help.HelpAction;
import org.esa.snap.rcp.actions.tools.SyncImageCursorsAction;
import org.esa.snap.rcp.actions.tools.SyncImageViewsAction;
import org.esa.snap.rcp.nav.NavigationCanvas;
import org.esa.snap.rcp.windows.Bundle;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="NavigationTopComponent", iconBase="org/esa/snap/rcp/icons/Navigation16.gif", persistenceType=0)
public class NavigationTopComponent
extends TopComponent {
    public static final String ID = NavigationTopComponent.class.getName();
    private static final int MIN_SLIDER_VALUE = -100;
    private static final int MAX_SLIDER_VALUE = 100;
    private static final String HELP_ID = "showNavigationWnd";
    private LayerCanvasModelChangeHandler layerCanvasModelChangeChangeHandler;
    private ProductNodeListener productNodeChangeHandler;
    private ProductSceneView currentView;
    private NavigationCanvas canvas;
    private AbstractButton zoomInButton;
    private AbstractButton zoomDefaultButton;
    private AbstractButton zoomOutButton;
    private AbstractButton zoomAllButton;
    private AbstractButton syncViewsButton;
    private AbstractButton syncCursorButton;
    private JTextField zoomFactorField;
    private JFormattedTextField rotationAngleField;
    private JSlider zoomSlider;
    private boolean inUpdateMode;
    private DecimalFormat scaleFormat;
    private Color zeroRotationAngleBackground;
    private final Color positiveRotationAngleBackground = new Color(221, 255, 221);
    private final Color negativeRotationAngleBackground = new Color(255, 221, 221);
    private JSpinner rotationAngleSpinner;

    public NavigationTopComponent() {
        this.initComponent();
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler((oldValue, newValue) -> this.setCurrentView((ProductSceneView)newValue));
    }

    public void initComponent() {
        this.layerCanvasModelChangeChangeHandler = new LayerCanvasModelChangeHandler();
        this.productNodeChangeHandler = this.createProductNodeListener();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        this.scaleFormat = new DecimalFormat("#####.##", decimalFormatSymbols);
        this.scaleFormat.setGroupingUsed(false);
        this.scaleFormat.setDecimalSeparatorAlwaysShown(false);
        this.zoomInButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ZoomIn24.gif"), (boolean)false);
        this.zoomInButton.setToolTipText("Zoom in.");
        this.zoomInButton.setName("zoomInButton");
        this.zoomInButton.addActionListener(e -> this.zoom(this.getCurrentView().getZoomFactor() * 1.2));
        this.zoomOutButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ZoomOut24.gif"), (boolean)false);
        this.zoomOutButton.setName("zoomOutButton");
        this.zoomOutButton.setToolTipText("Zoom out.");
        this.zoomOutButton.addActionListener(e -> this.zoom(this.getCurrentView().getZoomFactor() / 1.2));
        this.zoomDefaultButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ZoomPixel24.gif"), (boolean)false);
        this.zoomDefaultButton.setToolTipText("Actual Pixels (image pixel = view pixel).");
        this.zoomDefaultButton.setName("zoomDefaultButton");
        this.zoomDefaultButton.addActionListener(e -> this.zoomToPixelResolution());
        this.zoomAllButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ZoomAll24.gif"), (boolean)false);
        this.zoomAllButton.setName("zoomAllButton");
        this.zoomAllButton.setToolTipText("Zoom all.");
        this.zoomAllButton.addActionListener(e -> this.zoomAll());
        this.syncViewsButton = ToolButtonFactory.createButton((Action)new SyncImageViewsAction(), (boolean)true);
        this.syncViewsButton.setName("syncViewsButton");
        this.syncViewsButton.setText(null);
        this.syncCursorButton = ToolButtonFactory.createButton((Action)new SyncImageCursorsAction(), (boolean)true);
        this.syncCursorButton.setName("syncCursorButton");
        this.syncCursorButton.setText(null);
        AbstractButton helpButton = ToolButtonFactory.createButton((Action)new HelpAction((HelpCtx.Provider)this), (boolean)false);
        helpButton.setName("helpButton");
        JPanel eastPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        eastPane.add((Component)this.zoomInButton, gbc);
        ++gbc.gridy;
        eastPane.add((Component)this.zoomOutButton, gbc);
        ++gbc.gridy;
        eastPane.add((Component)this.zoomDefaultButton, gbc);
        ++gbc.gridy;
        eastPane.add((Component)this.zoomAllButton, gbc);
        ++gbc.gridy;
        eastPane.add((Component)this.syncViewsButton, gbc);
        ++gbc.gridy;
        eastPane.add((Component)this.syncCursorButton, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        eastPane.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        eastPane.add((Component)helpButton, gbc);
        this.zoomFactorField = new JTextField();
        this.zoomFactorField.setColumns(8);
        this.zoomFactorField.setHorizontalAlignment(0);
        this.zoomFactorField.addActionListener(e -> this.handleZoomFactorFieldUserInput());
        this.zoomFactorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigationTopComponent.this.handleZoomFactorFieldUserInput();
            }
        });
        this.rotationAngleSpinner = new JSpinner(new SpinnerNumberModel(0.0, -1800.0, 1800.0, 5.0));
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.rotationAngleSpinner.getEditor();
        this.rotationAngleField = editor.getTextField();
        final DecimalFormat rotationFormat = new DecimalFormat("#####.##\u00b0", decimalFormatSymbols);
        rotationFormat.setGroupingUsed(false);
        rotationFormat.setDecimalSeparatorAlwaysShown(false);
        this.rotationAngleField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                return new NumberFormatter(rotationFormat);
            }
        });
        this.rotationAngleField.setColumns(6);
        this.rotationAngleField.setEditable(true);
        this.rotationAngleField.setHorizontalAlignment(0);
        this.rotationAngleField.addActionListener(e -> this.handleRotationAngleFieldUserInput());
        this.rotationAngleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigationTopComponent.this.handleRotationAngleFieldUserInput();
            }
        });
        this.rotationAngleField.addPropertyChangeListener("value", evt -> this.handleRotationAngleFieldUserInput());
        this.zoomSlider = new JSlider(0);
        this.zoomSlider.setValue(0);
        this.zoomSlider.setMinimum(-100);
        this.zoomSlider.setMaximum(100);
        this.zoomSlider.setPaintTicks(false);
        this.zoomSlider.setPaintLabels(false);
        this.zoomSlider.setSnapToTicks(false);
        this.zoomSlider.setPaintTrack(true);
        this.zoomSlider.addChangeListener(e -> {
            if (!this.inUpdateMode) {
                this.zoom(this.sliderValueToZoomFactor(this.zoomSlider.getValue()));
            }
        });
        JPanel zoomFactorPane = new JPanel(new BorderLayout());
        zoomFactorPane.add((Component)this.zoomFactorField, "West");
        JPanel rotationAnglePane = new JPanel(new BorderLayout());
        rotationAnglePane.add((Component)this.rotationAngleSpinner, "East");
        rotationAnglePane.add((Component)new JLabel(" "), "Center");
        JPanel sliderPane = new JPanel(new BorderLayout(2, 2));
        sliderPane.add((Component)zoomFactorPane, "West");
        sliderPane.add((Component)this.zoomSlider, "Center");
        sliderPane.add((Component)rotationAnglePane, "East");
        this.canvas = this.createNavigationCanvas();
        this.canvas.setBackground(new Color(138, 133, 128));
        this.canvas.setForeground(new Color(153, 153, 204));
        JPanel centerPane = new JPanel(new BorderLayout(4, 4));
        centerPane.add("Center", this.canvas);
        centerPane.add("South", sliderPane);
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add(centerPane, "Center");
        this.add(eastPane, "East");
        this.setPreferredSize(new Dimension(320, 320));
        this.updateCurrentView();
        this.updateState();
    }

    private void updateCurrentView() {
        this.setCurrentView((ProductSceneView)Utilities.actionsGlobalContext().lookup(ProductSceneView.class));
    }

    public ProductSceneView getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(ProductSceneView newView) {
        if (this.currentView != newView) {
            LayerCanvas layerCanvas;
            Product product;
            ProductSceneView oldView = this.currentView;
            if (oldView != null) {
                product = oldView.getProduct();
                if (product != null) {
                    product.removeProductNodeListener(this.productNodeChangeHandler);
                }
                if ((layerCanvas = oldView.getLayerCanvas()) != null) {
                    layerCanvas.getModel().removeChangeListener((LayerCanvasModel.ChangeListener)this.layerCanvasModelChangeChangeHandler);
                }
            }
            this.currentView = newView;
            if (this.currentView != null) {
                product = this.currentView.getProduct();
                if (product != null) {
                    product.addProductNodeListener(this.productNodeChangeHandler);
                }
                if ((layerCanvas = this.currentView.getLayerCanvas()) != null) {
                    layerCanvas.getModel().addChangeListener((LayerCanvasModel.ChangeListener)this.layerCanvasModelChangeChangeHandler);
                }
            }
            this.canvas.handleViewChanged(oldView, newView);
            this.updateState();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    NavigationCanvas createNavigationCanvas() {
        return new NavigationCanvas(this);
    }

    private void handleZoomFactorFieldUserInput() {
        Double zf = this.getZoomFactorFieldValue();
        if (zf != null) {
            this.updateScaleField(zf);
            this.zoom(zf);
        }
    }

    private void handleRotationAngleFieldUserInput() {
        double ra = (double)Math.round(this.getRotationAngleFieldValue() / 5.0) * 5.0;
        this.updateRotationField(ra);
        this.rotate(ra);
    }

    private Double getZoomFactorFieldValue() {
        String text = this.zoomFactorField.getText();
        if (text.contains(":")) {
            return NavigationTopComponent.parseTextualValue(text);
        }
        try {
            double v = Double.parseDouble(text);
            return v > 0.0 ? Double.valueOf(v) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private double getRotationAngleFieldValue() {
        String text = this.rotationAngleField.getText();
        if (text != null) {
            while (text.endsWith("\u00b0")) {
                text = text.substring(0, text.length() - 1);
            }
            try {
                double v = Double.parseDouble(text);
                double max = 36000.0;
                double negMax = -36000.0;
                if (v > 36000.0 || v < -36000.0) {
                    return 0.0;
                }
                return v;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static Double parseTextualValue(String text) {
        String[] numbers = text.split(":");
        if (numbers.length == 2) {
            double divisor;
            double dividend;
            try {
                dividend = Double.parseDouble(numbers[0]);
                divisor = Double.parseDouble(numbers[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (divisor == 0.0) {
                return null;
            }
            double factor = dividend / divisor;
            return factor > 0.0 ? Double.valueOf(factor) : null;
        }
        return null;
    }

    public void setModelOffset(double modelOffsetX, double modelOffsetY) {
        ProductSceneView view = this.getCurrentView();
        if (view != null) {
            view.getLayerCanvas().getViewport().setOffset(modelOffsetX, modelOffsetY);
            this.maybeSynchronizeCompatibleProductViews();
        }
    }

    private void zoomToPixelResolution() {
        ProductSceneView view = this.getCurrentView();
        if (view != null) {
            LayerCanvas layerCanvas = view.getLayerCanvas();
            layerCanvas.getViewport().setZoomFactor(layerCanvas.getDefaultZoomFactor());
            this.maybeSynchronizeCompatibleProductViews();
        }
    }

    public void zoom(double zoomFactor) {
        ProductSceneView view = this.getCurrentView();
        if (view != null && zoomFactor > 0.0) {
            view.getLayerCanvas().getViewport().setZoomFactor(zoomFactor);
            this.maybeSynchronizeCompatibleProductViews();
        }
    }

    private void rotate(Double rotationAngle) {
        ProductSceneView view = this.getCurrentView();
        if (view != null) {
            view.getLayerCanvas().getViewport().setOrientation(rotationAngle * (Math.PI / 180));
            this.maybeSynchronizeCompatibleProductViews();
        }
    }

    public void zoomAll() {
        ProductSceneView view = this.getCurrentView();
        if (view != null) {
            view.getLayerCanvas().zoomAll();
            this.maybeSynchronizeCompatibleProductViews();
        }
    }

    private void maybeSynchronizeCompatibleProductViews() {
        if (this.syncViewsButton.isSelected()) {
            this.synchronizeCompatibleProductViews();
        }
    }

    private void synchronizeCompatibleProductViews() {
        ProductSceneView currentView = this.getCurrentView();
        if (currentView == null) {
            return;
        }
        WindowUtilities.getOpened(ProductSceneViewTopComponent.class).forEach(productSceneViewTopComponent -> {
            ProductSceneView view = productSceneViewTopComponent.getView();
            if (view != currentView) {
                currentView.synchronizeViewportIfPossible(view);
            }
        });
    }

    private double sliderValueToZoomFactor(int sv) {
        LayerCanvas adjustableView = this.getCurrentView().getLayerCanvas();
        double f1 = NavigationTopComponent.scaleExp2Min((AdjustableView)adjustableView);
        double f2 = NavigationTopComponent.scaleExp2Max((AdjustableView)adjustableView);
        double s1 = this.zoomSlider.getMinimum();
        double s2 = this.zoomSlider.getMaximum();
        double v1 = ((double)sv - s1) / (s2 - s1);
        double v2 = f1 + v1 * (f2 - f1);
        return NavigationTopComponent.exp2(v2);
    }

    private int zoomFactorToSliderValue(double zf) {
        LayerCanvas adjustableView = this.getCurrentView().getLayerCanvas();
        double f1 = NavigationTopComponent.scaleExp2Min((AdjustableView)adjustableView);
        double f2 = NavigationTopComponent.scaleExp2Max((AdjustableView)adjustableView);
        double s1 = this.zoomSlider.getMinimum();
        double s2 = this.zoomSlider.getMaximum();
        double v2 = NavigationTopComponent.log2(zf);
        double v1 = Math.max(0.0, Math.min(1.0, (v2 - f1) / (f2 - f1)));
        return (int)(s1 + v1 * (s2 - s1) + 0.5);
    }

    private void updateState() {
        boolean canNavigate = this.getCurrentView() != null;
        this.zoomInButton.setEnabled(canNavigate);
        this.zoomDefaultButton.setEnabled(canNavigate);
        this.zoomOutButton.setEnabled(canNavigate);
        this.zoomAllButton.setEnabled(canNavigate);
        this.zoomSlider.setEnabled(canNavigate);
        this.syncViewsButton.setEnabled(canNavigate);
        this.syncCursorButton.setEnabled(canNavigate);
        this.zoomFactorField.setEnabled(canNavigate);
        this.rotationAngleSpinner.setEnabled(canNavigate);
        this.updateTitle();
        this.updateValues();
    }

    private void updateTitle() {
        if (this.getCurrentView() != null) {
            if (this.getCurrentView().isRGB()) {
                this.setDisplayName(Bundle.CTL_NavigationTopComponentName() + " - " + this.getCurrentView().getProduct().getProductRefString() + " RGB");
            } else {
                this.setDisplayName(Bundle.CTL_NavigationTopComponentName() + " - " + this.getCurrentView().getRaster().getDisplayName());
            }
        } else {
            this.setDisplayName(Bundle.CTL_NavigationTopComponentName());
        }
    }

    private void updateValues() {
        ProductSceneView view = this.getCurrentView();
        if (view != null) {
            boolean oldState = this.inUpdateMode;
            this.inUpdateMode = true;
            double zf = view.getZoomFactor();
            this.updateZoomSlider(zf);
            this.updateScaleField(zf);
            this.updateRotationField(view.getOrientation() * 57.29577951308232);
            this.inUpdateMode = oldState;
        }
    }

    private void updateZoomSlider(double zf) {
        int sv = this.zoomFactorToSliderValue(zf);
        this.zoomSlider.setValue(sv);
    }

    private void updateScaleField(double zf) {
        String text = zf > 1.0 ? this.scaleFormat.format(NavigationTopComponent.roundScale(zf)) + " : 1" : (zf < 1.0 ? "1 : " + this.scaleFormat.format(NavigationTopComponent.roundScale(1.0 / zf)) : "1 : 1");
        this.zoomFactorField.setText(text);
    }

    private void updateRotationField(double ra) {
        while (ra > 180.0) {
            ra -= 360.0;
        }
        while (ra < -180.0) {
            ra += 360.0;
        }
        this.rotationAngleField.setValue(ra);
        if (this.zeroRotationAngleBackground == null) {
            this.zeroRotationAngleBackground = this.rotationAngleField.getBackground();
        }
        if (ra > 0.0) {
            this.rotationAngleField.setBackground(this.positiveRotationAngleBackground);
        } else if (ra < 0.0) {
            this.rotationAngleField.setBackground(this.negativeRotationAngleBackground);
        } else {
            this.rotationAngleField.setBackground(this.zeroRotationAngleBackground);
        }
    }

    private static double roundScale(double x) {
        double e = Math.floor(Math.log10(x));
        double f = 10.0 * Math.pow(10.0, e);
        double fx = x * f;
        double rfx = Math.round(fx);
        if (Math.abs(rfx + 0.5 - fx) <= Math.abs(rfx - fx)) {
            rfx += 0.5;
        }
        return rfx / f;
    }

    private static double scaleExp2Min(AdjustableView adjustableView) {
        return Math.floor(NavigationTopComponent.log2(adjustableView.getMinZoomFactor()));
    }

    private static double scaleExp2Max(AdjustableView adjustableView) {
        return Math.floor(NavigationTopComponent.log2(adjustableView.getMaxZoomFactor()) + 1.0);
    }

    private static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    private static double exp2(double x) {
        return Math.pow(2.0, x);
    }

    private ProductNodeListener createProductNodeListener() {
        return new ProductNodeListenerAdapter(){

            public void nodeChanged(ProductNodeEvent event) {
                if (event.getPropertyName().equalsIgnoreCase("name")) {
                    ProductNode sourceNode = event.getSourceNode();
                    if (NavigationTopComponent.this.getCurrentView().isRGB() && sourceNode == NavigationTopComponent.this.getCurrentView().getProduct() || sourceNode == NavigationTopComponent.this.getCurrentView().getRaster()) {
                        NavigationTopComponent.this.updateTitle();
                    }
                }
            }
        };
    }

    private class LayerCanvasModelChangeHandler
    implements LayerCanvasModel.ChangeListener {
        private LayerCanvasModelChangeHandler() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
        }

        public void handleLayerDataChanged(Layer layer, Rectangle2D modelRegion) {
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
        }

        public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
        }

        public void handleViewportChanged(Viewport viewport, boolean orientationChanged) {
            NavigationTopComponent.this.updateValues();
        }
    }
}

