/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class MultipleRoiComputePanel
extends JPanel {
    private DefaultListModel<String> maskNameListModel;
    private final JTextField maskNameSearchField;
    private int[] indexesInMaskNameList;
    private final ProductNodeListener productNodeListener = new PNL();
    private final AbstractButton refreshButton;
    private final JCheckBox useRoiCheckBox;
    private final CheckBoxList maskNameList;
    private final JCheckBox selectAllCheckBox;
    private final JCheckBox selectNoneCheckBox;
    private RasterDataNode raster;
    private Product product;

    MultipleRoiComputePanel(final ComputeMasks method, RasterDataNode rasterDataNode) {
        this.maskNameSearchField = new JTextField();
        this.maskNameSearchField.setEnabled(false);
        this.maskNameSearchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultipleRoiComputePanel.this.updateMaskListState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultipleRoiComputePanel.this.updateMaskListState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultipleRoiComputePanel.this.updateMaskListState();
            }
        });
        this.maskNameList = new CheckBoxList(new DefaultListModel());
        this.maskNameList.getCheckBoxListSelectionModel().setSelectionMode(2);
        this.maskNameList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultipleRoiComputePanel.this.updateEnablement();
                MultipleRoiComputePanel.this.refreshButton.setEnabled(true);
                if (!e.getValueIsAdjusting()) {
                    MultipleRoiComputePanel.this.selectAndEnableCheckBoxes();
                }
            }
        });
        this.useRoiCheckBox = new JCheckBox("Use ROI mask(s):");
        this.useRoiCheckBox.setMnemonic('R');
        this.useRoiCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleRoiComputePanel.this.updateEnablement();
            }
        });
        JPanel topPanel = new JPanel(new BorderLayout());
        this.refreshButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ViewRefresh22.png"), (boolean)false);
        this.refreshButton.setEnabled(rasterDataNode != null);
        this.refreshButton.setToolTipText("Refresh View");
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mask[] selectedMasks;
                boolean useRoi = MultipleRoiComputePanel.this.useRoiCheckBox.isSelected();
                if (useRoi) {
                    int[] listIndexes = MultipleRoiComputePanel.this.maskNameList.getCheckBoxListSelectedIndices();
                    if (listIndexes.length > 0) {
                        selectedMasks = new Mask[listIndexes.length];
                        for (int i = 0; i < listIndexes.length; ++i) {
                            int listIndex = listIndexes[i];
                            String maskName = MultipleRoiComputePanel.this.maskNameList.getModel().getElementAt(listIndex).toString();
                            selectedMasks[i] = (Mask)MultipleRoiComputePanel.this.raster.getProduct().getMaskGroup().get(maskName);
                        }
                    } else {
                        selectedMasks = new Mask[]{null};
                    }
                } else {
                    selectedMasks = new Mask[]{null};
                }
                method.compute(selectedMasks);
                MultipleRoiComputePanel.this.refreshButton.setEnabled(false);
            }
        });
        topPanel.add((Component)this.refreshButton, "West");
        AbstractButton showMaskManagerButton = this.createShowMaskManagerButton();
        this.selectAllCheckBox = new JCheckBox("Select all");
        this.selectAllCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MultipleRoiComputePanel.this.selectAllCheckBox.isSelected()) {
                    MultipleRoiComputePanel.this.maskNameList.selectAll();
                }
                MultipleRoiComputePanel.this.selectAndEnableCheckBoxes();
            }
        });
        this.selectNoneCheckBox = new JCheckBox("Select none");
        this.selectNoneCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MultipleRoiComputePanel.this.selectNoneCheckBox.isSelected()) {
                    MultipleRoiComputePanel.this.maskNameList.selectNone();
                }
                MultipleRoiComputePanel.this.selectAndEnableCheckBoxes();
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(this.selectAllCheckBox);
        checkBoxPanel.add(this.selectNoneCheckBox);
        JPanel multiRoiComputePanel = GridBagUtils.createPanel();
        GridBagConstraints multiRoiComputePanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,weightx=1");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)topPanel, (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridx=0,gridy=0,gridwidth=3");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)new JSeparator(), (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=1,fill=HORIZONTAL");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)this.useRoiCheckBox, (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=2,weightx=0");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)new JLabel("Filter: "), (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=3,gridx=0,gridwidth=1,anchor=WEST");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)this.maskNameSearchField, (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridx=1,weightx=1");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)showMaskManagerButton, (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=3,gridx=2,weightx=0");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)new JScrollPane((Component)this.maskNameList), (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=4,gridx=0,fill=HORIZONTAL,gridwidth=3,anchor=NORTHWEST");
        GridBagUtils.addToPanel((JPanel)multiRoiComputePanel, (Component)checkBoxPanel, (GridBagConstraints)multiRoiComputePanelConstraints, (String)"gridy=5,weighty=1,gridwidth=3");
        this.add(multiRoiComputePanel);
        this.setRaster(rasterDataNode);
    }

    private AbstractButton createShowMaskManagerButton() {
        AbstractButton showMaskManagerButton = ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/MaskManager24.png", (boolean)false), (boolean)false);
        showMaskManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TopComponent maskManagerTopComponent = WindowManager.getDefault().findTopComponent("MaskManagerTopComponent");
                        maskManagerTopComponent.open();
                        maskManagerTopComponent.requestActive();
                    }
                });
            }
        });
        return showMaskManagerButton;
    }

    void setRaster(RasterDataNode newRaster) {
        if (this.raster != newRaster) {
            this.raster = newRaster;
            if (newRaster == null) {
                if (this.product != null) {
                    this.product.removeProductNodeListener(this.productNodeListener);
                }
                this.product = null;
            } else if (this.product != newRaster.getProduct()) {
                if (this.product != null) {
                    this.product.removeProductNodeListener(this.productNodeListener);
                }
                this.product = newRaster.getProduct();
                if (this.product != null) {
                    this.product.addProductNodeListener(this.productNodeListener);
                }
            }
            this.resetMaskListState();
            this.refreshButton.setEnabled(this.raster != null);
        }
    }

    private void selectAndEnableCheckBoxes() {
        int numEntries = this.maskNameList.getModel().getSize();
        int numSelected = this.maskNameList.getCheckBoxListSelectedIndices().length;
        this.selectNoneCheckBox.setEnabled(numSelected > 0);
        this.selectAllCheckBox.setEnabled(numSelected < numEntries);
        this.selectNoneCheckBox.setSelected(numSelected == 0);
        this.selectAllCheckBox.setSelected(numSelected == numEntries);
    }

    private String[] getSelectedMaskNames() {
        Object[] selectedValues = this.maskNameList.getCheckBoxListSelectedValues();
        return StringUtils.toStringArray((Object[])selectedValues);
    }

    private void resetMaskListState() {
        int i;
        this.maskNameListModel = new DefaultListModel();
        String[] currentSelectedMaskNames = this.getSelectedMaskNames();
        if (this.product != null && this.raster != null) {
            ProductNodeGroup maskGroup = this.product.getMaskGroup();
            for (i = 0; i < maskGroup.getNodeCount(); ++i) {
                Mask mask = (Mask)maskGroup.get(i);
                if (!mask.getRasterSize().equals(this.raster.getRasterSize())) continue;
                this.maskNameListModel.addElement(mask.getName());
            }
            this.maskNameList.setModel(this.maskNameListModel);
        }
        String[] allNames = StringUtils.toStringArray((Object[])this.maskNameListModel.toArray());
        this.indexesInMaskNameList = new int[allNames.length];
        for (i = 0; i < allNames.length; ++i) {
            String name = allNames[i];
            if (StringUtils.contains((String[])currentSelectedMaskNames, (String)name)) {
                this.maskNameList.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
            }
            this.indexesInMaskNameList[i] = i;
        }
        this.updateEnablement();
    }

    void updateEnablement() {
        boolean hasMasks = this.product != null && this.product.getMaskGroup().getNodeCount() > 0;
        boolean canSelectMasks = hasMasks && this.useRoiCheckBox.isSelected();
        this.useRoiCheckBox.setEnabled(hasMasks);
        this.maskNameSearchField.setEnabled(canSelectMasks);
        this.maskNameList.setEnabled(canSelectMasks);
        this.selectAllCheckBox.setEnabled(canSelectMasks && this.maskNameList.getCheckBoxListSelectedIndices().length < this.maskNameList.getModel().getSize());
        this.selectNoneCheckBox.setEnabled(canSelectMasks && this.maskNameList.getCheckBoxListSelectedIndices().length > 0);
        this.refreshButton.setEnabled(this.raster != null);
    }

    private void updateMaskListState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                String text = MultipleRoiComputePanel.this.maskNameSearchField.getText();
                DefaultListModel updatedListModel = new DefaultListModel();
                ArrayList<Boolean> selected = new ArrayList<Boolean>();
                int[] newIndexesInMaskNameList = new int[MultipleRoiComputePanel.this.maskNameListModel.getSize()];
                int counter = 0;
                for (i = 0; i < MultipleRoiComputePanel.this.maskNameListModel.getSize(); ++i) {
                    if (((String)MultipleRoiComputePanel.this.maskNameListModel.get(i)).toLowerCase().contains(text.toLowerCase())) {
                        updatedListModel.addElement(MultipleRoiComputePanel.this.maskNameListModel.get(i));
                        if (MultipleRoiComputePanel.this.indexesInMaskNameList[i] >= 0) {
                            selected.add(MultipleRoiComputePanel.this.maskNameList.getCheckBoxListSelectionModel().isSelectedIndex(MultipleRoiComputePanel.this.indexesInMaskNameList[i]));
                        } else {
                            selected.add(false);
                        }
                        newIndexesInMaskNameList[i] = counter++;
                        continue;
                    }
                    newIndexesInMaskNameList[i] = -1;
                }
                MultipleRoiComputePanel.access$1102(MultipleRoiComputePanel.this, newIndexesInMaskNameList);
                MultipleRoiComputePanel.this.maskNameList.setModel(updatedListModel);
                for (i = 0; i < selected.size(); ++i) {
                    if (!((Boolean)selected.get(i)).booleanValue()) continue;
                    MultipleRoiComputePanel.this.maskNameList.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
                }
            }
        });
    }

    static /* synthetic */ int[] access$1102(MultipleRoiComputePanel x0, int[] x1) {
        x0.indexesInMaskNameList = x1;
        return x1;
    }

    private class PNL
    implements ProductNodeListener {
        private PNL() {
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        public void nodeChanged(ProductNodeEvent event) {
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            if (!MultipleRoiComputePanel.this.useRoiCheckBox.isSelected()) {
                return;
            }
            ProductNode sourceNode = event.getSourceNode();
            if (!(sourceNode instanceof Mask)) {
                return;
            }
            String maskName = ((Mask)sourceNode).getName();
            String[] selectedNames = MultipleRoiComputePanel.this.getSelectedMaskNames();
            if (StringUtils.contains((String[])selectedNames, (String)maskName)) {
                MultipleRoiComputePanel.this.updateEnablement();
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        private void handleEvent(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Mask) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultipleRoiComputePanel.this.resetMaskListState();
                    }
                });
            }
        }
    }

    static interface ComputeMasks {
        public void compute(Mask[] var1);
    }
}

