/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ImageInfoEditor2;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;

class ImageInfoEditorSupport {
    final AbstractButton autoStretch95Button;
    final AbstractButton autoStretch100Button;
    final AbstractButton zoomInVButton;
    final AbstractButton zoomOutVButton;
    final AbstractButton zoomInHButton;
    final AbstractButton zoomOutHButton;
    final AbstractButton showExtraInfoButton;

    protected ImageInfoEditorSupport(ImageInfoEditor2 imageInfoEditor) {
        ColorManipulationForm form = imageInfoEditor.getParentForm();
        this.autoStretch95Button = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto95Percent24.gif");
        this.autoStretch95Button.setName("AutoStretch95Button");
        this.autoStretch95Button.setToolTipText("Auto-adjust to 95% of all pixels");
        this.autoStretch95Button.addActionListener(form.wrapWithAutoApplyActionListener(e -> imageInfoEditor.compute95Percent()));
        this.autoStretch100Button = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/Auto100Percent24.gif");
        this.autoStretch100Button.setName("AutoStretch100Button");
        this.autoStretch100Button.setToolTipText("Auto-adjust to 100% of all pixels");
        this.autoStretch100Button.addActionListener(form.wrapWithAutoApplyActionListener(e -> imageInfoEditor.compute100Percent()));
        this.zoomInVButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomIn24V.gif");
        this.zoomInVButton.setName("zoomInVButton");
        this.zoomInVButton.setToolTipText("Stretch histogram vertically");
        this.zoomInVButton.addActionListener(e -> imageInfoEditor.computeZoomInVertical());
        this.zoomOutVButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomOut24V.gif");
        this.zoomOutVButton.setName("zoomOutVButton");
        this.zoomOutVButton.setToolTipText("Shrink histogram vertically");
        this.zoomOutVButton.addActionListener(e -> imageInfoEditor.computeZoomOutVertical());
        this.zoomInHButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomIn24H.gif");
        this.zoomInHButton.setName("zoomInHButton");
        this.zoomInHButton.setToolTipText("Stretch histogram horizontally");
        this.zoomInHButton.addActionListener(e -> imageInfoEditor.computeZoomInToSliderLimits());
        this.zoomOutHButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/ZoomOut24H.gif");
        this.zoomOutHButton.setName("zoomOutHButton");
        this.zoomOutHButton.setToolTipText("Shrink histogram horizontally");
        this.zoomOutHButton.addActionListener(e -> imageInfoEditor.computeZoomOutToFullHistogramm());
        this.showExtraInfoButton = ImageInfoEditorSupport.createToggleButton("org/esa/snap/rcp/icons/Information24.gif");
        this.showExtraInfoButton.setName("ShowExtraInfoButton");
        this.showExtraInfoButton.setToolTipText("Show extra information");
        this.showExtraInfoButton.setSelected(imageInfoEditor.getShowExtraInfo());
        this.showExtraInfoButton.addActionListener(e -> imageInfoEditor.setShowExtraInfo(this.showExtraInfoButton.isSelected()));
    }

    public static AbstractButton createToggleButton(String s) {
        return ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)s, (boolean)false), (boolean)true);
    }

    public static AbstractButton createButton(String s) {
        return ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)s, (boolean)false), (boolean)false);
    }
}

