/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.interactors.InsertFigureInteractorInterceptor;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayer;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class InsertWktGeometryAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String DLG_TITLE = "Geometry from WKT";
    private Lookup.Result<ProductSceneView> result;
    private Lookup lookup;
    private long currentFeatureId = System.nanoTime();

    public InsertWktGeometryAction() {
        this(Utilities.actionsGlobalContext());
    }

    public InsertWktGeometryAction(Lookup lookup) {
        super(Bundle.CTL_InsertWktGeometryAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new InsertWktGeometryAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        ProductSceneView productSceneView = (ProductSceneView)this.lookup.lookup(ProductSceneView.class);
        this.setEnabled(productSceneView != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JTextArea textArea = new JTextArea(16, 32);
        textArea.setEditable(true);
        JPanel contentPanel = new JPanel(new BorderLayout(4, 4));
        contentPanel.add((Component)new JLabel("Geometry Well-Known-Text (WKT):"), "North");
        contentPanel.add((Component)new JScrollPane(textArea), "Center");
        SnapApp snapApp = SnapApp.getDefault();
        ModalDialog modalDialog = new ModalDialog((Window)snapApp.getMainFrame(), Bundle.CTL_InsertWktGeometryAction_DialogTitle(), 33, null);
        modalDialog.setContent((Component)contentPanel);
        modalDialog.center();
        if (modalDialog.show() == 1) {
            Geometry geometry;
            String wellKnownText = textArea.getText();
            if (wellKnownText == null || wellKnownText.isEmpty()) {
                return;
            }
            ProductSceneView sceneView = snapApp.getSelectedProductSceneView();
            VectorDataLayer vectorDataLayer = InsertFigureInteractorInterceptor.getActiveVectorDataLayer(sceneView);
            if (vectorDataLayer == null) {
                return;
            }
            SimpleFeatureType wktFeatureType = PlainFeatureFactory.createDefaultFeatureType((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            ListFeatureCollection newCollection = new ListFeatureCollection(wktFeatureType);
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(wktFeatureType);
            SimpleFeature wktFeature = featureBuilder.buildFeature("ID" + Long.toHexString(this.currentFeatureId++));
            try {
                geometry = new WKTReader().read(wellKnownText);
            }
            catch (ParseException e) {
                snapApp.handleError("Failed to convert WKT into geometry", e);
                return;
            }
            wktFeature.setDefaultGeometry((Object)geometry);
            newCollection.add(wktFeature);
            FeatureCollection productFeatures = FeatureUtils.clipFeatureCollectionToProductBounds((FeatureCollection)newCollection, (Product)sceneView.getProduct(), null, (ProgressMonitor)ProgressMonitor.NULL);
            if (productFeatures.isEmpty()) {
                Dialogs.showError(Bundle.CTL_InsertWktGeometryAction_MenuText(), "The geometry is not contained in the product.");
            } else {
                vectorDataLayer.getVectorDataNode().getFeatureCollection().addAll(productFeatures);
            }
        }
    }
}

