/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public strictfp class FloatFFT_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private float[] t;
    private FloatFFT_1D fftSlices;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_3D(int n, int n2, int n3) {
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        if (n * n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = n;
            if (this.nt < n2) {
                this.nt = n2;
            }
            this.nt *= 8;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (2 * n3 == 4) {
                this.nt >>= 1;
            } else if (2 * n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.fftSlices = new FloatFFT_1D(n);
        this.fftRows = n == n2 ? this.fftSlices : new FloatFFT_1D(n2);
        this.fftColumns = n == n3 ? this.fftSlices : (n2 == n3 ? this.fftRows : new FloatFFT_1D(n3));
    }

    public void complexForward(final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
            } else {
                this.xdft3da_sub2(0, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n + j * FloatFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexForward(fArray, n13 + n12 * this.rowStride);
                    }
                }
                float[] fArray2 = new float[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftRows.complexForward(fArray2);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
                fArray2 = new float[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftSlices.complexForward(fArray2);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final float[][][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
            } else {
                this.xdft3da_sub2(0, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.complexForward(fArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n32];
                                    fArray2[n + 1] = fArray[i][n2][n32 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n32] = fArray2[n];
                                    fArray[i][n2][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n32];
                                    fArray2[n + 1] = fArray[n2][i][n32 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n32] = fArray2[n];
                                    fArray[n2][i][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexForward(fArray[i][n11]);
                }
            }
            float[] fArray2 = new float[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n11][n8][n9];
                        fArray2[n7 + 1] = fArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray[n11][n8][n9] = fArray2[n7];
                        fArray[n11][n8][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n8][n11][n9];
                        fArray2[n7 + 1] = fArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray[n8][n11][n9] = fArray2[n7];
                        fArray[n8][n11][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n + j * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.sliceStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * FloatFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray2[n2] = fArray[n32];
                                        fArray2[n2 + 1] = fArray[n32 + 1];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                    for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * FloatFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        fArray[n32] = fArray2[n2];
                                        fArray[n32 + 1] = fArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(fArray, n13 + n12 * this.rowStride, bl);
                    }
                }
                float[] fArray2 = new float[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftRows.complexInverse(fArray2, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
                fArray2 = new float[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray2[n7] = fArray[n8];
                            fArray2[n7 + 1] = fArray[n8 + 1];
                        }
                        this.fftSlices.complexInverse(fArray2, bl);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            fArray[n8] = fArray2[n7];
                            fArray[n8 + 1] = fArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n32];
                                    fArray2[n + 1] = fArray[i][n2][n32 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n32] = fArray2[n];
                                    fArray[i][n2][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n32];
                                    fArray2[n + 1] = fArray[n2][i][n32 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n32] = fArray2[n];
                                    fArray[n2][i][n32 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexInverse(fArray[i][n11], bl);
                }
            }
            float[] fArray2 = new float[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n11][n8][n9];
                        fArray2[n7 + 1] = fArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        fArray[n11][n8][n9] = fArray2[n7];
                        fArray[n11][n8][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray2[n7] = fArray[n8][n11][n9];
                        fArray2[n7 + 1] = fArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        fArray[n8][n11][n9] = fArray2[n7];
                        fArray[n8][n11][n9 + 1] = fArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void realForward(float[] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, fArray, true);
            this.cdft3db_subth(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        } else {
            this.xdft3da_sub1(1, -1, fArray, true);
            this.cdft3db_sub(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        }
    }

    public void realForward(float[][][] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, fArray, true);
            this.cdft3db_subth(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        } else {
            this.xdft3da_sub1(1, -1, fArray, true);
            this.cdft3db_sub(-1, fArray, true);
            this.rdft3d_sub(1, fArray);
        }
    }

    public void realForwardFull(float[] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realForwardFull(float[][][] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, fArray, true);
                this.cdft3db_subth(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, -1, fArray, true);
                this.cdft3db_sub(-1, fArray, true);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_subth(1, fArray, bl);
            this.xdft3da_subth1(1, 1, fArray, bl);
        } else {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_sub(1, fArray, bl);
            this.xdft3da_sub1(1, 1, fArray, bl);
        }
    }

    public void realInverse(float[][][] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_subth(1, fArray, bl);
            this.xdft3da_subth1(1, 1, fArray, bl);
        } else {
            this.rdft3d_sub(-1, fArray);
            this.cdft3db_sub(1, fArray, bl);
            this.xdft3da_sub1(1, 1, fArray, bl);
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    public void realInverseFull(float[][][] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, fArray, bl);
                this.cdft3db_subth(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            } else {
                this.xdft3da_sub2(1, 1, fArray, bl);
                this.cdft3db_sub(1, fArray, bl);
                this.rdft3d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final float[][][] fArray) {
        float[] fArray2 = new float[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n3];
                                    fArray2[n + 1] = fArray[i][n2][n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n3] = fArray2[n];
                                    fArray[i][n2][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n3];
                                    fArray2[n + 1] = fArray[n2][i][n3 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n3] = fArray2[n];
                                    fArray[n2][i][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    fArray[n][n22][n4 % n2] = fArray[i][j][n32];
                                    fArray[n][n22][(n4 + 1) % n2] = -fArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realForwardFull(fArray[n13][n12]);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n13][n10][n11];
                        fArray2[n9 + 1] = fArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray[n13][n10][n11] = fArray2[n9];
                        fArray[n13][n10][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n10][n13][n11];
                        fArray2[n9 + 1] = fArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray[n10][n13][n11] = fArray2[n9];
                        fArray[n10][n13][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        fArray[n12][n10][n15 % n2] = fArray[n13][n11][n14];
                        fArray[n12][n10][(n15 + 1) % n2] = -fArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][][] fArray, final boolean bl) {
        float[] fArray2 = new float[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[i][n2][n3];
                                    fArray2[n + 1] = fArray[i][n2][n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    fArray[i][n2][n3] = fArray2[n];
                                    fArray[i][n2][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray2[n] = fArray[n2][i][n3];
                                    fArray2[n + 1] = fArray[n2][i][n3 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n2 = 0; n2 < FloatFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    fArray[n2][i][n3] = fArray2[n];
                                    fArray[n2][i][n3 + 1] = fArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    fArray[n][n22][n4 % n2] = fArray[i][j][n32];
                                    fArray[n][n22][(n4 + 1) % n2] = -fArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverseFull(fArray[n13][n12], bl);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n13][n10][n11];
                        fArray2[n9 + 1] = fArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        fArray[n13][n10][n11] = fArray2[n9];
                        fArray[n13][n10][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray2[n9] = fArray[n10][n13][n11];
                        fArray2[n9 + 1] = fArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        fArray[n10][n13][n11] = fArray2[n9];
                        fArray[n10][n13][n11 + 1] = fArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        fArray[n12][n10][n15 % n2] = fArray[n13][n11][n14];
                        fArray[n12][n10][(n15 + 1) % n2] = -fArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] fArray) {
        final int n = 2 * this.columns;
        float[] fArray2 = new float[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * FloatFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = FloatFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(fArray, n3 + j * FloatFFT_3D.this.rowStride, fArray2, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray2);
                                System.arraycopy(fArray2, 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final float[][][] fArray3 = new float[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * FloatFFT_3D.this.sliceStride;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray, n + j * FloatFFT_3D.this.rowStride, fArray3[i][j], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(fArray3[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray3[i][j], 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray2[n2] = fArray[n3];
                                    fArray2[n2 + 1] = fArray[n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(fArray2);
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray[n3] = fArray2[n2];
                                    fArray[n3 + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray2[n3] = fArray[n2];
                                    fArray2[n3 + 1] = fArray[n2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(fArray2);
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray[n2] = fArray2[n3];
                                    fArray[n2 + 1] = fArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = FloatFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    fArray[n7 + n92 % n] = fArray[n10];
                                    fArray[n7 + (n92 + 1) % n] = -fArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(fArray, n17 + n15 * this.rowStride, fArray2, 0, this.columns);
                    this.fftColumns.realForwardFull(fArray2);
                    System.arraycopy(fArray2, 0, fArray, n16 + n15 * n5, n);
                }
            }
            fArray2 = new float[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftSlices.complexForward(fArray2);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        fArray[n20 + n22 % n] = fArray[n23];
                        fArray[n20 + (n22 + 1) % n] = -fArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] fArray, final boolean bl) {
        final int n = 2 * this.columns;
        float[] fArray2 = new float[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * FloatFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = FloatFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(fArray, n3 + j * FloatFFT_3D.this.rowStride, fArray2, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray2, bl);
                                System.arraycopy(fArray2, 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final float[][][] fArray3 = new float[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * FloatFFT_3D.this.sliceStride;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray, n + j * FloatFFT_3D.this.rowStride, fArray3[i][j], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(fArray3[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                System.arraycopy(fArray3[i][j], 0, fArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray2[n2] = fArray[n3];
                                    fArray2[n2 + 1] = fArray[n3 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(fArray2, bl);
                                for (n42 = 0; n42 < FloatFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    fArray[n3] = fArray2[n2];
                                    fArray[n3 + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < FloatFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray2[n3] = fArray[n2];
                                    fArray2[n3 + 1] = fArray[n2 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(fArray2, bl);
                                for (n42 = 0; n42 < FloatFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    fArray[n2] = fArray2[n3];
                                    fArray[n2 + 1] = fArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = FloatFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < FloatFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    fArray[n7 + n92 % n] = fArray[n10];
                                    fArray[n7 + (n92 + 1) % n] = -fArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(fArray, n17 + n15 * this.rowStride, fArray2, 0, this.columns);
                    this.fftColumns.realInverseFull(fArray2, bl);
                    System.arraycopy(fArray2, 0, fArray, n16 + n15 * n5, n);
                }
            }
            fArray2 = new float[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            fArray2 = new float[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray2[n13] = fArray[n12];
                        fArray2[n13 + 1] = fArray[n12 + 1];
                    }
                    this.fftSlices.complexInverse(fArray2, bl);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        fArray[n12] = fArray2[n13];
                        fArray[n12 + 1] = fArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        fArray[n20 + n22 % n] = fArray[n23];
                        fArray[n20 + (n22 + 1) % n] = -fArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, float[] fArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(fArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realInverse(fArray, n7 + n6 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            this.t[n4] = fArray[n5];
                            this.t[n4 + 1] = fArray[n5 + 1];
                            this.t[n3] = fArray[n5 + 2];
                            this.t[n3 + 1] = fArray[n5 + 3];
                            this.t[n9] = fArray[n5 + 4];
                            this.t[n9 + 1] = fArray[n5 + 5];
                            this.t[n8] = fArray[n5 + 6];
                            this.t[n8 + 1] = fArray[n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            fArray[n5] = this.t[n4];
                            fArray[n5 + 1] = this.t[n4 + 1];
                            fArray[n5 + 2] = this.t[n3];
                            fArray[n5 + 3] = this.t[n3 + 1];
                            fArray[n5 + 4] = this.t[n9];
                            fArray[n5 + 5] = this.t[n9 + 1];
                            fArray[n5 + 6] = this.t[n8];
                            fArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        this.t[n4] = fArray[n5];
                        this.t[n4 + 1] = fArray[n5 + 1];
                        this.t[n3] = fArray[n5 + 2];
                        this.t[n3 + 1] = fArray[n5 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        fArray[n5] = this.t[n4];
                        fArray[n5 + 1] = this.t[n4 + 1];
                        fArray[n5 + 2] = this.t[n3];
                        fArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = fArray[n5];
                    this.t[n4 + 1] = fArray[n5 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    fArray[n5] = this.t[n4];
                    fArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15 = i * this.sliceStride;
                if (n == 0) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.complexInverse(fArray, n15 + n14 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n14 = 0; n14 < this.columns; n14 += 8) {
                        int n16;
                        int n17;
                        int n18;
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            this.t[n12] = fArray[n13];
                            this.t[n12 + 1] = fArray[n13 + 1];
                            this.t[n11] = fArray[n13 + 2];
                            this.t[n11 + 1] = fArray[n13 + 3];
                            this.t[n17] = fArray[n13 + 4];
                            this.t[n17 + 1] = fArray[n13 + 5];
                            this.t[n16] = fArray[n13 + 6];
                            this.t[n16 + 1] = fArray[n13 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            fArray[n13] = this.t[n12];
                            fArray[n13 + 1] = this.t[n12 + 1];
                            fArray[n13 + 2] = this.t[n11];
                            fArray[n13 + 3] = this.t[n11 + 1];
                            fArray[n13 + 4] = this.t[n17];
                            fArray[n13 + 5] = this.t[n17 + 1];
                            fArray[n13 + 6] = this.t[n16];
                            fArray[n13 + 7] = this.t[n16 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        this.t[n12] = fArray[n13];
                        this.t[n12 + 1] = fArray[n13 + 1];
                        this.t[n11] = fArray[n13 + 2];
                        this.t[n11 + 1] = fArray[n13 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        fArray[n13] = this.t[n12];
                        fArray[n13 + 1] = this.t[n12 + 1];
                        fArray[n13 + 2] = this.t[n11];
                        fArray[n13 + 3] = this.t[n11 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        this.t[n12] = fArray[n13];
                        this.t[n12 + 1] = fArray[n13 + 1];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        fArray[n13] = this.t[n12];
                        fArray[n13 + 1] = this.t[n12 + 1];
                    }
                }
                if (n == 0) continue;
                for (n14 = 0; n14 < this.rows; ++n14) {
                    this.fftColumns.realForward(fArray, n15 + n14 * this.rowStride);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, float[] fArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(fArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(fArray, n7 + n6 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            this.t[n4] = fArray[n5];
                            this.t[n4 + 1] = fArray[n5 + 1];
                            this.t[n3] = fArray[n5 + 2];
                            this.t[n3 + 1] = fArray[n5 + 3];
                            this.t[n9] = fArray[n5 + 4];
                            this.t[n9 + 1] = fArray[n5 + 5];
                            this.t[n8] = fArray[n5 + 6];
                            this.t[n8 + 1] = fArray[n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            fArray[n5] = this.t[n4];
                            fArray[n5 + 1] = this.t[n4 + 1];
                            fArray[n5 + 2] = this.t[n3];
                            fArray[n5 + 3] = this.t[n3 + 1];
                            fArray[n5 + 4] = this.t[n9];
                            fArray[n5 + 5] = this.t[n9 + 1];
                            fArray[n5 + 6] = this.t[n8];
                            fArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        this.t[n4] = fArray[n5];
                        this.t[n4 + 1] = fArray[n5 + 1];
                        this.t[n3] = fArray[n5 + 2];
                        this.t[n3 + 1] = fArray[n5 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        fArray[n5] = this.t[n4];
                        fArray[n5 + 1] = this.t[n4 + 1];
                        fArray[n5 + 2] = this.t[n3];
                        fArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = fArray[n5];
                    this.t[n4 + 1] = fArray[n5 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    fArray[n5] = this.t[n4];
                    fArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15 = i * this.sliceStride;
                if (n == 0) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.complexInverse(fArray, n15 + n14 * this.rowStride, bl);
                    }
                } else {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.realInverse2(fArray, n15 + n14 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n14 = 0; n14 < this.columns; n14 += 8) {
                        int n16;
                        int n17;
                        int n18;
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            this.t[n12] = fArray[n13];
                            this.t[n12 + 1] = fArray[n13 + 1];
                            this.t[n11] = fArray[n13 + 2];
                            this.t[n11 + 1] = fArray[n13 + 3];
                            this.t[n17] = fArray[n13 + 4];
                            this.t[n17 + 1] = fArray[n13 + 5];
                            this.t[n16] = fArray[n13 + 6];
                            this.t[n16 + 1] = fArray[n13 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            fArray[n13] = this.t[n12];
                            fArray[n13 + 1] = this.t[n12 + 1];
                            fArray[n13 + 2] = this.t[n11];
                            fArray[n13 + 3] = this.t[n11 + 1];
                            fArray[n13 + 4] = this.t[n17];
                            fArray[n13 + 5] = this.t[n17 + 1];
                            fArray[n13 + 6] = this.t[n16];
                            fArray[n13 + 7] = this.t[n16 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        this.t[n12] = fArray[n13];
                        this.t[n12 + 1] = fArray[n13 + 1];
                        this.t[n11] = fArray[n13 + 2];
                        this.t[n11 + 1] = fArray[n13 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        fArray[n13] = this.t[n12];
                        fArray[n13 + 1] = this.t[n12 + 1];
                        fArray[n13 + 2] = this.t[n11];
                        fArray[n13 + 3] = this.t[n11 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n14 = 0; n14 < this.rows; ++n14) {
                    n13 = n15 + n14 * this.rowStride;
                    n12 = 2 * n14;
                    this.t[n12] = fArray[n13];
                    this.t[n12 + 1] = fArray[n13 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n14 = 0; n14 < this.rows; ++n14) {
                    n13 = n15 + n14 * this.rowStride;
                    n12 = 2 * n14;
                    fArray[n13] = this.t[n12];
                    fArray[n13 + 1] = this.t[n12 + 1];
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, float[][][] fArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.complexForward(fArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.realInverse(fArray[i][n5], 0, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n5 = 0; n5 < this.columns; n5 += 8) {
                        int n6;
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            this.t[n4] = fArray[i][n8][n5];
                            this.t[n4 + 1] = fArray[i][n8][n5 + 1];
                            this.t[n3] = fArray[i][n8][n5 + 2];
                            this.t[n3 + 1] = fArray[i][n8][n5 + 3];
                            this.t[n7] = fArray[i][n8][n5 + 4];
                            this.t[n7 + 1] = fArray[i][n8][n5 + 5];
                            this.t[n6] = fArray[i][n8][n5 + 6];
                            this.t[n6 + 1] = fArray[i][n8][n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            fArray[i][n8][n5] = this.t[n4];
                            fArray[i][n8][n5 + 1] = this.t[n4 + 1];
                            fArray[i][n8][n5 + 2] = this.t[n3];
                            fArray[i][n8][n5 + 3] = this.t[n3 + 1];
                            fArray[i][n8][n5 + 4] = this.t[n7];
                            fArray[i][n8][n5 + 5] = this.t[n7 + 1];
                            fArray[i][n8][n5 + 6] = this.t[n6];
                            fArray[i][n8][n5 + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        this.t[n4] = fArray[i][n5][0];
                        this.t[n4 + 1] = fArray[i][n5][1];
                        this.t[n3] = fArray[i][n5][2];
                        this.t[n3 + 1] = fArray[i][n5][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        fArray[i][n5][0] = this.t[n4];
                        fArray[i][n5][1] = this.t[n4 + 1];
                        fArray[i][n5][2] = this.t[n3];
                        fArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = fArray[i][n5][0];
                    this.t[n4 + 1] = fArray[i][n5][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    fArray[i][n5][0] = this.t[n4];
                    fArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n9;
                int n10;
                int n11;
                if (n == 0) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.complexInverse(fArray[i][n11], bl);
                    }
                }
                if (this.columns > 4) {
                    for (n11 = 0; n11 < this.columns; n11 += 8) {
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            this.t[n10] = fArray[i][n14][n11];
                            this.t[n10 + 1] = fArray[i][n14][n11 + 1];
                            this.t[n9] = fArray[i][n14][n11 + 2];
                            this.t[n9 + 1] = fArray[i][n14][n11 + 3];
                            this.t[n13] = fArray[i][n14][n11 + 4];
                            this.t[n13 + 1] = fArray[i][n14][n11 + 5];
                            this.t[n12] = fArray[i][n14][n11 + 6];
                            this.t[n12 + 1] = fArray[i][n14][n11 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            fArray[i][n14][n11] = this.t[n10];
                            fArray[i][n14][n11 + 1] = this.t[n10 + 1];
                            fArray[i][n14][n11 + 2] = this.t[n9];
                            fArray[i][n14][n11 + 3] = this.t[n9 + 1];
                            fArray[i][n14][n11 + 4] = this.t[n13];
                            fArray[i][n14][n11 + 5] = this.t[n13 + 1];
                            fArray[i][n14][n11 + 6] = this.t[n12];
                            fArray[i][n14][n11 + 7] = this.t[n12 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        this.t[n10] = fArray[i][n11][0];
                        this.t[n10 + 1] = fArray[i][n11][1];
                        this.t[n9] = fArray[i][n11][2];
                        this.t[n9 + 1] = fArray[i][n11][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        fArray[i][n11][0] = this.t[n10];
                        fArray[i][n11][1] = this.t[n10 + 1];
                        fArray[i][n11][2] = this.t[n9];
                        fArray[i][n11][3] = this.t[n9 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        this.t[n10] = fArray[i][n11][0];
                        this.t[n10 + 1] = fArray[i][n11][1];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        fArray[i][n11][0] = this.t[n10];
                        fArray[i][n11][1] = this.t[n10 + 1];
                    }
                }
                if (n == 0) continue;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.realForward(fArray[i][n11], 0);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, float[][][] fArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.complexForward(fArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.realForward(fArray[i][n5]);
                    }
                }
                if (this.columns > 4) {
                    for (n5 = 0; n5 < this.columns; n5 += 8) {
                        int n6;
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            this.t[n4] = fArray[i][n8][n5];
                            this.t[n4 + 1] = fArray[i][n8][n5 + 1];
                            this.t[n3] = fArray[i][n8][n5 + 2];
                            this.t[n3 + 1] = fArray[i][n8][n5 + 3];
                            this.t[n7] = fArray[i][n8][n5 + 4];
                            this.t[n7 + 1] = fArray[i][n8][n5 + 5];
                            this.t[n6] = fArray[i][n8][n5 + 6];
                            this.t[n6 + 1] = fArray[i][n8][n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            fArray[i][n8][n5] = this.t[n4];
                            fArray[i][n8][n5 + 1] = this.t[n4 + 1];
                            fArray[i][n8][n5 + 2] = this.t[n3];
                            fArray[i][n8][n5 + 3] = this.t[n3 + 1];
                            fArray[i][n8][n5 + 4] = this.t[n7];
                            fArray[i][n8][n5 + 5] = this.t[n7 + 1];
                            fArray[i][n8][n5 + 6] = this.t[n6];
                            fArray[i][n8][n5 + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        this.t[n4] = fArray[i][n5][0];
                        this.t[n4 + 1] = fArray[i][n5][1];
                        this.t[n3] = fArray[i][n5][2];
                        this.t[n3 + 1] = fArray[i][n5][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        fArray[i][n5][0] = this.t[n4];
                        fArray[i][n5][1] = this.t[n4 + 1];
                        fArray[i][n5][2] = this.t[n3];
                        fArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = fArray[i][n5][0];
                    this.t[n4 + 1] = fArray[i][n5][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    fArray[i][n5][0] = this.t[n4];
                    fArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n9;
                int n10;
                int n11;
                if (n == 0) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.complexInverse(fArray[i][n11], bl);
                    }
                } else {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.realInverse2(fArray[i][n11], 0, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n11 = 0; n11 < this.columns; n11 += 8) {
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            this.t[n10] = fArray[i][n14][n11];
                            this.t[n10 + 1] = fArray[i][n14][n11 + 1];
                            this.t[n9] = fArray[i][n14][n11 + 2];
                            this.t[n9 + 1] = fArray[i][n14][n11 + 3];
                            this.t[n13] = fArray[i][n14][n11 + 4];
                            this.t[n13 + 1] = fArray[i][n14][n11 + 5];
                            this.t[n12] = fArray[i][n14][n11 + 6];
                            this.t[n12 + 1] = fArray[i][n14][n11 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            fArray[i][n14][n11] = this.t[n10];
                            fArray[i][n14][n11 + 1] = this.t[n10 + 1];
                            fArray[i][n14][n11 + 2] = this.t[n9];
                            fArray[i][n14][n11 + 3] = this.t[n9 + 1];
                            fArray[i][n14][n11 + 4] = this.t[n13];
                            fArray[i][n14][n11 + 5] = this.t[n13 + 1];
                            fArray[i][n14][n11 + 6] = this.t[n12];
                            fArray[i][n14][n11 + 7] = this.t[n12 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        this.t[n10] = fArray[i][n11][0];
                        this.t[n10 + 1] = fArray[i][n11][1];
                        this.t[n9] = fArray[i][n11][2];
                        this.t[n9 + 1] = fArray[i][n11][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        fArray[i][n11][0] = this.t[n10];
                        fArray[i][n11][1] = this.t[n10 + 1];
                        fArray[i][n11][2] = this.t[n9];
                        fArray[i][n11][3] = this.t[n9 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    this.t[n10] = fArray[i][n11][0];
                    this.t[n10 + 1] = fArray[i][n11][1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    fArray[i][n11][0] = this.t[n10];
                    fArray[i][n11][1] = this.t[n10 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int n, float[] fArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int i = 0; i < this.rows; ++i) {
                            int n2 = i * this.rowStride;
                            for (int j = 0; j < this.columns; j += 8) {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < this.slices; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.slices + 2 * n8;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    this.t[n6] = fArray[n7];
                                    this.t[n6 + 1] = fArray[n7 + 1];
                                    this.t[n5] = fArray[n7 + 2];
                                    this.t[n5 + 1] = fArray[n7 + 3];
                                    this.t[n4] = fArray[n7 + 4];
                                    this.t[n4 + 1] = fArray[n7 + 5];
                                    this.t[n3] = fArray[n7 + 6];
                                    this.t[n3 + 1] = fArray[n7 + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (n8 = 0; n8 < this.slices; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.slices + 2 * n8;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    fArray[n7] = this.t[n6];
                                    fArray[n7 + 1] = this.t[n6 + 1];
                                    fArray[n7 + 2] = this.t[n5];
                                    fArray[n7 + 3] = this.t[n5 + 1];
                                    fArray[n7 + 4] = this.t[n4];
                                    fArray[n7 + 5] = this.t[n4 + 1];
                                    fArray[n7 + 6] = this.t[n3];
                                    fArray[n7 + 7] = this.t[n3 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int i = 0; i < this.rows; ++i) {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13 = i * this.rowStride;
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.slices + 2 * n12;
                            this.t[n10] = fArray[n11];
                            this.t[n10 + 1] = fArray[n11 + 1];
                            this.t[n9] = fArray[n11 + 2];
                            this.t[n9 + 1] = fArray[n11 + 3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.slices + 2 * n12;
                            fArray[n11] = this.t[n10];
                            fArray[n11 + 1] = this.t[n10 + 1];
                            fArray[n11 + 2] = this.t[n9];
                            fArray[n11 + 3] = this.t[n9 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int i = 0; i < this.rows; ++i) {
                    int n14;
                    int n15;
                    int n16;
                    int n17 = i * this.rowStride;
                    for (n16 = 0; n16 < this.slices; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        this.t[n14] = fArray[n15];
                        this.t[n14 + 1] = fArray[n15 + 1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (n16 = 0; n16 < this.slices; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        fArray[n15] = this.t[n14];
                        fArray[n15 + 1] = this.t[n14 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n18 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 8) {
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        for (n24 = 0; n24 < this.slices; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.slices + 2 * n24;
                            n20 = n21 + 2 * this.slices;
                            n19 = n20 + 2 * this.slices;
                            this.t[n22] = fArray[n23];
                            this.t[n22 + 1] = fArray[n23 + 1];
                            this.t[n21] = fArray[n23 + 2];
                            this.t[n21 + 1] = fArray[n23 + 3];
                            this.t[n20] = fArray[n23 + 4];
                            this.t[n20 + 1] = fArray[n23 + 5];
                            this.t[n19] = fArray[n23 + 6];
                            this.t[n19 + 1] = fArray[n23 + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, bl);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, bl);
                        for (n24 = 0; n24 < this.slices; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.slices + 2 * n24;
                            n20 = n21 + 2 * this.slices;
                            n19 = n20 + 2 * this.slices;
                            fArray[n23] = this.t[n22];
                            fArray[n23 + 1] = this.t[n22 + 1];
                            fArray[n23 + 2] = this.t[n21];
                            fArray[n23 + 3] = this.t[n21 + 1];
                            fArray[n23 + 4] = this.t[n20];
                            fArray[n23 + 5] = this.t[n20 + 1];
                            fArray[n23 + 6] = this.t[n19];
                            fArray[n23 + 7] = this.t[n19 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n25;
                    int n26;
                    int n27;
                    int n28;
                    int n29 = i * this.rowStride;
                    for (n28 = 0; n28 < this.slices; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.slices + 2 * n28;
                        this.t[n26] = fArray[n27];
                        this.t[n26 + 1] = fArray[n27 + 1];
                        this.t[n25] = fArray[n27 + 2];
                        this.t[n25 + 1] = fArray[n27 + 3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                    for (n28 = 0; n28 < this.slices; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.slices + 2 * n28;
                        fArray[n27] = this.t[n26];
                        fArray[n27 + 1] = this.t[n26 + 1];
                        fArray[n27 + 2] = this.t[n25];
                        fArray[n27 + 3] = this.t[n25 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n30;
                    int n31;
                    int n32;
                    int n33 = i * this.rowStride;
                    for (n32 = 0; n32 < this.slices; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        this.t[n30] = fArray[n31];
                        this.t[n30 + 1] = fArray[n31 + 1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    for (n32 = 0; n32 < this.slices; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        fArray[n31] = this.t[n30];
                        fArray[n31 + 1] = this.t[n30 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, float[][][] fArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int i = 0; i < this.rows; ++i) {
                            for (int j = 0; j < this.columns; j += 8) {
                                int n2;
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                for (n6 = 0; n6 < this.slices; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.slices + 2 * n6;
                                    n3 = n4 + 2 * this.slices;
                                    n2 = n3 + 2 * this.slices;
                                    this.t[n5] = fArray[n6][i][j];
                                    this.t[n5 + 1] = fArray[n6][i][j + 1];
                                    this.t[n4] = fArray[n6][i][j + 2];
                                    this.t[n4 + 1] = fArray[n6][i][j + 3];
                                    this.t[n3] = fArray[n6][i][j + 4];
                                    this.t[n3 + 1] = fArray[n6][i][j + 5];
                                    this.t[n2] = fArray[n6][i][j + 6];
                                    this.t[n2 + 1] = fArray[n6][i][j + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (n6 = 0; n6 < this.slices; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.slices + 2 * n6;
                                    n3 = n4 + 2 * this.slices;
                                    n2 = n3 + 2 * this.slices;
                                    fArray[n6][i][j] = this.t[n5];
                                    fArray[n6][i][j + 1] = this.t[n5 + 1];
                                    fArray[n6][i][j + 2] = this.t[n4];
                                    fArray[n6][i][j + 3] = this.t[n4 + 1];
                                    fArray[n6][i][j + 4] = this.t[n3];
                                    fArray[n6][i][j + 5] = this.t[n3 + 1];
                                    fArray[n6][i][j + 6] = this.t[n2];
                                    fArray[n6][i][j + 7] = this.t[n2 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int i = 0; i < this.rows; ++i) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.slices + 2 * n9;
                            this.t[n8] = fArray[n9][i][0];
                            this.t[n8 + 1] = fArray[n9][i][1];
                            this.t[n7] = fArray[n9][i][2];
                            this.t[n7 + 1] = fArray[n9][i][3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.slices + 2 * n9;
                            fArray[n9][i][0] = this.t[n8];
                            fArray[n9][i][1] = this.t[n8 + 1];
                            fArray[n9][i][2] = this.t[n7];
                            fArray[n9][i][3] = this.t[n7 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int i = 0; i < this.rows; ++i) {
                    int n10;
                    int n11;
                    for (n11 = 0; n11 < this.slices; ++n11) {
                        n10 = 2 * n11;
                        this.t[n10] = fArray[n11][i][0];
                        this.t[n10 + 1] = fArray[n11][i][1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (n11 = 0; n11 < this.slices; ++n11) {
                        n10 = 2 * n11;
                        fArray[n11][i][0] = this.t[n10];
                        fArray[n11][i][1] = this.t[n10 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 8) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = 0; n16 < this.slices; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.slices + 2 * n16;
                            n13 = n14 + 2 * this.slices;
                            n12 = n13 + 2 * this.slices;
                            this.t[n15] = fArray[n16][i][j];
                            this.t[n15 + 1] = fArray[n16][i][j + 1];
                            this.t[n14] = fArray[n16][i][j + 2];
                            this.t[n14 + 1] = fArray[n16][i][j + 3];
                            this.t[n13] = fArray[n16][i][j + 4];
                            this.t[n13 + 1] = fArray[n16][i][j + 5];
                            this.t[n12] = fArray[n16][i][j + 6];
                            this.t[n12 + 1] = fArray[n16][i][j + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, bl);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, bl);
                        for (n16 = 0; n16 < this.slices; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.slices + 2 * n16;
                            n13 = n14 + 2 * this.slices;
                            n12 = n13 + 2 * this.slices;
                            fArray[n16][i][j] = this.t[n15];
                            fArray[n16][i][j + 1] = this.t[n15 + 1];
                            fArray[n16][i][j + 2] = this.t[n14];
                            fArray[n16][i][j + 3] = this.t[n14 + 1];
                            fArray[n16][i][j + 4] = this.t[n13];
                            fArray[n16][i][j + 5] = this.t[n13 + 1];
                            fArray[n16][i][j + 6] = this.t[n12];
                            fArray[n16][i][j + 7] = this.t[n12 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n17;
                    int n18;
                    int n19;
                    for (n19 = 0; n19 < this.slices; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.slices + 2 * n19;
                        this.t[n18] = fArray[n19][i][0];
                        this.t[n18 + 1] = fArray[n19][i][1];
                        this.t[n17] = fArray[n19][i][2];
                        this.t[n17 + 1] = fArray[n19][i][3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                    for (n19 = 0; n19 < this.slices; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.slices + 2 * n19;
                        fArray[n19][i][0] = this.t[n18];
                        fArray[n19][i][1] = this.t[n18 + 1];
                        fArray[n19][i][2] = this.t[n17];
                        fArray[n19][i][3] = this.t[n17 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n20;
                    int n21;
                    for (n21 = 0; n21 < this.slices; ++n21) {
                        n20 = 2 * n21;
                        this.t[n20] = fArray[n21][i][0];
                        this.t[n20 + 1] = fArray[n21][i][1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    for (n21 = 0; n21 < this.slices; ++n21) {
                        n20 = 2 * n21;
                        fArray[n21][i][0] = this.t[n20];
                        fArray[n21][i][1] = this.t[n20 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.realInverse(fArray, n52 + n4 * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n32 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n32 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[n32 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[n32 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n62] = fArray[n32 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n62 + 1] = fArray[n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows);
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n32] = FloatFFT_3D.this.t[n22];
                                        fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                        fArray[n32 + 2] = FloatFFT_3D.this.t[n16];
                                        fArray[n32 + 3] = FloatFFT_3D.this.t[n16 + 1];
                                        fArray[n32 + 4] = FloatFFT_3D.this.t[n7];
                                        fArray[n32 + 5] = FloatFFT_3D.this.t[n7 + 1];
                                        fArray[n32 + 6] = FloatFFT_3D.this.t[n62];
                                        fArray[n32 + 7] = FloatFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n32 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n32 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray[n32] = FloatFFT_3D.this.t[n22];
                                    fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                    fArray[n32 + 2] = FloatFFT_3D.this.t[n16];
                                    fArray[n32 + 3] = FloatFFT_3D.this.t[n16 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                fArray[n32] = FloatFFT_3D.this.t[n22];
                                fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n10 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n10 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n14] = fArray[n10 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n14 + 1] = fArray[n10 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[n10 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[n10 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n10] = FloatFFT_3D.this.t[n9];
                                        fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                                        fArray[n10 + 2] = FloatFFT_3D.this.t[n17];
                                        fArray[n10 + 3] = FloatFFT_3D.this.t[n17 + 1];
                                        fArray[n10 + 4] = FloatFFT_3D.this.t[n14];
                                        fArray[n10 + 5] = FloatFFT_3D.this.t[n14 + 1];
                                        fArray[n10 + 6] = FloatFFT_3D.this.t[n13];
                                        fArray[n10 + 7] = FloatFFT_3D.this.t[n13 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n10 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n10 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray[n10] = FloatFFT_3D.this.t[n9];
                                    fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                                    fArray[n10 + 2] = FloatFFT_3D.this.t[n17];
                                    fArray[n10 + 3] = FloatFFT_3D.this.t[n17 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    fArray[n10] = FloatFFT_3D.this.t[n9];
                                    fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                FloatFFT_3D.this.fftColumns.realForward(fArray, n12 + n11 * FloatFFT_3D.this.rowStride);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray, n52 + n4 * FloatFFT_3D.this.rowStride);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n32 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n32 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[n32 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[n32 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n62] = fArray[n32 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n62 + 1] = fArray[n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows);
                                    for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * FloatFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * FloatFFT_3D.this.rows;
                                        n62 = n7 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n32] = FloatFFT_3D.this.t[n22];
                                        fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                        fArray[n32 + 2] = FloatFFT_3D.this.t[n16];
                                        fArray[n32 + 3] = FloatFFT_3D.this.t[n16 + 1];
                                        fArray[n32 + 4] = FloatFFT_3D.this.t[n7];
                                        fArray[n32 + 5] = FloatFFT_3D.this.t[n7 + 1];
                                        fArray[n32 + 6] = FloatFFT_3D.this.t[n62];
                                        fArray[n32 + 7] = FloatFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n32 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n32 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n4;
                                    fArray[n32] = FloatFFT_3D.this.t[n22];
                                    fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                    fArray[n32 + 2] = FloatFFT_3D.this.t[n16];
                                    fArray[n32 + 3] = FloatFFT_3D.this.t[n16 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n32];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n32 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                            for (n4 = 0; n4 < FloatFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * FloatFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                fArray[n32] = FloatFFT_3D.this.t[n22];
                                fArray[n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * FloatFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            } else {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(fArray, n12 + n11 * FloatFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n10 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n10 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n14] = fArray[n10 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n14 + 1] = fArray[n10 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[n10 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[n10 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < FloatFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * FloatFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * FloatFFT_3D.this.rows;
                                        n13 = n14 + 2 * FloatFFT_3D.this.rows;
                                        fArray[n10] = FloatFFT_3D.this.t[n9];
                                        fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                                        fArray[n10 + 2] = FloatFFT_3D.this.t[n17];
                                        fArray[n10 + 3] = FloatFFT_3D.this.t[n17 + 1];
                                        fArray[n10 + 4] = FloatFFT_3D.this.t[n14];
                                        fArray[n10 + 5] = FloatFFT_3D.this.t[n14 + 1];
                                        fArray[n10 + 6] = FloatFFT_3D.this.t[n13];
                                        fArray[n10 + 7] = FloatFFT_3D.this.t[n13 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n10 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n10 + 3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                    fArray[n10] = FloatFFT_3D.this.t[n9];
                                    fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                                    fArray[n10 + 2] = FloatFFT_3D.this.t[n17];
                                    fArray[n10 + 3] = FloatFFT_3D.this.t[n17 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                n9 = n6 + 2 * n11;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n10];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n10 + 1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                            for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * FloatFFT_3D.this.rowStride;
                                n9 = n6 + 2 * n11;
                                fArray[n10] = FloatFFT_3D.this.t[n9];
                                fArray[n10 + 1] = FloatFFT_3D.this.t[n9 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final int n, final int n2, final float[][][] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.realInverse(fArray[i][n32], 0, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n62][n32];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n62][n32 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n12] = fArray[i][n62][n32 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n12 + 1] = fArray[i][n62][n32 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n52] = fArray[i][n62][n32 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n52 + 1] = fArray[i][n62][n32 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n4] = fArray[i][n62][n32 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n4 + 1] = fArray[i][n62][n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows);
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n62][n32] = FloatFFT_3D.this.t[n22];
                                        fArray[i][n62][n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                        fArray[i][n62][n32 + 2] = FloatFFT_3D.this.t[n12];
                                        fArray[i][n62][n32 + 3] = FloatFFT_3D.this.t[n12 + 1];
                                        fArray[i][n62][n32 + 4] = FloatFFT_3D.this.t[n52];
                                        fArray[i][n62][n32 + 5] = FloatFFT_3D.this.t[n52 + 1];
                                        fArray[i][n62][n32 + 6] = FloatFFT_3D.this.t[n4];
                                        fArray[i][n62][n32 + 7] = FloatFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n32][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n32][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n12] = fArray[i][n32][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n12 + 1] = fArray[i][n32][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray[i][n32][0] = FloatFFT_3D.this.t[n22];
                                    fArray[i][n32][1] = FloatFFT_3D.this.t[n22 + 1];
                                    fArray[i][n32][2] = FloatFFT_3D.this.t[n12];
                                    fArray[i][n32][3] = FloatFFT_3D.this.t[n12 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n32][0];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n32][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                fArray[i][n32][0] = FloatFFT_3D.this.t[n22];
                                fArray[i][n32][1] = FloatFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][n8], bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n11][n8];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n11][n8 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[i][n11][n8 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[i][n11][n8 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10] = fArray[i][n11][n8 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10 + 1] = fArray[i][n11][n8 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[i][n11][n8 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[i][n11][n8 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n11][n8] = FloatFFT_3D.this.t[n7];
                                        fArray[i][n11][n8 + 1] = FloatFFT_3D.this.t[n7 + 1];
                                        fArray[i][n11][n8 + 2] = FloatFFT_3D.this.t[n13];
                                        fArray[i][n11][n8 + 3] = FloatFFT_3D.this.t[n13 + 1];
                                        fArray[i][n11][n8 + 4] = FloatFFT_3D.this.t[n10];
                                        fArray[i][n11][n8 + 5] = FloatFFT_3D.this.t[n10 + 1];
                                        fArray[i][n11][n8 + 6] = FloatFFT_3D.this.t[n9];
                                        fArray[i][n11][n8 + 7] = FloatFFT_3D.this.t[n9 + 1];
                                    }
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n8][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n8][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[i][n8][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[i][n8][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray[i][n8][0] = FloatFFT_3D.this.t[n7];
                                    fArray[i][n8][1] = FloatFFT_3D.this.t[n7 + 1];
                                    fArray[i][n8][2] = FloatFFT_3D.this.t[n13];
                                    fArray[i][n8][3] = FloatFFT_3D.this.t[n13 + 1];
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n8][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n8][1];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    fArray[i][n8][0] = FloatFFT_3D.this.t[n7];
                                    fArray[i][n8][1] = FloatFFT_3D.this.t[n7 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                FloatFFT_3D.this.fftColumns.realForward(fArray[i][n8]);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final float[][][] fArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.complexForward(fArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    FloatFFT_3D.this.fftColumns.realForward(fArray[i][n32]);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n62][n32];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n62][n32 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n12] = fArray[i][n62][n32 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n12 + 1] = fArray[i][n62][n32 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n52] = fArray[i][n62][n32 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n52 + 1] = fArray[i][n62][n32 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n4] = fArray[i][n62][n32 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n4 + 1] = fArray[i][n62][n32 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows);
                                    for (n62 = 0; n62 < FloatFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * FloatFFT_3D.this.rows;
                                        n4 = n52 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n62][n32] = FloatFFT_3D.this.t[n22];
                                        fArray[i][n62][n32 + 1] = FloatFFT_3D.this.t[n22 + 1];
                                        fArray[i][n62][n32 + 2] = FloatFFT_3D.this.t[n12];
                                        fArray[i][n62][n32 + 3] = FloatFFT_3D.this.t[n12 + 1];
                                        fArray[i][n62][n32 + 4] = FloatFFT_3D.this.t[n52];
                                        fArray[i][n62][n32 + 5] = FloatFFT_3D.this.t[n52 + 1];
                                        fArray[i][n62][n32 + 6] = FloatFFT_3D.this.t[n4];
                                        fArray[i][n62][n32 + 7] = FloatFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n32][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n32][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n12] = fArray[i][n32][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n12 + 1] = fArray[i][n32][3];
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows);
                                for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n32;
                                    fArray[i][n32][0] = FloatFFT_3D.this.t[n22];
                                    fArray[i][n32][1] = FloatFFT_3D.this.t[n22 + 1];
                                    fArray[i][n32][2] = FloatFFT_3D.this.t[n12];
                                    fArray[i][n32][3] = FloatFFT_3D.this.t[n12 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[i][n32][0];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[i][n32][1];
                            }
                            FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, n6);
                            for (n32 = 0; n32 < FloatFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                fArray[i][n32][0] = FloatFFT_3D.this.t[n22];
                                fArray[i][n32][1] = FloatFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(fArray[i][n8], bl);
                                }
                            } else {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(fArray[i][n8], 0, bl);
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n11][n8];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n11][n8 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[i][n11][n8 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[i][n11][n8 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10] = fArray[i][n11][n8 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10 + 1] = fArray[i][n11][n8 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[i][n11][n8 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[i][n11][n8 + 7];
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 4 * FloatFFT_3D.this.rows, bl);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 6 * FloatFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < FloatFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * FloatFFT_3D.this.rows;
                                        n9 = n10 + 2 * FloatFFT_3D.this.rows;
                                        fArray[i][n11][n8] = FloatFFT_3D.this.t[n7];
                                        fArray[i][n11][n8 + 1] = FloatFFT_3D.this.t[n7 + 1];
                                        fArray[i][n11][n8 + 2] = FloatFFT_3D.this.t[n13];
                                        fArray[i][n11][n8 + 3] = FloatFFT_3D.this.t[n13 + 1];
                                        fArray[i][n11][n8 + 4] = FloatFFT_3D.this.t[n10];
                                        fArray[i][n11][n8 + 5] = FloatFFT_3D.this.t[n10 + 1];
                                        fArray[i][n11][n8 + 6] = FloatFFT_3D.this.t[n9];
                                        fArray[i][n11][n8 + 7] = FloatFFT_3D.this.t[n9 + 1];
                                    }
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n8][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n8][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[i][n8][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[i][n8][3];
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6 + 2 * FloatFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * FloatFFT_3D.this.rows + 2 * n8;
                                    fArray[i][n8][0] = FloatFFT_3D.this.t[n7];
                                    fArray[i][n8][1] = FloatFFT_3D.this.t[n7 + 1];
                                    fArray[i][n8][2] = FloatFFT_3D.this.t[n13];
                                    fArray[i][n8][3] = FloatFFT_3D.this.t[n13 + 1];
                                }
                                continue;
                            }
                            if (FloatFFT_3D.this.columns != 2) continue;
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                n7 = n6 + 2 * n8;
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n7] = fArray[i][n8][0];
                                ((FloatFFT_3D)FloatFFT_3D.this).t[n7 + 1] = fArray[i][n8][1];
                            }
                            FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, n6, bl);
                            for (n8 = 0; n8 < FloatFFT_3D.this.rows; ++n8) {
                                n7 = n6 + 2 * n8;
                                fArray[i][n8][0] = FloatFFT_3D.this.t[n7];
                                fArray[i][n8][1] = FloatFFT_3D.this.t[n7 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = 8 * this.slices;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                        int n28 = i * FloatFFT_3D.this.rowStride;
                                        for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                            int n29;
                                            int n3;
                                            int n42;
                                            int n52;
                                            int n6;
                                            int n7;
                                            for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * FloatFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n5 + 2 * n7;
                                                n42 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * FloatFFT_3D.this.slices;
                                                n29 = n3 + 2 * FloatFFT_3D.this.slices;
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n52] = fArray[n6];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n52 + 1] = fArray[n6 + 1];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n42] = fArray[n6 + 2];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n42 + 1] = fArray[n6 + 3];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n3] = fArray[n6 + 4];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n3 + 1] = fArray[n6 + 5];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n29] = fArray[n6 + 6];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n29 + 1] = fArray[n6 + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 6 * FloatFFT_3D.this.slices);
                                            for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * FloatFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n5 + 2 * n7;
                                                n42 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * FloatFFT_3D.this.slices;
                                                n29 = n3 + 2 * FloatFFT_3D.this.slices;
                                                fArray[n6] = FloatFFT_3D.this.t[n52];
                                                fArray[n6 + 1] = FloatFFT_3D.this.t[n52 + 1];
                                                fArray[n6 + 2] = FloatFFT_3D.this.t[n42];
                                                fArray[n6 + 3] = FloatFFT_3D.this.t[n42 + 1];
                                                fArray[n6 + 4] = FloatFFT_3D.this.t[n3];
                                                fArray[n6 + 5] = FloatFFT_3D.this.t[n3 + 1];
                                                fArray[n6 + 6] = FloatFFT_3D.this.t[n29];
                                                fArray[n6 + 7] = FloatFFT_3D.this.t[n29 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                    int n30;
                                    int n8;
                                    int n9;
                                    int n10;
                                    int n11 = i * FloatFFT_3D.this.rowStride;
                                    for (n10 = 0; n10 < FloatFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * FloatFFT_3D.this.sliceStride + n11;
                                        n8 = n5 + 2 * n10;
                                        n30 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n10;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n8] = fArray[n9];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n8 + 1] = fArray[n9 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n30] = fArray[n9 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n30 + 1] = fArray[n9 + 3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices);
                                    for (n10 = 0; n10 < FloatFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * FloatFFT_3D.this.sliceStride + n11;
                                        n8 = n5 + 2 * n10;
                                        n30 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n10;
                                        fArray[n9] = FloatFFT_3D.this.t[n8];
                                        fArray[n9 + 1] = FloatFFT_3D.this.t[n8 + 1];
                                        fArray[n9 + 2] = FloatFFT_3D.this.t[n30];
                                        fArray[n9 + 3] = FloatFFT_3D.this.t[n30 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n31;
                                int n12;
                                int n13;
                                int n14 = i * FloatFFT_3D.this.rowStride;
                                for (n13 = 0; n13 < FloatFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * FloatFFT_3D.this.sliceStride + n14;
                                    n31 = n5 + 2 * n13;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n31] = fArray[n12];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n31 + 1] = fArray[n12 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                for (n13 = 0; n13 < FloatFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * FloatFFT_3D.this.sliceStride + n14;
                                    n31 = n5 + 2 * n13;
                                    fArray[n12] = FloatFFT_3D.this.t[n31];
                                    fArray[n12 + 1] = FloatFFT_3D.this.t[n31 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n32 = i * FloatFFT_3D.this.rowStride;
                                for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                    int n15;
                                    int n16;
                                    int n17;
                                    int n18;
                                    int n19;
                                    int n20;
                                    for (n20 = 0; n20 < FloatFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * FloatFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n5 + 2 * n20;
                                        n17 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * FloatFFT_3D.this.slices;
                                        n15 = n16 + 2 * FloatFFT_3D.this.slices;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n18] = fArray[n19];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n18 + 1] = fArray[n19 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n19 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n19 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n19 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n19 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n15] = fArray[n19 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n15 + 1] = fArray[n19 + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 4 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 6 * FloatFFT_3D.this.slices, bl);
                                    for (n20 = 0; n20 < FloatFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * FloatFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n5 + 2 * n20;
                                        n17 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * FloatFFT_3D.this.slices;
                                        n15 = n16 + 2 * FloatFFT_3D.this.slices;
                                        fArray[n19] = FloatFFT_3D.this.t[n18];
                                        fArray[n19 + 1] = FloatFFT_3D.this.t[n18 + 1];
                                        fArray[n19 + 2] = FloatFFT_3D.this.t[n17];
                                        fArray[n19 + 3] = FloatFFT_3D.this.t[n17 + 1];
                                        fArray[n19 + 4] = FloatFFT_3D.this.t[n16];
                                        fArray[n19 + 5] = FloatFFT_3D.this.t[n16 + 1];
                                        fArray[n19 + 6] = FloatFFT_3D.this.t[n15];
                                        fArray[n19 + 7] = FloatFFT_3D.this.t[n15 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n33;
                                int n21;
                                int n22;
                                int n23;
                                int n24 = i * FloatFFT_3D.this.rowStride;
                                for (n23 = 0; n23 < FloatFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * FloatFFT_3D.this.sliceStride + n24;
                                    n21 = n5 + 2 * n23;
                                    n33 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n23;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n21] = fArray[n22];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n21 + 1] = fArray[n22 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n33] = fArray[n22 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n33 + 1] = fArray[n22 + 3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices, bl);
                                for (n23 = 0; n23 < FloatFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * FloatFFT_3D.this.sliceStride + n24;
                                    n21 = n5 + 2 * n23;
                                    n33 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n23;
                                    fArray[n22] = FloatFFT_3D.this.t[n21];
                                    fArray[n22 + 1] = FloatFFT_3D.this.t[n21 + 1];
                                    fArray[n22 + 2] = FloatFFT_3D.this.t[n33];
                                    fArray[n22 + 3] = FloatFFT_3D.this.t[n33 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n34;
                                int n25;
                                int n26;
                                int n27 = i * FloatFFT_3D.this.rowStride;
                                for (n26 = 0; n26 < FloatFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * FloatFFT_3D.this.sliceStride + n27;
                                    n34 = n5 + 2 * n26;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n34] = fArray[n25];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n34 + 1] = fArray[n25 + 1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                for (n26 = 0; n26 < FloatFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * FloatFFT_3D.this.sliceStride + n27;
                                    n34 = n5 + 2 * n26;
                                    fArray[n25] = FloatFFT_3D.this.t[n34];
                                    fArray[n25 + 1] = FloatFFT_3D.this.t[n34 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = 8 * this.slices;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                        for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                            int n16;
                                            int n22;
                                            int n3;
                                            int n42;
                                            int n52;
                                            for (n52 = 0; n52 < FloatFFT_3D.this.slices; ++n52) {
                                                n42 = n5 + 2 * n52;
                                                n3 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * FloatFFT_3D.this.slices;
                                                n16 = n22 + 2 * FloatFFT_3D.this.slices;
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n42] = fArray[n52][i][j];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n42 + 1] = fArray[n52][i][j + 1];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n3] = fArray[n52][i][j + 2];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n3 + 1] = fArray[n52][i][j + 3];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22] = fArray[n52][i][j + 4];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n22 + 1] = fArray[n52][i][j + 5];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n16] = fArray[n52][i][j + 6];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[n16 + 1] = fArray[n52][i][j + 7];
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 6 * FloatFFT_3D.this.slices);
                                            for (n52 = 0; n52 < FloatFFT_3D.this.slices; ++n52) {
                                                n42 = n5 + 2 * n52;
                                                n3 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * FloatFFT_3D.this.slices;
                                                n16 = n22 + 2 * FloatFFT_3D.this.slices;
                                                fArray[n52][i][j] = FloatFFT_3D.this.t[n42];
                                                fArray[n52][i][j + 1] = FloatFFT_3D.this.t[n42 + 1];
                                                fArray[n52][i][j + 2] = FloatFFT_3D.this.t[n3];
                                                fArray[n52][i][j + 3] = FloatFFT_3D.this.t[n3 + 1];
                                                fArray[n52][i][j + 4] = FloatFFT_3D.this.t[n22];
                                                fArray[n52][i][j + 5] = FloatFFT_3D.this.t[n22 + 1];
                                                fArray[n52][i][j + 6] = FloatFFT_3D.this.t[n16];
                                                fArray[n52][i][j + 7] = FloatFFT_3D.this.t[n16 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                    int n17;
                                    int n6;
                                    int n7;
                                    for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                        n6 = n5 + 2 * n7;
                                        n17 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n7;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n6] = fArray[n7][i][0];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n6 + 1] = fArray[n7][i][1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17] = fArray[n7][i][2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n17 + 1] = fArray[n7][i][3];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices);
                                    for (n7 = 0; n7 < FloatFFT_3D.this.slices; ++n7) {
                                        n6 = n5 + 2 * n7;
                                        n17 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n7;
                                        fArray[n7][i][0] = FloatFFT_3D.this.t[n6];
                                        fArray[n7][i][1] = FloatFFT_3D.this.t[n6 + 1];
                                        fArray[n7][i][2] = FloatFFT_3D.this.t[n17];
                                        fArray[n7][i][3] = FloatFFT_3D.this.t[n17 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n18;
                                int n8;
                                for (n8 = 0; n8 < FloatFFT_3D.this.slices; ++n8) {
                                    n18 = n5 + 2 * n8;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n18] = fArray[n8][i][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n18 + 1] = fArray[n8][i][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, n5);
                                for (n8 = 0; n8 < FloatFFT_3D.this.slices; ++n8) {
                                    n18 = n5 + 2 * n8;
                                    fArray[n8][i][0] = FloatFFT_3D.this.t[n18];
                                    fArray[n8][i][1] = FloatFFT_3D.this.t[n18 + 1];
                                }
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                for (int j = 0; j < FloatFFT_3D.this.columns; j += 8) {
                                    int n19;
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    for (n12 = 0; n12 < FloatFFT_3D.this.slices; ++n12) {
                                        n11 = n5 + 2 * n12;
                                        n10 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * FloatFFT_3D.this.slices;
                                        n19 = n9 + 2 * FloatFFT_3D.this.slices;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n11] = fArray[n12][i][j];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n11 + 1] = fArray[n12][i][j + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10] = fArray[n12][i][j + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n10 + 1] = fArray[n12][i][j + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9] = fArray[n12][i][j + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n9 + 1] = fArray[n12][i][j + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n19] = fArray[n12][i][j + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[n19 + 1] = fArray[n12][i][j + 7];
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 4 * FloatFFT_3D.this.slices, bl);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 6 * FloatFFT_3D.this.slices, bl);
                                    for (n12 = 0; n12 < FloatFFT_3D.this.slices; ++n12) {
                                        n11 = n5 + 2 * n12;
                                        n10 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * FloatFFT_3D.this.slices;
                                        n19 = n9 + 2 * FloatFFT_3D.this.slices;
                                        fArray[n12][i][j] = FloatFFT_3D.this.t[n11];
                                        fArray[n12][i][j + 1] = FloatFFT_3D.this.t[n11 + 1];
                                        fArray[n12][i][j + 2] = FloatFFT_3D.this.t[n10];
                                        fArray[n12][i][j + 3] = FloatFFT_3D.this.t[n10 + 1];
                                        fArray[n12][i][j + 4] = FloatFFT_3D.this.t[n9];
                                        fArray[n12][i][j + 5] = FloatFFT_3D.this.t[n9 + 1];
                                        fArray[n12][i][j + 6] = FloatFFT_3D.this.t[n19];
                                        fArray[n12][i][j + 7] = FloatFFT_3D.this.t[n19 + 1];
                                    }
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n20;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < FloatFFT_3D.this.slices; ++n14) {
                                    n13 = n5 + 2 * n14;
                                    n20 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n14;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13] = fArray[n14][i][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n13 + 1] = fArray[n14][i][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n20] = fArray[n14][i][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n20 + 1] = fArray[n14][i][3];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5 + 2 * FloatFFT_3D.this.slices, bl);
                                for (n14 = 0; n14 < FloatFFT_3D.this.slices; ++n14) {
                                    n13 = n5 + 2 * n14;
                                    n20 = n5 + 2 * FloatFFT_3D.this.slices + 2 * n14;
                                    fArray[n14][i][0] = FloatFFT_3D.this.t[n13];
                                    fArray[n14][i][1] = FloatFFT_3D.this.t[n13 + 1];
                                    fArray[n14][i][2] = FloatFFT_3D.this.t[n20];
                                    fArray[n14][i][3] = FloatFFT_3D.this.t[n20 + 1];
                                }
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            for (int i = n4; i < FloatFFT_3D.this.rows; i += n2) {
                                int n21;
                                int n15;
                                for (n15 = 0; n15 < FloatFFT_3D.this.slices; ++n15) {
                                    n21 = n5 + 2 * n15;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n21] = fArray[n15][i][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[n21 + 1] = fArray[n15][i][1];
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, n5, bl);
                                for (n15 = 0; n15 < FloatFFT_3D.this.slices; ++n15) {
                                    n21 = n5 + 2 * n15;
                                    fArray[n15][i][0] = FloatFFT_3D.this.t[n21];
                                    fArray[n15][i][1] = FloatFFT_3D.this.t[n21 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void rdft3d_sub(int n, float[] fArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            float f;
            int n6;
            int n7;
            int n8;
            int n9;
            for (int i = 1; i < n2; ++i) {
                int n10 = this.slices - i;
                n9 = i * this.sliceStride;
                n8 = n10 * this.sliceStride;
                n7 = i * this.sliceStride + n3 * this.rowStride;
                n6 = n10 * this.sliceStride + n3 * this.rowStride;
                f = fArray[n9] - fArray[n8];
                int n11 = n9;
                fArray[n11] = fArray[n11] + fArray[n8];
                fArray[n8] = f;
                f = fArray[n8 + 1] - fArray[n9 + 1];
                int n12 = n9 + 1;
                fArray[n12] = fArray[n12] + fArray[n8 + 1];
                fArray[n8 + 1] = f;
                f = fArray[n7] - fArray[n6];
                int n13 = n7;
                fArray[n13] = fArray[n13] + fArray[n6];
                fArray[n6] = f;
                f = fArray[n6 + 1] - fArray[n7 + 1];
                int n14 = n7 + 1;
                fArray[n14] = fArray[n14] + fArray[n6 + 1];
                fArray[n6 + 1] = f;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    n9 = i * this.sliceStride + n5 * this.rowStride;
                    n8 = n10 * this.sliceStride + n4 * this.rowStride;
                    f = fArray[n9] - fArray[n8];
                    int n15 = n9;
                    fArray[n15] = fArray[n15] + fArray[n8];
                    fArray[n8] = f;
                    f = fArray[n8 + 1] - fArray[n9 + 1];
                    int n16 = n9 + 1;
                    fArray[n16] = fArray[n16] + fArray[n8 + 1];
                    fArray[n8 + 1] = f;
                    n7 = n10 * this.sliceStride + n5 * this.rowStride;
                    n6 = i * this.sliceStride + n4 * this.rowStride;
                    f = fArray[n7] - fArray[n6];
                    int n17 = n7;
                    fArray[n17] = fArray[n17] + fArray[n6];
                    fArray[n6] = f;
                    f = fArray[n6 + 1] - fArray[n7 + 1];
                    int n18 = n7 + 1;
                    fArray[n18] = fArray[n18] + fArray[n6 + 1];
                    fArray[n6 + 1] = f;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                n9 = n5 * this.rowStride;
                n8 = n4 * this.rowStride;
                f = fArray[n9] - fArray[n8];
                int n19 = n9;
                fArray[n19] = fArray[n19] + fArray[n8];
                fArray[n8] = f;
                f = fArray[n8 + 1] - fArray[n9 + 1];
                int n20 = n9 + 1;
                fArray[n20] = fArray[n20] + fArray[n8 + 1];
                fArray[n8 + 1] = f;
                n7 = n2 * this.sliceStride + n5 * this.rowStride;
                n6 = n2 * this.sliceStride + n4 * this.rowStride;
                f = fArray[n7] - fArray[n6];
                int n21 = n7;
                fArray[n21] = fArray[n21] + fArray[n6];
                fArray[n6] = f;
                f = fArray[n6 + 1] - fArray[n7 + 1];
                int n22 = n7 + 1;
                fArray[n22] = fArray[n22] + fArray[n6 + 1];
                fArray[n6 + 1] = f;
            }
        } else {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            for (int i = 1; i < n2; ++i) {
                int n29 = this.slices - i;
                n28 = n29 * this.sliceStride;
                n27 = i * this.sliceStride;
                fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                int n30 = n27;
                fArray[n30] = fArray[n30] - fArray[n28];
                fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                int n31 = n27 + 1;
                fArray[n31] = fArray[n31] - fArray[n28 + 1];
                n26 = n29 * this.sliceStride + n3 * this.rowStride;
                n25 = i * this.sliceStride + n3 * this.rowStride;
                fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                int n32 = n25;
                fArray[n32] = fArray[n32] - fArray[n26];
                fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                int n33 = n25 + 1;
                fArray[n33] = fArray[n33] - fArray[n26 + 1];
                for (n24 = 1; n24 < n3; ++n24) {
                    n23 = this.rows - n24;
                    n28 = n29 * this.sliceStride + n23 * this.rowStride;
                    n27 = i * this.sliceStride + n24 * this.rowStride;
                    fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                    int n34 = n27;
                    fArray[n34] = fArray[n34] - fArray[n28];
                    fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                    int n35 = n27 + 1;
                    fArray[n35] = fArray[n35] - fArray[n28 + 1];
                    n26 = i * this.sliceStride + n23 * this.rowStride;
                    n25 = n29 * this.sliceStride + n24 * this.rowStride;
                    fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                    int n36 = n25;
                    fArray[n36] = fArray[n36] - fArray[n26];
                    fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                    int n37 = n25 + 1;
                    fArray[n37] = fArray[n37] - fArray[n26 + 1];
                }
            }
            for (n24 = 1; n24 < n3; ++n24) {
                n23 = this.rows - n24;
                n28 = n23 * this.rowStride;
                n27 = n24 * this.rowStride;
                fArray[n28] = 0.5f * (fArray[n27] - fArray[n28]);
                int n38 = n27;
                fArray[n38] = fArray[n38] - fArray[n28];
                fArray[n28 + 1] = 0.5f * (fArray[n27 + 1] + fArray[n28 + 1]);
                int n39 = n27 + 1;
                fArray[n39] = fArray[n39] - fArray[n28 + 1];
                n26 = n2 * this.sliceStride + n23 * this.rowStride;
                n25 = n2 * this.sliceStride + n24 * this.rowStride;
                fArray[n26] = 0.5f * (fArray[n25] - fArray[n26]);
                int n40 = n25;
                fArray[n40] = fArray[n40] - fArray[n26];
                fArray[n26 + 1] = 0.5f * (fArray[n25 + 1] + fArray[n26 + 1]);
                int n41 = n25 + 1;
                fArray[n41] = fArray[n41] - fArray[n26 + 1];
            }
        }
    }

    private void rdft3d_sub(int n, float[][][] fArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            float f;
            for (int i = 1; i < n2; ++i) {
                int n6 = this.slices - i;
                f = fArray[i][0][0] - fArray[n6][0][0];
                float[] fArray2 = fArray[i][0];
                fArray2[0] = fArray2[0] + fArray[n6][0][0];
                fArray[n6][0][0] = f;
                f = fArray[n6][0][1] - fArray[i][0][1];
                float[] fArray3 = fArray[i][0];
                fArray3[1] = fArray3[1] + fArray[n6][0][1];
                fArray[n6][0][1] = f;
                f = fArray[i][n3][0] - fArray[n6][n3][0];
                float[] fArray4 = fArray[i][n3];
                fArray4[0] = fArray4[0] + fArray[n6][n3][0];
                fArray[n6][n3][0] = f;
                f = fArray[n6][n3][1] - fArray[i][n3][1];
                float[] fArray5 = fArray[i][n3];
                fArray5[1] = fArray5[1] + fArray[n6][n3][1];
                fArray[n6][n3][1] = f;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    f = fArray[i][n5][0] - fArray[n6][n4][0];
                    float[] fArray6 = fArray[i][n5];
                    fArray6[0] = fArray6[0] + fArray[n6][n4][0];
                    fArray[n6][n4][0] = f;
                    f = fArray[n6][n4][1] - fArray[i][n5][1];
                    float[] fArray7 = fArray[i][n5];
                    fArray7[1] = fArray7[1] + fArray[n6][n4][1];
                    fArray[n6][n4][1] = f;
                    f = fArray[n6][n5][0] - fArray[i][n4][0];
                    float[] fArray8 = fArray[n6][n5];
                    fArray8[0] = fArray8[0] + fArray[i][n4][0];
                    fArray[i][n4][0] = f;
                    f = fArray[i][n4][1] - fArray[n6][n5][1];
                    float[] fArray9 = fArray[n6][n5];
                    fArray9[1] = fArray9[1] + fArray[i][n4][1];
                    fArray[i][n4][1] = f;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                f = fArray[0][n5][0] - fArray[0][n4][0];
                float[] fArray10 = fArray[0][n5];
                fArray10[0] = fArray10[0] + fArray[0][n4][0];
                fArray[0][n4][0] = f;
                f = fArray[0][n4][1] - fArray[0][n5][1];
                float[] fArray11 = fArray[0][n5];
                fArray11[1] = fArray11[1] + fArray[0][n4][1];
                fArray[0][n4][1] = f;
                f = fArray[n2][n5][0] - fArray[n2][n4][0];
                float[] fArray12 = fArray[n2][n5];
                fArray12[0] = fArray12[0] + fArray[n2][n4][0];
                fArray[n2][n4][0] = f;
                f = fArray[n2][n4][1] - fArray[n2][n5][1];
                float[] fArray13 = fArray[n2][n5];
                fArray13[1] = fArray13[1] + fArray[n2][n4][1];
                fArray[n2][n4][1] = f;
            }
        } else {
            int n7;
            int n8;
            for (int i = 1; i < n2; ++i) {
                int n9 = this.slices - i;
                fArray[n9][0][0] = 0.5f * (fArray[i][0][0] - fArray[n9][0][0]);
                float[] fArray14 = fArray[i][0];
                fArray14[0] = fArray14[0] - fArray[n9][0][0];
                fArray[n9][0][1] = 0.5f * (fArray[i][0][1] + fArray[n9][0][1]);
                float[] fArray15 = fArray[i][0];
                fArray15[1] = fArray15[1] - fArray[n9][0][1];
                fArray[n9][n3][0] = 0.5f * (fArray[i][n3][0] - fArray[n9][n3][0]);
                float[] fArray16 = fArray[i][n3];
                fArray16[0] = fArray16[0] - fArray[n9][n3][0];
                fArray[n9][n3][1] = 0.5f * (fArray[i][n3][1] + fArray[n9][n3][1]);
                float[] fArray17 = fArray[i][n3];
                fArray17[1] = fArray17[1] - fArray[n9][n3][1];
                for (n8 = 1; n8 < n3; ++n8) {
                    n7 = this.rows - n8;
                    fArray[n9][n7][0] = 0.5f * (fArray[i][n8][0] - fArray[n9][n7][0]);
                    float[] fArray18 = fArray[i][n8];
                    fArray18[0] = fArray18[0] - fArray[n9][n7][0];
                    fArray[n9][n7][1] = 0.5f * (fArray[i][n8][1] + fArray[n9][n7][1]);
                    float[] fArray19 = fArray[i][n8];
                    fArray19[1] = fArray19[1] - fArray[n9][n7][1];
                    fArray[i][n7][0] = 0.5f * (fArray[n9][n8][0] - fArray[i][n7][0]);
                    float[] fArray20 = fArray[n9][n8];
                    fArray20[0] = fArray20[0] - fArray[i][n7][0];
                    fArray[i][n7][1] = 0.5f * (fArray[n9][n8][1] + fArray[i][n7][1]);
                    float[] fArray21 = fArray[n9][n8];
                    fArray21[1] = fArray21[1] - fArray[i][n7][1];
                }
            }
            for (n8 = 1; n8 < n3; ++n8) {
                n7 = this.rows - n8;
                fArray[0][n7][0] = 0.5f * (fArray[0][n8][0] - fArray[0][n7][0]);
                float[] fArray22 = fArray[0][n8];
                fArray22[0] = fArray22[0] - fArray[0][n7][0];
                fArray[0][n7][1] = 0.5f * (fArray[0][n8][1] + fArray[0][n7][1]);
                float[] fArray23 = fArray[0][n8];
                fArray23[1] = fArray23[1] - fArray[0][n7][1];
                fArray[n2][n7][0] = 0.5f * (fArray[n2][n8][0] - fArray[n2][n7][0]);
                float[] fArray24 = fArray[n2][n8];
                fArray24[0] = fArray24[0] - fArray[n2][n7][0];
                fArray[n2][n7][1] = 0.5f * (fArray[n2][n8][1] + fArray[n2][n7][1]);
                float[] fArray25 = fArray[n2][n8];
                fArray25[1] = fArray25[1] - fArray[n2][n7][1];
            }
        }
    }

    private void fillSymmetric(final float[][][] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        final int n5 = 2 * this.columns;
        final int n6 = this.rows / 2;
        int n7 = this.slices / 2;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.useThreads && this.slices >= n8) {
            Future[] futureArray = new Future[n8];
            n4 = this.slices / n8;
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n4 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                int n22 = (FloatFFT_3D.this.rows - j) % FloatFFT_3D.this.rows;
                                for (int k = 1; k < FloatFFT_3D.this.columns; k += 2) {
                                    int n3 = n5 - k;
                                    fArray[n4][n22][n3] = -fArray[i][j][k + 2];
                                    fArray[n4][n22][n3 - 1] = fArray[i][j][k + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                fArray[n3][j][((FloatFFT_3D)FloatFFT_3D.this).columns] = fArray[i][n22][1];
                                fArray[i][n22][((FloatFFT_3D)FloatFFT_3D.this).columns] = fArray[i][n22][1];
                                fArray[n3][j][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = -fArray[i][n22][0];
                                fArray[i][n22][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = fArray[i][n22][0];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = FloatFFT_3D.this.rows - j;
                                fArray[n3][n22][0] = fArray[i][j][0];
                                fArray[n3][n22][1] = -fArray[i][j][1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = (this.rows - n3) % this.rows;
                    for (n = 1; n < this.columns; n += 2) {
                        int n10 = n5 - n;
                        fArray[n4][n2][n10] = -fArray[n9][n3][n + 2];
                        fArray[n4][n2][n10 - 1] = fArray[n9][n3][n + 1];
                    }
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    fArray[n4][n3][this.columns] = fArray[n9][n2][1];
                    fArray[n9][n2][this.columns] = fArray[n9][n2][1];
                    fArray[n4][n3][this.columns + 1] = -fArray[n9][n2][0];
                    fArray[n9][n2][this.columns + 1] = fArray[n9][n2][0];
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    fArray[n4][n2][0] = fArray[n9][n3][0];
                    fArray[n4][n2][1] = -fArray[n9][n3][1];
                }
            }
        }
        for (int i = 1; i < n7; ++i) {
            n4 = this.slices - i;
            fArray[i][0][this.columns] = fArray[n4][0][1];
            fArray[n4][0][this.columns] = fArray[n4][0][1];
            fArray[i][0][this.columns + 1] = -fArray[n4][0][0];
            fArray[n4][0][this.columns + 1] = fArray[n4][0][0];
            fArray[i][n6][this.columns] = fArray[n4][n6][1];
            fArray[n4][n6][this.columns] = fArray[n4][n6][1];
            fArray[i][n6][this.columns + 1] = -fArray[n4][n6][0];
            fArray[n4][n6][this.columns + 1] = fArray[n4][n6][0];
            fArray[n4][0][0] = fArray[i][0][0];
            fArray[n4][0][1] = -fArray[i][0][1];
            fArray[n4][n6][0] = fArray[i][n6][0];
            fArray[n4][n6][1] = -fArray[i][n6][1];
        }
        fArray[0][0][this.columns] = fArray[0][0][1];
        fArray[0][0][1] = 0.0f;
        fArray[0][n6][this.columns] = fArray[0][n6][1];
        fArray[0][n6][1] = 0.0f;
        fArray[n7][0][this.columns] = fArray[n7][0][1];
        fArray[n7][0][1] = 0.0f;
        fArray[n7][n6][this.columns] = fArray[n7][n6][1];
        fArray[n7][n6][1] = 0.0f;
        fArray[n7][0][this.columns + 1] = 0.0f;
        fArray[n7][n6][this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        final int n11 = 2 * this.columns;
        final int n12 = this.rows / 2;
        int n13 = this.slices / 2;
        final int n14 = this.rows * n11;
        final int n15 = n11;
        for (n10 = this.slices - 1; n10 >= 1; --n10) {
            n9 = n10 * this.sliceStride;
            n8 = 2 * n9;
            for (n7 = 0; n7 < this.rows; ++n7) {
                n6 = n7 * this.rowStride;
                n5 = 2 * n6;
                for (n4 = 0; n4 < this.columns; n4 += 2) {
                    n3 = n9 + n6 + n4;
                    n2 = n8 + n5 + n4;
                    fArray[n2] = fArray[n3];
                    fArray[n3] = 0.0f;
                    fArray[++n2] = fArray[++n3];
                    fArray[n3] = 0.0f;
                }
            }
        }
        for (n10 = 1; n10 < this.rows; ++n10) {
            n9 = (this.rows - n10) * this.rowStride;
            n8 = (this.rows - n10) * n15;
            for (n7 = 0; n7 < this.columns; n7 += 2) {
                n3 = n9 + n7;
                n2 = n8 + n7;
                fArray[n2] = fArray[n3];
                fArray[n3] = 0.0f;
                fArray[++n2] = fArray[++n3];
                fArray[n3] = 0.0f;
            }
        }
        n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.useThreads && this.slices >= n10) {
            int n16;
            int n17;
            Future[] futureArray = new Future[n10];
            n4 = this.slices / n10;
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 0; j < FloatFFT_3D.this.rows; ++j) {
                                int n3 = (FloatFFT_3D.this.rows - j) % FloatFFT_3D.this.rows * n15;
                                int n4 = j * n15;
                                for (int k = 1; k < FloatFFT_3D.this.columns; k += 2) {
                                    int n5 = n + n3 + n11 - k;
                                    int n6 = n2 + n4 + k;
                                    fArray[n5] = -fArray[n6 + 2];
                                    fArray[n5 - 1] = fArray[n6 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n2 + (FloatFFT_3D.this.rows - j) * n15;
                                int n4 = n + j * n15 + FloatFFT_3D.this.columns;
                                int n5 = n3 + FloatFFT_3D.this.columns;
                                int n6 = n3 + 1;
                                fArray[n4] = fArray[n6];
                                fArray[n5] = fArray[n6];
                                fArray[n4 + 1] = -fArray[n3];
                                fArray[n5 + 1] = fArray[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (FloatFFT_3D.this.slices - i) % FloatFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n + (FloatFFT_3D.this.rows - j) * n15;
                                int n4 = n2 + j * n15;
                                fArray[n3] = fArray[n4];
                                fArray[n3 + 1] = -fArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n6 = n7 * n14;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n8 = (this.rows - n4) % this.rows * n15;
                    n5 = n4 * n15;
                    for (n = 1; n < this.columns; n += 2) {
                        n3 = n9 + n8 + n11 - n;
                        n2 = n6 + n5 + n;
                        fArray[n3] = -fArray[n2 + 2];
                        fArray[n3 - 1] = fArray[n2 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n6 = (this.slices - n7) % this.slices * n14;
                n5 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n8 = n5 + (this.rows - n4) * n15;
                    n3 = n6 + n4 * n15 + this.columns;
                    n2 = n8 + this.columns;
                    n9 = n8 + 1;
                    fArray[n3] = fArray[n9];
                    fArray[n2] = fArray[n9];
                    fArray[n3 + 1] = -fArray[n8];
                    fArray[n2 + 1] = fArray[n8];
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n8 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n3 = n9 + (this.rows - n4) * n15;
                    n2 = n8 + n4 * n15;
                    fArray[n3] = fArray[n2];
                    fArray[n3 + 1] = -fArray[n2 + 1];
                }
            }
        }
        for (int i = 1; i < n13; ++i) {
            n3 = i * n14;
            n2 = (this.slices - i) * n14;
            n9 = n12 * n15;
            n8 = n3 + n9;
            n6 = n2 + n9;
            fArray[n3 + this.columns] = fArray[n2 + 1];
            fArray[n2 + this.columns] = fArray[n2 + 1];
            fArray[n3 + this.columns + 1] = -fArray[n2];
            fArray[n2 + this.columns + 1] = fArray[n2];
            fArray[n8 + this.columns] = fArray[n6 + 1];
            fArray[n6 + this.columns] = fArray[n6 + 1];
            fArray[n8 + this.columns + 1] = -fArray[n6];
            fArray[n6 + this.columns + 1] = fArray[n6];
            fArray[n2] = fArray[n3];
            fArray[n2 + 1] = -fArray[n3 + 1];
            fArray[n6] = fArray[n8];
            fArray[n6 + 1] = -fArray[n8 + 1];
        }
        fArray[this.columns] = fArray[1];
        fArray[1] = 0.0f;
        n3 = n12 * n15;
        n2 = n13 * n14;
        n9 = n3 + n2;
        fArray[n3 + this.columns] = fArray[n3 + 1];
        fArray[n3 + 1] = 0.0f;
        fArray[n2 + this.columns] = fArray[n2 + 1];
        fArray[n2 + 1] = 0.0f;
        fArray[n9 + this.columns] = fArray[n9 + 1];
        fArray[n9 + 1] = 0.0f;
        fArray[n2 + this.columns + 1] = 0.0f;
        fArray[n9 + this.columns + 1] = 0.0f;
    }
}

