/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.arcbin;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

class TileIndex {
    static final String FILE_NAME = "w001001x.adf";
    private final Map<Integer, IndexEntry> tileIndex;

    private TileIndex(Map<Integer, IndexEntry> index) {
        this.tileIndex = index;
    }

    IndexEntry getIndexEntry(int index) {
        return this.tileIndex.get(index);
    }

    static TileIndex create(File file, int numTiles) throws IOException {
        DataFormat dataFormat = new DataFormat(TileIndex.createType(numTiles), ByteOrder.BIG_ENDIAN);
        DataContext context = dataFormat.createContext(file, "r");
        CompoundData data = context.createData();
        HashMap<Integer, IndexEntry> index = new HashMap<Integer, IndexEntry>(numTiles);
        SequenceData indexSeq = data.getSequence("Indices");
        for (int i = 0; i < numTiles; ++i) {
            CompoundData indexData = indexSeq.getCompound(i);
            int size = indexData.getInt(1);
            int offset = indexData.getInt(0);
            IndexEntry indexEntry = new IndexEntry(offset * 2, size * 2);
            index.put(i, indexEntry);
        }
        context.dispose();
        return new TileIndex(index);
    }

    private static CompoundType createType(int numtiles) {
        return TypeBuilder.COMPOUND((String)"Header", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Magic", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)8)), TypeBuilder.MEMBER((String)"ZeroFill1", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)16)), TypeBuilder.MEMBER((String)"TFileSize", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"ZeroFill2", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)72)), TypeBuilder.MEMBER((String)"Indices", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.COMPOUND((String)"Entry", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Offset", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"Size", (Type)TypeBuilder.INT)}), (int)numtiles))});
    }

    static class IndexEntry {
        final int offset;
        final int size;

        IndexEntry(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

