/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl.jxpath;

import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeaturePropertyHandler
implements DynamicPropertyHandler {
    public String[] getPropertyNames(Object object) {
        SimpleFeature feature = (SimpleFeature)object;
        SimpleFeatureType featureType = feature.getFeatureType();
        String[] propertyNames = new String[featureType.getAttributeCount()];
        for (int i = 0; i < propertyNames.length; ++i) {
            propertyNames[i] = featureType.getDescriptor(i).getLocalName();
        }
        return propertyNames;
    }

    public Object getProperty(Object object, String property) {
        SimpleFeature feature = (SimpleFeature)object;
        Object value = feature.getAttribute(this.property(property));
        if (value != null) {
            return value;
        }
        if ("fid".equals(property) || property.matches("(\\w+:)?id")) {
            return feature.getID();
        }
        return null;
    }

    public void setProperty(Object object, String property, Object value) {
        SimpleFeature feature = (SimpleFeature)object;
        try {
            feature.setAttribute(this.property(property), value);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
    }

    String property(String property) {
        int i = property.indexOf(":");
        if (i != -1) {
            property = property.substring(i + 1);
        }
        return property;
    }
}

