/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.FileEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateFile;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.model.AutoCompleteTextArea;
import org.esa.snap.ui.tooladapter.model.OperatorParametersTable;

public class TemplateParameterEditorDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(TemplateParameterEditorDialog.class.getName());
    private static String EMPTY_FILE_CONTENT = "[no content]";
    private TemplateParameterDescriptor parameter;
    private ToolAdapterOperatorDescriptor fakeOperatorDescriptor;
    private ToolAdapterOperatorDescriptor parentDescriptor;
    private AppContext appContext;
    private AutoCompleteTextArea fileContentArea;
    private OperatorParametersTable paramsTable;
    private BindingContext paramContext;

    public TemplateParameterEditorDialog(AppContext appContext, TemplateParameterDescriptor parameter, ToolAdapterOperatorDescriptor parent) {
        super(appContext.getApplicationWindow(), parameter.getName(), 33, "");
        this.appContext = appContext;
        EscapeAction.register(this.getJDialog());
        this.fileContentArea = new AutoCompleteTextArea("", 10, 10);
        this.parameter = parameter;
        this.parentDescriptor = parent;
        try {
            PropertyDescriptor propertyDescriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)this.parameter, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            propertySetDescriptor.addPropertyDescriptor(propertyDescriptor);
            PropertyContainer paramContainer = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            this.paramContext = new BindingContext((PropertySet)paramContainer);
        }
        catch (ConversionException e) {
            logger.warning(e.getMessage());
        }
        try {
            parameter.setTemplateEngine(this.parentDescriptor.getTemplateEngine());
        }
        catch (TemplateException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
        }
        this.fakeOperatorDescriptor = new ToolAdapterOperatorDescriptor("OperatorForParameters", ToolAdapterOp.class);
        for (ToolParameterDescriptor param : parameter.getParameterDescriptors()) {
            this.fakeOperatorDescriptor.getToolParameterDescriptors().add(new ToolParameterDescriptor((DefaultParameterDescriptor)param));
        }
        PropertyChangeListener pcListener = evt -> this.updateFileAreaContent();
        this.paramContext.addPropertyChangeListener(pcListener);
        this.addComponents();
    }

    private JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(paramsPanel, 3);
        paramsPanel.setLayout(layout);
        AbstractButton addParamBut = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/Add16.png"), (boolean)false);
        addParamBut.setAlignmentX(0.0f);
        paramsPanel.add(addParamBut);
        this.paramsTable = new OperatorParametersTable(this.fakeOperatorDescriptor, this.appContext);
        JScrollPane tableScrollPane = new JScrollPane(this.paramsTable);
        tableScrollPane.setPreferredSize(new Dimension(500, 130));
        tableScrollPane.setAlignmentX(0.0f);
        paramsPanel.add(tableScrollPane);
        addParamBut.addActionListener(e -> this.paramsTable.addParameterToTable());
        TitledBorder title = BorderFactory.createTitledBorder("Template Parameters");
        paramsPanel.setBorder(title);
        return paramsPanel;
    }

    private Property getProperty() {
        Property[] properties = this.paramContext.getPropertySet().getProperties();
        return properties[0];
    }

    private void addComponents() {
        Property property = this.getProperty();
        try {
            property.setValue((Object)this.parameter.getTemplate().getTemplatePath());
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        FileEditor fileEditor = new FileEditor();
        JComponent filePathComponent = fileEditor.createEditorComponent(property.getDescriptor(), this.paramContext);
        filePathComponent.setPreferredSize(new Dimension(770, 25));
        JPanel filePanel = new JPanel();
        filePanel.add(new JLabel("File:"));
        filePanel.add(filePathComponent);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize(new Dimension(800, 550));
        mainPanel.add((Component)filePanel, "First");
        this.fileContentArea.setAutoCompleteEntries(this.getAutocompleteEntries());
        this.fileContentArea.setTriggerChar('$');
        mainPanel.add((Component)new JScrollPane(this.fileContentArea), "Center");
        this.updateFileAreaContent();
        mainPanel.add((Component)this.createParametersPanel(), "Last");
        this.setContent(mainPanel);
    }

    private void updateFileAreaContent() {
        String result = null;
        try {
            File file = (File)this.getProperty().getValue();
            this.parameter.getTemplate().setFileName(file.getName());
            if (!file.isAbsolute()) {
                file = this.parameter.getTemplate().getTemplatePath();
            }
            if (file.exists()) {
                result = new String(Files.readAllBytes(file.toPath()));
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            this.showWarningDialog("There was an error loading the template file: " + e.getMessage());
        }
        if (result != null) {
            this.fileContentArea.setText(result);
            this.fileContentArea.setCaretPosition(0);
        } else {
            this.fileContentArea.setText(EMPTY_FILE_CONTENT);
        }
    }

    protected void onOK() {
        super.onOK();
        TemplateFile template = this.parameter.getTemplate();
        this.parameter.setDefaultValue(template.getFileName());
        this.parameter.getParameterDescriptors().clear();
        for (ToolParameterDescriptor subparameter : this.fakeOperatorDescriptor.getToolParameterDescriptors()) {
            Object propertyValue;
            if (this.paramsTable.getBindingContext().getBinding(subparameter.getName()) != null && (propertyValue = this.paramsTable.getBindingContext().getBinding(subparameter.getName()).getPropertyValue()) != null) {
                subparameter.setDefaultValue(propertyValue.toString());
            }
            this.parameter.addParameterDescriptor(subparameter);
        }
        try {
            String content = this.fileContentArea.getText();
            if (!content.equals(EMPTY_FILE_CONTENT)) {
                template.setContents(content, true);
                template.save();
            }
        }
        catch (IOException | TemplateException e) {
            logger.warning(e.getMessage());
        }
    }

    private List<String> getAutocompleteEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        entries.addAll(this.parentDescriptor.getVariables().stream().map(SystemVariable::getKey).collect(Collectors.toList()));
        for (ParameterDescriptor parameterDescriptor : this.fakeOperatorDescriptor.getParameterDescriptors()) {
            entries.add(parameterDescriptor.getName());
        }
        entries.sort(Comparator.naturalOrder());
        return entries;
    }
}

