/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace2_5min;

import java.io.File;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.ace2_5min.ACE2_5MinElevationModelDescriptor;
import org.esa.snap.dem.dataio.ace2_5min.ACE2_5MinFile;

public class ACE2_5MinElevationModel
extends BaseElevationModel {
    private static final String DB_FILE_SUFFIX = "_5M.ACE2";
    private static final ProductReaderPlugIn productReaderPlugIn = ACE2_5MinElevationModel.getReaderPlugIn((String)"ACE2");

    public ACE2_5MinElevationModel(ACE2_5MinElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
    }

    public double getIndexX(GeoPos geoPos) {
        return (geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - (geoPos.lat + 90.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = 90.0 - pixelPos.y * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 90;
        String fileName = this.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new ACE2_5MinFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private String createTileFilename(int minLat, int minLon) {
        String lonString;
        String latString;
        String string = latString = minLat < 0 ? Math.abs(minLat) + "S" : minLat + "N";
        while (latString.length() < 3) {
            latString = '0' + latString;
        }
        String string2 = lonString = minLon < 0 ? Math.abs(minLon) + "W" : minLon + "E";
        while (lonString.length() < 4) {
            lonString = '0' + lonString;
        }
        return latString + lonString + DB_FILE_SUFFIX;
    }
}

