/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.dem.dataio.ace.ACEElevationModel;
import org.esa.snap.dem.dataio.ace.ACEElevationTile;
import org.esa.snap.engine_utilities.util.Settings;

public final class ACEFile
extends ElevationFile {
    private final ACEElevationModel demModel;
    private static final String remoteHTTP = Settings.instance().get("DEM.aceDEM_HTTP", "http://step.esa.int/auxdata/dem/ACE30/");

    public ACEFile(ACEElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        ACEElevationTile tile = new ACEElevationTile(this.demModel, product);
        this.demModel.updateCache((ElevationTile)tile);
        return tile;
    }

    protected Boolean getRemoteFile() throws IOException {
        return this.getRemoteHttpFile(remoteHTTP);
    }
}

