/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.collocation.visat;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.collocation.ResamplingType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.ui.AppContext;

class CollocationForm
extends JPanel {
    private static final String DEFAULT_TARGET_PRODUCT_NAME = "collocate";
    private SourceProductSelector masterProductSelector;
    private SourceProductSelector slaveProductSelector;
    private JCheckBox renameMasterComponentsCheckBox;
    private JCheckBox renameSlaveComponentsCheckBox;
    private JTextField masterComponentPatternField;
    private JTextField slaveComponentPatternField;
    private JComboBox<ResamplingType> resamplingComboBox;
    private DefaultComboBoxModel<ResamplingType> resamplingComboBoxModel;
    private TargetProductSelector targetProductSelector;

    public CollocationForm(PropertySet propertySet, TargetProductSelector targetProductSelector, AppContext appContext) {
        this.targetProductSelector = targetProductSelector;
        this.masterProductSelector = new SourceProductSelector(appContext, "Master (pixel values are conserved):");
        this.slaveProductSelector = new SourceProductSelector(appContext, "Slave (pixel values are resampled onto the master grid):");
        this.renameMasterComponentsCheckBox = new JCheckBox("Rename master components:");
        this.renameSlaveComponentsCheckBox = new JCheckBox("Rename slave components:");
        this.masterComponentPatternField = new JTextField();
        this.slaveComponentPatternField = new JTextField();
        this.resamplingComboBoxModel = new DefaultComboBoxModel<ResamplingType>(ResamplingType.values());
        this.resamplingComboBox = new JComboBox<ResamplingType>(this.resamplingComboBoxModel);
        this.slaveProductSelector.getProductNameComboBox().addActionListener(e -> {
            Product slaveProduct = this.slaveProductSelector.getSelectedProduct();
            boolean validPixelExpressionUsed = CollocationForm.isValidPixelExpressionUsed(slaveProduct);
            CollocationForm.adaptResamplingComboBoxModel(this.resamplingComboBoxModel, validPixelExpressionUsed);
        });
        this.createComponents();
        this.bindComponents(propertySet);
    }

    public void prepareShow() {
        this.masterProductSelector.initProducts();
        if (this.masterProductSelector.getProductCount() > 0) {
            this.masterProductSelector.setSelectedIndex(0);
        }
        this.slaveProductSelector.initProducts();
        if (this.slaveProductSelector.getProductCount() > 1) {
            this.slaveProductSelector.setSelectedIndex(1);
        }
    }

    public void prepareHide() {
        this.masterProductSelector.releaseProducts();
        this.slaveProductSelector.releaseProducts();
    }

    Product getMasterProduct() {
        return this.masterProductSelector.getSelectedProduct();
    }

    Product getSlaveProduct() {
        return this.slaveProductSelector.getSelectedProduct();
    }

    private void createComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createSourceProductPanel());
        this.add(this.createTargetProductPanel());
        this.add(this.createRenamingPanel());
        this.add(this.createResamplingPanel());
    }

    private void bindComponents(PropertySet propertySet) {
        BindingContext sbc = new BindingContext(propertySet);
        sbc.bind("renameMasterComponents", this.renameMasterComponentsCheckBox);
        sbc.bind("renameSlaveComponents", this.renameSlaveComponentsCheckBox);
        sbc.bind("masterComponentPattern", this.masterComponentPatternField);
        sbc.bind("slaveComponentPattern", this.slaveComponentPatternField);
        sbc.bind("resamplingType", this.resamplingComboBox);
        sbc.bindEnabledState("masterComponentPattern", true, "renameMasterComponents", (Object)true);
        sbc.bindEnabledState("slaveComponentPattern", true, "renameSlaveComponents", (Object)true);
    }

    private JPanel createSourceProductPanel() {
        JPanel masterPanel = new JPanel(new BorderLayout(3, 3));
        masterPanel.add((Component)this.masterProductSelector.getProductNameLabel(), "North");
        this.masterProductSelector.getProductNameComboBox().setPrototypeDisplayValue("MER_RR__1PPBCM20030730_071000_000003972018_00321_07389_0000.N1");
        masterPanel.add((Component)this.masterProductSelector.getProductNameComboBox(), "Center");
        masterPanel.add((Component)this.masterProductSelector.getProductFileChooserButton(), "East");
        JPanel slavePanel = new JPanel(new BorderLayout(3, 3));
        slavePanel.add((Component)this.slaveProductSelector.getProductNameLabel(), "North");
        slavePanel.add((Component)this.slaveProductSelector.getProductNameComboBox(), "Center");
        slavePanel.add((Component)this.slaveProductSelector.getProductFileChooserButton(), "East");
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        layout.setCellPadding(1, 0, new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Source Products"));
        panel.add(masterPanel);
        panel.add(slavePanel);
        return panel;
    }

    private JPanel createTargetProductPanel() {
        this.targetProductSelector.getModel().setProductName(DEFAULT_TARGET_PRODUCT_NAME);
        return this.targetProductSelector.createDefaultPanel();
    }

    private JPanel createRenamingPanel() {
        TableLayout layout = new TableLayout(2);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        layout.setCellPadding(1, 0, new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Renaming of Source Product Components"));
        panel.add(this.renameMasterComponentsCheckBox);
        panel.add(this.masterComponentPatternField);
        panel.add(this.renameSlaveComponentsCheckBox);
        panel.add(this.slaveComponentPatternField);
        return panel;
    }

    private JPanel createResamplingPanel() {
        TableLayout layout = new TableLayout(3);
        layout.setTableAnchor(TableLayout.Anchor.LINE_START);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(0.0));
        layout.setColumnWeightX(2, Double.valueOf(1.0));
        layout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Resampling"));
        panel.add(new JLabel("Method:"));
        panel.add(this.resamplingComboBox);
        panel.add(new JLabel());
        return panel;
    }

    static void adaptResamplingComboBoxModel(DefaultComboBoxModel<ResamplingType> comboBoxModel, boolean isValidPixelExpressionUsed) {
        if (isValidPixelExpressionUsed) {
            if (comboBoxModel.getSize() == 5) {
                comboBoxModel.removeElement(ResamplingType.BICUBIC_CONVOLUTION);
                comboBoxModel.removeElement(ResamplingType.BISINC_CONVOLUTION);
                comboBoxModel.removeElement(ResamplingType.CUBIC_CONVOLUTION);
                comboBoxModel.removeElement(ResamplingType.BILINEAR_INTERPOLATION);
                comboBoxModel.setSelectedItem(ResamplingType.NEAREST_NEIGHBOUR);
            }
        } else if (comboBoxModel.getSize() == 1) {
            comboBoxModel.addElement(ResamplingType.BILINEAR_INTERPOLATION);
            comboBoxModel.addElement(ResamplingType.CUBIC_CONVOLUTION);
            comboBoxModel.addElement(ResamplingType.BICUBIC_CONVOLUTION);
            comboBoxModel.addElement(ResamplingType.BISINC_CONVOLUTION);
        }
    }

    static boolean isValidPixelExpressionUsed(Product product) {
        if (product != null) {
            for (Band band : product.getBands()) {
                String expression = band.getValidPixelExpression();
                if (expression == null || expression.trim().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

