/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.esa.snap.core.util.converters.RectangleConverter;

@OperatorMetadata(alias="Subset", category="Raster/Geometric", authors="Marco Zuehlke, Norman Fomferra, Marco Peters", version="1.2", copyright="(c) 2011 by Brockmann Consult", description="Create a spatial and/or spectral subset of a data product.")
public class SubsetOp
extends Operator {
    @SourceProduct(alias="source", description="The source product to create the subset from.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] bandNames;
    @Parameter(converter=RectangleConverter.class, description="The subset region in pixel coordinates.\nUse the following format: <x>,<y>,<width>,<height>\nIf not given, the entire scene is used. The 'geoRegion' parameter has precedence over this parameter.")
    private Rectangle region = null;
    @Parameter(converter=JtsGeometryConverter.class, description="The subset region in geographical coordinates using WKT-format,\ne.g. POLYGON((<lon1> <lat1>, <lon2> <lat2>, ..., <lon1> <lat1>))\n(make sure to quote the option due to spaces in <geometry>).\nIf not given, the entire scene is used.")
    private Geometry geoRegion;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in X (horizontal image direction)")
    private int subSamplingX = 1;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in Y (vertical image direction)")
    private int subSamplingY = 1;
    @Parameter(defaultValue="false", description="Forces the operator to extend the subset region to the full swath.")
    private boolean fullSwath = false;
    @Parameter(description="The comma-separated list of names of tie-point grids to be copied. \nIf not given, all bands are copied.")
    private String[] tiePointGridNames;
    @Parameter(defaultValue="false", description="Whether to copy the metadata of the source product.")
    private boolean copyMetadata = false;
    private transient ProductReader subsetReader;

    public String[] getTiePointGridNames() {
        return this.tiePointGridNames != null ? (String[])this.tiePointGridNames.clone() : null;
    }

    public void setTiePointGridNames(String[] tiePointGridNames) {
        this.tiePointGridNames = tiePointGridNames != null ? (String[])tiePointGridNames.clone() : null;
    }

    public String[] getBandNames() {
        return this.bandNames != null ? (String[])this.bandNames.clone() : null;
    }

    public void setBandNames(String[] bandNames) {
        this.bandNames = bandNames != null ? (String[])bandNames.clone() : null;
    }

    public void setCopyMetadata(boolean copyMetadata) {
        this.copyMetadata = copyMetadata;
    }

    public Rectangle getRegion() {
        return this.region != null ? new Rectangle(this.region) : null;
    }

    public void setRegion(Rectangle region) {
        this.region = region != null ? new Rectangle(region) : null;
    }

    public void setSubSamplingX(int subSamplingX) {
        this.subSamplingX = subSamplingX;
    }

    public void setSubSamplingY(int subSamplingY) {
        this.subSamplingY = subSamplingY;
    }

    public Geometry getGeoRegion() {
        return this.geoRegion;
    }

    public void setGeoRegion(Geometry geoRegion) {
        this.geoRegion = geoRegion;
    }

    @Override
    public void initialize() throws OperatorException {
        this.ensureSingleRasterSize(this.sourceProduct);
        this.subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        if (this.tiePointGridNames != null) {
            subsetDef.addNodeNames(this.tiePointGridNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getTiePointGridNames());
        }
        if (this.bandNames != null && this.bandNames.length > 0) {
            subsetDef.addNodeNames(this.bandNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getBandNames());
        }
        String[] nodeNames = subsetDef.getNodeNames();
        if (nodeNames != null) {
            ArrayList<String> referencedNodeNames = new ArrayList<String>();
            for (String nodeName : nodeNames) {
                this.collectReferencedRasters(nodeName, referencedNodeNames);
            }
            subsetDef.addNodeNames(referencedNodeNames.toArray(new String[referencedNodeNames.size()]));
        }
        if (this.geoRegion != null) {
            this.region = SubsetOp.computePixelRegion(this.sourceProduct, this.geoRegion, 0);
            if (this.region.isEmpty()) {
                this.targetProduct = new Product("Empty_" + this.sourceProduct.getName(), "EMPTY", 0, 0);
                String msg = "No intersection with source product boundary " + this.sourceProduct.getName();
                this.targetProduct.setDescription(msg);
                this.getLogger().log(Level.WARNING, msg);
                return;
            }
        }
        if (this.fullSwath) {
            this.region = new Rectangle(0, this.region.y, this.sourceProduct.getSceneRasterWidth(), this.region.height);
        }
        if (this.region != null && !this.region.isEmpty()) {
            if (this.region.width == 0 || this.region.x + this.region.width > this.sourceProduct.getSceneRasterWidth()) {
                this.region.width = this.sourceProduct.getSceneRasterWidth() - this.region.x;
            }
            if (this.region.height == 0 || this.region.y + this.region.height > this.sourceProduct.getSceneRasterHeight()) {
                this.region.height = this.sourceProduct.getSceneRasterHeight() - this.region.y;
            }
            subsetDef.setRegion(this.region);
        }
        subsetDef.setSubSampling(this.subSamplingX, this.subSamplingY);
        subsetDef.setIgnoreMetadata(!this.copyMetadata);
        try {
            this.targetProduct = this.subsetReader.readProductNodes((Object)this.sourceProduct, subsetDef);
            this.targetProduct.setName("Subset_" + this.targetProduct.getName());
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private void collectReferencedRasters(String nodeName, ArrayList<String> referencedNodeNames) {
        RasterDataNode rasterDataNode = this.sourceProduct.getRasterDataNode(nodeName);
        if (rasterDataNode == null) {
            throw new OperatorException(String.format("Source product does not contain a raster named '%s'.", nodeName));
        }
        String validPixelExpression = rasterDataNode.getValidPixelExpression();
        this.collectReferencedRastersInExpression(validPixelExpression, referencedNodeNames);
        if (rasterDataNode instanceof VirtualBand) {
            VirtualBand vBand = (VirtualBand)rasterDataNode;
            this.collectReferencedRastersInExpression(vBand.getExpression(), referencedNodeNames);
        }
    }

    private void collectReferencedRastersInExpression(String expression, ArrayList<String> referencedNodeNames) {
        if (expression == null || expression.trim().isEmpty()) {
            return;
        }
        try {
            RasterDataNode[] refRasters;
            Term term = this.sourceProduct.parseExpression(expression);
            for (RasterDataNode refRaster : refRasters = BandArithmetic.getRefRasters((Term[])new Term[]{term})) {
                String refNodeName = refRaster.getName();
                if (referencedNodeNames.contains(refNodeName)) continue;
                referencedNodeNames.add(refNodeName);
                this.collectReferencedRastersInExpression(refNodeName, referencedNodeNames);
            }
        }
        catch (ParseException e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData destBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.subsetReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, destBuffer, pm);
            targetTile.setRawSamples(destBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static Rectangle computePixelRegion(Product product, Geometry geoRegion, int numBorderPixels) {
        Geometry productGeometry = SubsetOp.computeProductGeometry(product);
        Geometry regionIntersection = geoRegion.intersection(productGeometry);
        if (regionIntersection.isEmpty()) {
            return new Rectangle();
        }
        PixelRegionFinder pixelRegionFinder = new PixelRegionFinder(product.getSceneGeoCoding());
        regionIntersection.apply((CoordinateFilter)pixelRegionFinder);
        Rectangle pixelRegion = pixelRegionFinder.getPixelRegion();
        pixelRegion.grow(numBorderPixels, numBorderPixels);
        return pixelRegion.intersection(new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight()));
    }

    static Geometry computeProductGeometry(Product product) {
        GeneralPath[] paths = ProductUtils.createGeoBoundaryPaths((Product)product);
        Polygon[] polygons = new Polygon[paths.length];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < paths.length; ++i) {
            polygons[i] = SubsetOp.convertAwtPathToJtsPolygon(paths[i], factory);
        }
        DouglasPeuckerSimplifier peuckerSimplifier = new DouglasPeuckerSimplifier((Geometry)(polygons.length == 1 ? polygons[0] : factory.createMultiPolygon(polygons)));
        return peuckerSimplifier.getResultGeometry();
    }

    private static Polygon convertAwtPathToJtsPolygon(Path2D path, GeometryFactory factory) {
        PathIterator pathIterator = path.getPathIterator(null);
        ArrayList<Object> coordList = new ArrayList<Object>();
        int lastOpenIndex = 0;
        while (!pathIterator.isDone()) {
            double[] coords = new double[6];
            int segType = pathIterator.currentSegment(coords);
            if (segType == 4) {
                coordList.add(coordList.get(lastOpenIndex));
                lastOpenIndex = coordList.size();
            } else {
                coordList.add(coords);
            }
            pathIterator.next();
        }
        Coordinate[] coordinates = new Coordinate[coordList.size()];
        for (int i1 = 0; i1 < coordinates.length; ++i1) {
            double[] coord = (double[])coordList.get(i1);
            coordinates[i1] = new Coordinate(coord[0], coord[1]);
        }
        return factory.createPolygon(factory.createLinearRing(coordinates), null);
    }

    private static class PixelRegionFinder
    implements CoordinateFilter {
        private final GeoCoding geoCoding;
        private int x1;
        private int y1;
        private int x2;
        private int y2;

        private PixelRegionFinder(GeoCoding geoCoding) {
            this.geoCoding = geoCoding;
            this.x1 = Integer.MAX_VALUE;
            this.x2 = Integer.MIN_VALUE;
            this.y1 = Integer.MAX_VALUE;
            this.y2 = Integer.MIN_VALUE;
        }

        public void filter(Coordinate coordinate) {
            GeoPos geoPos = new GeoPos(coordinate.y, coordinate.x);
            PixelPos pixelPos = this.geoCoding.getPixelPos(geoPos, null);
            if (pixelPos.isValid()) {
                this.x1 = Math.min(this.x1, (int)Math.floor(pixelPos.x));
                this.x2 = Math.max(this.x2, (int)Math.ceil(pixelPos.x));
                this.y1 = Math.min(this.y1, (int)Math.floor(pixelPos.y));
                this.y2 = Math.max(this.y2, (int)Math.ceil(pixelPos.y));
            }
        }

        public Rectangle getPixelRegion() {
            return new Rectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SubsetOp.class);
        }
    }
}

