/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;

@OperatorMetadata(alias="Merge", category="Raster", description="Allows copying raster data from any number of source products to a specified 'master' product.", authors="BEAM team", version="1.1", copyright="(c) 2012 by Brockmann Consult", internal=false)
public class MergeOp
extends Operator {
    @SourceProduct(description="The master product, which receives nodes from subsequently provided products.")
    private Product masterProduct;
    @SourceProducts(description="The products to be merged into the master product.")
    private Product[] sourceProducts;
    @TargetProduct
    private Product targetProduct;
    @Parameter(itemAlias="include", description="Defines nodes to be included in the master product. If no includes are provided, all nodes are copied.")
    private NodeDescriptor[] includes;
    @Parameter(itemAlias="exclude", description="Defines nodes to be excluded from the target product (not supported yet).")
    private NodeDescriptor[] excludes;
    @Parameter(defaultValue="1.0E-5f", description="Defines the maximum lat/lon error in degree between the products. If set to NaN no check for compatible geographic boundary is performed")
    private float geographicError;

    @Override
    public void initialize() throws OperatorException {
        this.targetProduct = this.masterProduct;
        this.validateSourceProducts();
        if (this.includes == null || this.includes.length == 0) {
            ArrayList<NodeDescriptor> nodeDescriptorList = new ArrayList<NodeDescriptor>();
            for (Product product : this.sourceProducts) {
                if (product == this.targetProduct) continue;
                for (String bandName : product.getBandNames()) {
                    NodeDescriptor nodeDescriptor = new NodeDescriptor();
                    nodeDescriptor.name = bandName;
                    nodeDescriptor.productId = this.getSourceProductId(product);
                    nodeDescriptorList.add(nodeDescriptor);
                }
            }
            this.includes = nodeDescriptorList.toArray(new NodeDescriptor[nodeDescriptorList.size()]);
        }
        if (this.excludes != null && this.excludes.length != 0) {
            throw new OperatorException("Defining excludes is not supported yet.");
        }
        HashSet<Product> allSrcProducts = new HashSet<Product>();
        for (Product product : this.includes) {
            Product srcProduct = this.getSourceProduct(((NodeDescriptor)product).productId);
            if (srcProduct == this.targetProduct) continue;
            if (StringUtils.isNotNullAndNotEmpty((String)((NodeDescriptor)product).name)) {
                if (StringUtils.isNotNullAndNotEmpty((String)((NodeDescriptor)product).newName)) {
                    this.copyBandWithFeatures(srcProduct, ((NodeDescriptor)product).name, ((NodeDescriptor)product).newName);
                } else {
                    this.copyBandWithFeatures(srcProduct, ((NodeDescriptor)product).name, ((NodeDescriptor)product).name);
                }
                allSrcProducts.add(srcProduct);
                continue;
            }
            if (!StringUtils.isNotNullAndNotEmpty((String)((NodeDescriptor)product).namePattern)) continue;
            Pattern pattern = Pattern.compile(((NodeDescriptor)product).namePattern);
            for (String bandName : srcProduct.getBandNames()) {
                Matcher matcher = pattern.matcher(bandName);
                if (!matcher.matches()) continue;
                this.copyBandWithFeatures(srcProduct, bandName, bandName);
                allSrcProducts.add(srcProduct);
            }
        }
        for (Product srcProduct : allSrcProducts) {
            if (srcProduct == this.targetProduct) continue;
            this.mergeAutoGrouping(srcProduct);
            ProductUtils.copyMasks((Product)srcProduct, (Product)this.targetProduct);
            ProductUtils.copyOverlayMasks((Product)srcProduct, (Product)this.targetProduct);
        }
    }

    private void mergeAutoGrouping(Product srcProduct) {
        Product.AutoGrouping srcAutoGrouping = srcProduct.getAutoGrouping();
        if (srcAutoGrouping != null && !srcAutoGrouping.isEmpty()) {
            Product.AutoGrouping targetAutoGrouping = this.targetProduct.getAutoGrouping();
            if (targetAutoGrouping == null) {
                this.targetProduct.setAutoGrouping(srcAutoGrouping);
            } else {
                for (String[] grouping : srcAutoGrouping) {
                    if (targetAutoGrouping.contains((Object)grouping)) continue;
                    this.targetProduct.setAutoGrouping(targetAutoGrouping.toString() + ":" + srcAutoGrouping);
                }
            }
        }
    }

    private void copyBandWithFeatures(Product sourceProduct, String oldBandName, String newBandName) {
        Band sourceBand = sourceProduct.getBand(oldBandName);
        if (sourceBand == null) {
            String msg = String.format("Source product [%s] does not contain a band with name [%s]", sourceProduct.getName(), oldBandName);
            throw new OperatorException(msg);
        }
        if (this.targetProduct.containsBand(newBandName)) {
            return;
        }
        ProductUtils.copyBand((String)oldBandName, (Product)sourceProduct, (String)newBandName, (Product)this.targetProduct, (boolean)true);
    }

    private void validateSourceProducts() {
        for (Product sourceProduct : this.getSourceProducts()) {
            if (Float.isNaN(this.geographicError) || this.targetProduct.isCompatibleProduct(sourceProduct, this.geographicError)) continue;
            throw new OperatorException(String.format("Product [%s] is not compatible to master product.", this.getSourceProductId(sourceProduct)));
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        this.getLogger().warning("Wrongly configured operator. Tiles should not be requested.");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MergeOp.class);
        }
    }

    public static class NodeDescriptor {
        private String productId;
        private String name;
        private String newName;
        private String namePattern;

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }
    }
}

