/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import java.util.Iterator;
import java.util.SortedSet;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class LibSVM
extends AbstractClassifier {
    public static svm_print_interface svm_print_console = null;
    public static svm_print_interface svm_print_null = new svm_print_interface(){

        public void print(String s) {
        }
    };
    private static final long serialVersionUID = -8901871714620581945L;
    private svm_parameter param = new svm_parameter();
    private Dataset data;
    private svm_model model;
    private double[] weights;

    public LibSVM() {
        this.param.svm_type = 0;
        this.param.C = 1.0;
        this.param.kernel_type = 0;
        this.param.degree = 1;
        this.param.gamma = 0.0;
        this.param.coef0 = 0.0;
        this.param.nu = 0.5;
        this.param.cache_size = 100.0;
        this.param.eps = 0.001;
        this.param.p = 0.1;
        this.param.shrinking = 1;
        this.param.probability = 0;
        this.param.nr_weight = 0;
        this.param.weight_label = new int[0];
        this.param.weight = new double[0];
    }

    public svm_parameter getParameters() {
        return this.param;
    }

    private static svm_problem transformDataset(Dataset data) {
        svm_problem p = new svm_problem();
        p.l = data.size();
        p.y = new double[data.size()];
        p.x = new svm_node[data.size()][];
        int tmpIndex = 0;
        for (int j = 0; j < data.size(); ++j) {
            Instance tmp = data.instance(j);
            p.y[tmpIndex] = data.classIndex(tmp.classValue());
            p.x[tmpIndex] = new svm_node[tmp.keySet().size()];
            int i = 0;
            SortedSet<Integer> tmpSet = tmp.keySet();
            Iterator i$ = tmpSet.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                p.x[tmpIndex][i] = new svm_node();
                p.x[tmpIndex][i].index = index;
                p.x[tmpIndex][i].value = tmp.value(index);
                ++i;
            }
            ++tmpIndex;
        }
        return p;
    }

    public void setParameters(svm_parameter param) {
        this.param = param;
    }

    public static void setPrintInterface(svm_print_interface print) {
        svm.svm_set_print_string_function((svm_print_interface)print);
    }

    @Override
    public void buildClassifier(Dataset data) {
        int j;
        int i;
        super.buildClassifier(data);
        this.data = data;
        svm_problem p = LibSVM.transformDataset(data);
        this.model = svm.svm_train((svm_problem)p, (svm_parameter)this.param);
        double[][] coef = this.model.sv_coef;
        assert (this.model.SV != null);
        assert (this.model.SV.length > 0);
        double[][] prob = new double[this.model.SV.length][data.noAttributes()];
        for (i = 0; i < this.model.SV.length; ++i) {
            for (j = 0; j < data.noAttributes(); ++j) {
                prob[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.model.SV.length; ++i) {
            for (j = 0; j < this.model.SV[i].length; ++j) {
                prob[i][this.model.SV[i][j].index] = this.model.SV[i][j].value;
            }
        }
        if (this.param.svm_type == 0) {
            int j2;
            int i2;
            double[][][] w_list = new double[this.model.nr_class][this.model.nr_class - 1][data.noAttributes()];
            for (i2 = 0; i2 < data.noAttributes(); ++i2) {
                for (j2 = 0; j2 < this.model.nr_class - 1; ++j2) {
                    int index = 0;
                    int end = 0;
                    for (int k = 0; k < this.model.nr_class; ++k) {
                        double acc = 0.0;
                        end = (index += k == 0 ? 0 : this.model.nSV[k - 1]) + this.model.nSV[k];
                        for (int m = index; m < end; ++m) {
                            acc += coef[j2][m] * prob[m][i2];
                        }
                        w_list[k][j2][i2] = acc;
                    }
                }
            }
            this.weights = new double[data.noAttributes()];
            for (i2 = 0; i2 < this.model.nr_class - 1; ++i2) {
                j2 = i2 + 1;
                int k = i2;
                while (j2 < this.model.nr_class) {
                    for (int m = 0; m < data.noAttributes(); ++m) {
                        this.weights[m] = w_list[i2][k][m] + w_list[j2][i2][m];
                    }
                    ++j2;
                    ++k;
                }
            }
        } else {
            this.weights = null;
        }
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double[] rawDecisionValues(Instance i) {
        return this.svm_predict_raw(this.model, this.convert(i));
    }

    private double[] svm_predict_raw(svm_model model, svm_node[] x) {
        if (model.param.svm_type == 2 || model.param.svm_type == 3 || model.param.svm_type == 4) {
            double[] res = new double[1];
            svm.svm_predict_values((svm_model)model, (svm_node[])x, (double[])res);
            return res;
        }
        int nr_class = model.nr_class;
        double[] dec_values = new double[nr_class * (nr_class - 1) / 2];
        svm.svm_predict_values((svm_model)model, (svm_node[])x, (double[])dec_values);
        return dec_values;
    }

    private svm_node[] convert(Instance instance) {
        svm_node[] x = new svm_node[instance.noAttributes()];
        for (int i = 0; i < instance.noAttributes(); ++i) {
            x[i] = new svm_node();
            x[i].index = i;
            x[i].value = instance.value(i);
        }
        return x;
    }

    @Override
    public Object classify(Instance instance) {
        svm_node[] x = this.convert(instance);
        double d = svm.svm_predict((svm_model)this.model, (svm_node[])x);
        Object out = this.data.classValue((int)d);
        return out;
    }

    public int[] getLabels() {
        int[] res = new int[this.model.nr_class];
        svm.svm_get_labels((svm_model)this.model, (int[])res);
        return res;
    }

    static {
        svm.svm_set_print_string_function((svm_print_interface)svm_print_null);
    }
}

