/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultServiceRegistry<T>
implements ServiceRegistry<T> {
    private final Class<T> serviceType;
    private final HashMap<String, T> services;
    private final ArrayList<ServiceRegistryListener<T>> listeners;

    public DefaultServiceRegistry(Class<T> serviceType) {
        Assert.notNull(serviceType, "serviceType");
        this.serviceType = serviceType;
        this.services = new HashMap(10);
        this.listeners = new ArrayList(3);
    }

    @Override
    public Class<T> getServiceType() {
        return this.serviceType;
    }

    @Override
    public Set<T> getServices() {
        return new HashSet<T>(this.services.values());
    }

    @Override
    public T getService(String className) {
        return this.services.get(className);
    }

    @Override
    public boolean addService(T service) {
        Assert.notNull(service, "service");
        T existingService = this.services.put(service.getClass().getName(), service);
        if (existingService != null && existingService.getClass().equals(service.getClass())) {
            return false;
        }
        for (ServiceRegistryListener<T> listener : this.listeners) {
            listener.serviceAdded(this, service);
        }
        return true;
    }

    @Override
    public boolean removeService(T service) {
        Assert.notNull(service, "service");
        T existingService = this.services.remove(service.getClass().getName());
        if (existingService != service) {
            return false;
        }
        for (ServiceRegistryListener<T> listener : this.listeners) {
            listener.serviceRemoved(this, service);
        }
        return true;
    }

    @Override
    public List<ServiceRegistryListener<T>> getListeners() {
        return (List)this.listeners.clone();
    }

    @Override
    public void addListener(ServiceRegistryListener<T> listener) {
        Assert.notNull(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ServiceRegistryListener<T> listener) {
        Assert.notNull(listener, "listener");
        this.listeners.remove(listener);
    }
}

