/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.jpy.DL;
import org.jpy.PyLibConfig;

public class PyLib {
    private static final boolean DEBUG = Boolean.getBoolean("jpy.debug");
    private static String dllFilePath;
    private static Throwable dllProblem;
    private static boolean dllLoaded;

    public static String getDllFilePath() {
        return dllFilePath;
    }

    public static void assertPythonRuns() {
        if (dllProblem != null) {
            throw new RuntimeException("PyLib not initialized", dllProblem);
        }
        if (!PyLib.isPythonRunning()) {
            throw new RuntimeException("PyLib not initialized");
        }
    }

    public static native boolean isPythonRunning();

    public static void startPython(String ... extraPaths) {
        ArrayList<File> dirList = new ArrayList<File>(1 + extraPaths.length);
        File moduleDir = new File(dllFilePath).getParentFile();
        if (moduleDir != null) {
            dirList.add(moduleDir.getAbsoluteFile());
        }
        for (String extraPath : extraPaths) {
            File extraDir = new File(extraPath).getAbsoluteFile();
            if (dirList.contains(extraDir)) continue;
            dirList.add(extraDir);
        }
        extraPaths = new String[dirList.size()];
        for (int i = 0; i < dirList.size(); ++i) {
            extraPaths[i] = ((File)dirList.get(i)).getPath();
        }
        if (DEBUG) {
            System.out.printf("org.jpy.PyLib: Starting Python with %d extra module path(s):%n", extraPaths.length);
            for (String path : extraPaths) {
                System.out.printf("org.jpy.PyLib:   %s%n", path);
            }
            Diag.setFlags(4);
        }
        PyLib.startPython0(extraPaths);
    }

    static native boolean startPython0(String ... var0);

    public static native String getPythonVersion();

    public static native void stopPython();

    @Deprecated
    public static native int execScript(String var0);

    static native long executeCode(String var0, int var1, Map<String, Object> var2, Map<String, Object> var3);

    static native void incRef(long var0);

    static native void decRef(long var0);

    static native int getIntValue(long var0);

    static native double getDoubleValue(long var0);

    static native String getStringValue(long var0);

    static native Object getObjectValue(long var0);

    static native <T> T[] getObjectArrayValue(long var0, Class<? extends T> var2);

    static native long importModule(String var0);

    static native long getAttributeObject(long var0, String var2);

    static native <T> T getAttributeValue(long var0, String var2, Class<? extends T> var3);

    static native <T> void setAttributeValue(long var0, String var2, T var3, Class<? extends T> var4);

    static native long callAndReturnObject(long var0, boolean var2, String var3, int var4, Object[] var5, Class<?>[] var6);

    static native <T> T callAndReturnValue(long var0, boolean var2, String var3, int var4, Object[] var5, Class<?>[] var6, Class<T> var7);

    private static void loadLib() {
        if (dllLoaded || dllProblem != null) {
            return;
        }
        try {
            String pythonLibPath = PyLibConfig.getProperty("jpy.pythonLib", false);
            if (pythonLibPath != null && new File(pythonLibPath).isFile()) {
                PyLib.preloadPythonLib(pythonLibPath);
            }
            dllFilePath = PyLibConfig.getProperty("jpy.jpyLib", true);
            dllFilePath = new File(dllFilePath).getAbsolutePath();
            if (DEBUG) {
                System.out.printf("org.jpy.PyLib: System.load(\"%s\")%n", dllFilePath);
            }
            System.load(dllFilePath);
            dllProblem = null;
            dllLoaded = true;
        }
        catch (Throwable t) {
            dllProblem = t;
            throw t;
        }
    }

    private static void preloadPythonLib(String pythonLibPath) {
        if (PyLibConfig.getOS() != PyLibConfig.OS.WINDOWS) {
            long handle;
            if (DEBUG) {
                System.out.printf("org.jpy.PyLib: DL.dlopen(\"%s\", DL.RTLD_GLOBAL + DL.RTLD_LAZY%n", pythonLibPath);
            }
            if ((handle = DL.dlopen(pythonLibPath, 9)) == 0L) {
                String message = "Failed to load Python shared library '" + pythonLibPath + "'";
                String dlError = DL.dlerror();
                if (dlError != null) {
                    message = message + ": " + dlError;
                }
                throw new RuntimeException(message);
            }
        } else {
            if (DEBUG) {
                System.out.printf("org.jpy.PyLib: System.load(\"%s\")%n", pythonLibPath);
            }
            try {
                System.load(pythonLibPath);
            }
            catch (Exception e) {
                String message = "Failed to load Python shared library '" + pythonLibPath + "': " + e.getMessage();
                System.err.println(message);
            }
        }
    }

    private PyLib() {
    }

    static {
        if (DEBUG) {
            System.out.println("org.jpy.PyLib: entered static initializer");
        }
        PyLib.loadLib();
        if (DEBUG) {
            System.out.println("org.jpy.PyLib: exited static initializer");
        }
    }

    public static class Diag {
        public static final int F_OFF = 0;
        public static final int F_TYPE = 1;
        public static final int F_METH = 2;
        public static final int F_EXEC = 4;
        public static final int F_MEM = 8;
        public static final int F_JVM = 16;
        public static final int F_ERR = 32;
        public static final int F_ALL = 255;

        public static native int getFlags();

        public static native void setFlags(int var0);

        private Diag() {
        }

        static {
            PyLib.loadLib();
        }
    }

    public static enum CallableKind {
        FUNCTION,
        METHOD;

    }
}

