/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.sevenzipjbinding.IArchiveOpenVolumeCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;

public class VolumedArchiveInStream
implements IInStream {
    private static final String SEVEN_ZIP_FIRST_VOLUME_POSTFIX = ".7z.001";
    private long absoluteOffset;
    private long absoluteLength = -1L;
    private int currentIndex = -1;
    private IInStream currentInStream;
    private long currentVolumeOffset;
    private long currentVolumeLength;
    private List<Long> volumePositions = new ArrayList<Long>();
    private final IArchiveOpenVolumeCallback archiveOpenVolumeCallback;
    private String cuttedVolumeFilename;

    public VolumedArchiveInStream(IArchiveOpenVolumeCallback iArchiveOpenVolumeCallback) throws SevenZipException {
        this((String)iArchiveOpenVolumeCallback.getProperty(PropID.NAME), iArchiveOpenVolumeCallback);
    }

    public VolumedArchiveInStream(String string, IArchiveOpenVolumeCallback iArchiveOpenVolumeCallback) throws SevenZipException {
        this.archiveOpenVolumeCallback = iArchiveOpenVolumeCallback;
        this.volumePositions.add(0L);
        if (!string.endsWith(SEVEN_ZIP_FIRST_VOLUME_POSTFIX)) {
            throw new SevenZipException("The first 7z volume filename '" + string + "' don't ends with the postfix: '" + SEVEN_ZIP_FIRST_VOLUME_POSTFIX + "'. Can't proceed");
        }
        this.cuttedVolumeFilename = string.substring(0, string.length() - 3);
        this.openVolume(1, true);
    }

    private void openVolume(int n, boolean bl) throws SevenZipException {
        if (this.currentIndex == n) {
            return;
        }
        for (int i = this.volumePositions.size(); i < n && this.absoluteLength == -1L; ++i) {
            this.openVolume(i, false);
        }
        if (this.absoluteLength != -1L && this.volumePositions.size() <= n) {
            return;
        }
        String string = this.cuttedVolumeFilename + MessageFormat.format("{0,number,000}", n);
        IInStream iInStream = this.archiveOpenVolumeCallback.getStream(string);
        if (iInStream == null) {
            this.absoluteLength = this.volumePositions.get(this.volumePositions.size() - 1);
            return;
        }
        this.currentInStream = iInStream;
        if (this.volumePositions.size() == n) {
            this.currentVolumeLength = this.currentInStream.seek(0L, 2);
            if (this.currentVolumeLength == 0L) {
                throw new RuntimeException("Volume " + n + " is empty");
            }
            this.volumePositions.add(this.volumePositions.get(n - 1) + this.currentVolumeLength);
            if (bl) {
                this.currentInStream.seek(0L, 0);
            }
        } else {
            this.currentVolumeLength = this.volumePositions.get(n) - this.volumePositions.get(n - 1);
        }
        if (bl) {
            this.currentVolumeOffset = 0L;
            this.absoluteOffset = this.volumePositions.get(n - 1);
        }
        this.currentIndex = n;
    }

    private void openVolumeToAbsoluteOffset() throws SevenZipException {
        int n = this.volumePositions.size() - 1;
        if (this.absoluteLength != -1L && this.absoluteOffset >= this.absoluteLength) {
            return;
        }
        while (this.volumePositions.get(n) > this.absoluteOffset) {
            --n;
        }
        if (n < this.volumePositions.size() - 1) {
            this.openVolume(n + 1, false);
            return;
        }
        do {
            this.openVolume(++n, false);
        } while ((this.absoluteLength == -1L || this.absoluteOffset < this.absoluteLength) && this.volumePositions.get(n) <= this.absoluteOffset);
    }

    public long seek(long l, int n) throws SevenZipException {
        long l2;
        boolean bl = false;
        switch (n) {
            case 0: {
                l2 = l;
                break;
            }
            case 1: {
                l2 = this.absoluteOffset + l;
                break;
            }
            case 2: {
                if (this.absoluteLength == -1L) {
                    this.openVolume(Integer.MAX_VALUE, false);
                    bl = true;
                }
                l2 = this.absoluteLength + l;
                break;
            }
            default: {
                throw new RuntimeException("Seek: unknown origin: " + n);
            }
        }
        if (l2 == this.absoluteOffset && !bl) {
            return l2;
        }
        this.absoluteOffset = l2;
        this.openVolumeToAbsoluteOffset();
        if (this.absoluteLength != -1L && this.absoluteLength <= this.absoluteOffset) {
            this.absoluteOffset = this.absoluteLength;
            return this.absoluteLength;
        }
        this.currentVolumeOffset = this.absoluteOffset - this.volumePositions.get(this.currentIndex - 1);
        this.currentInStream.seek(this.currentVolumeOffset, 0);
        return l2;
    }

    public int read(byte[] byArray) throws SevenZipException {
        if (this.absoluteLength != -1L && this.absoluteOffset >= this.absoluteLength) {
            return 0;
        }
        int n = this.currentInStream.read(byArray);
        this.absoluteOffset += (long)n;
        this.currentVolumeOffset += (long)n;
        if (this.currentVolumeOffset >= this.currentVolumeLength) {
            this.openVolume(this.currentIndex + 1, true);
        }
        return n;
    }
}

