/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import org.esa.snap.core.util.Guardian;

class TiffValueRangeChecker {
    private static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    private static final int UNSIGNED_SHORT_MAX = 65535;

    TiffValueRangeChecker() {
    }

    public static void checkValueTiffRational(long value, String name) {
        TiffValueRangeChecker.checkValue(value, name, 1L, 0xFFFFFFFFL);
    }

    public static void checkValueTiffLong(long value, String name) {
        TiffValueRangeChecker.checkValue(value, name, 0L, 0xFFFFFFFFL);
    }

    public static void checkValueTiffShort(int value, String name) {
        TiffValueRangeChecker.checkValue(value, name, 0L, 65535L);
    }

    private static void checkValue(long value, String name, long min, long max) {
        Guardian.assertWithinRange((String)name, (long)value, (long)min, (long)max);
    }
}

