/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RenderedOp;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlRIF
implements RenderedImageFactory {
    private static final String ENAME_PARAMETER = "parameter";
    private static final String ENAME_SOURCE = "source";
    private static final String ENAME_TARGET = "target";
    private static final String ENAME_OP = "op";
    private static final String ANAME_ID = "id";
    private static final String ANAME_REFID = "refid";

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderingHints) {
        URI location = (URI)paramBlock.getObjectParameter(0);
        HashMap<String, Object> configuration = (HashMap<String, Object>)paramBlock.getObjectParameter(1);
        if (configuration == null) {
            configuration = new HashMap<String, Object>();
        }
        try {
            return this.create(location, configuration, renderingHints);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private RenderedImage create(URI location, Map<String, Object> configuration, RenderingHints renderingHints) throws JDOMException, IOException, IllegalArgumentException {
        configuration = new HashMap<String, Object>(configuration);
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(location.toURL());
        Element rootElement = document.getRootElement();
        Map<String, Element> sourceMap = XmlRIF.getElementMap(rootElement, ENAME_SOURCE);
        Map<String, Element> parameterMap = XmlRIF.getElementMap(rootElement, ENAME_PARAMETER);
        Element targetElement = rootElement.getChild(ENAME_TARGET);
        return this.parseImage(targetElement, sourceMap, parameterMap, configuration, renderingHints, "rendered");
    }

    private RenderedOp parseImage(Element targetElement, Map<String, Element> definedSourceElements, Map<String, Element> definedParameterElements, Map<String, Object> configuration, RenderingHints renderHints, String modeName) {
        Element opElement = targetElement.getChild(ENAME_OP);
        String opName = opElement.getValue();
        ParameterBlockJAI parameterBlock = new ParameterBlockJAI(opName, modeName);
        this.parseSources(parameterBlock, targetElement, definedSourceElements, definedParameterElements, configuration, renderHints);
        this.parseParameters(parameterBlock, targetElement, definedParameterElements, configuration);
        return JAI.create((String)opName, (ParameterBlock)parameterBlock, (RenderingHints)renderHints);
    }

    private void parseSources(ParameterBlockJAI parameterBlock, Element targetElement, Map<String, Element> definedSourceElements, Map<String, Element> definedParameterElements, Map<String, Object> configuration, RenderingHints renderingHints) {
        List<Element> sourceElements = targetElement.getChildren(ENAME_SOURCE);
        for (int i = 0; i < sourceElements.size(); ++i) {
            Object source;
            Element sourceElement = sourceElements.get(i);
            String sourceName = sourceElement.getAttributeValue(ANAME_ID);
            String sourceId = sourceElement.getAttributeValue(ANAME_REFID);
            if (sourceId != null) {
                Element definedSourceElement;
                source = configuration.get(sourceId);
                if (source == null && (definedSourceElement = definedSourceElements.get(sourceId)) != null) {
                    source = this.parseImage(definedSourceElement, definedSourceElements, definedParameterElements, configuration, renderingHints, parameterBlock.getMode());
                    configuration.put(sourceId, source);
                }
            } else {
                source = this.parseImage(sourceElement, definedSourceElements, definedParameterElements, configuration, renderingHints, parameterBlock.getMode());
            }
            if (sourceName != null) {
                parameterBlock.setSource(sourceName, source);
                continue;
            }
            parameterBlock.setSource(source, i);
        }
    }

    private void parseParameters(ParameterBlockJAI parameterBlock, Element targetElement, Map<String, Element> definedParameterElements, Map<String, Object> configuration) {
        List<Element> parameterElements = targetElement.getChildren(ENAME_PARAMETER);
        for (int i = 0; i < parameterElements.size(); ++i) {
            Object parameterValue;
            String parameterId;
            Element parameterElement = parameterElements.get(i);
            String parameterName = parameterElement.getAttributeValue(ANAME_ID);
            if (parameterName == null) {
                String[] paramNames = parameterBlock.getParameterListDescriptor().getParamNames();
                if (i < paramNames.length) {
                    parameterName = paramNames[i];
                } else {
                    throw new IllegalArgumentException(MessageFormat.format("Operation ''{0}'': Unknown parameter #{1}'", parameterBlock.getOperationDescriptor().getName(), i));
                }
            }
            if ((parameterId = parameterElement.getAttributeValue(ANAME_REFID)) != null) {
                parameterValue = configuration.get(parameterId);
                if (parameterValue == null) {
                    Element definedParameterElement = definedParameterElements.get(parameterId);
                    parameterValue = this.parseParameterValue(parameterBlock, parameterName, definedParameterElement.getValue());
                    configuration.put(parameterId, parameterValue);
                }
            } else {
                parameterValue = this.parseParameterValue(parameterBlock, parameterName, parameterElement.getValue());
            }
            if (parameterName != null) {
                parameterBlock.setParameter(parameterName, parameterValue);
                continue;
            }
            parameterBlock.add(parameterValue);
        }
    }

    private static Map<String, Element> getElementMap(Element rootElement, String elementName) {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        List<Element> elements = rootElement.getChildren(elementName);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            String name = element.getAttributeValue(ANAME_ID);
            if (name == null) {
                throw new IllegalArgumentException(MessageFormat.format("Missing attribute ''{0}'' in element ''{1}''", ANAME_ID, elementName));
            }
            elementMap.put(name, element);
        }
        return elementMap;
    }

    private Object parseParameterValue(ParameterBlockJAI parameterBlock, String parameterName, String text) {
        ParameterListDescriptor descriptor = parameterBlock.getParameterListDescriptor();
        int parameterIndex = this.getParameterIndex(descriptor, parameterName);
        if (parameterIndex == -1) {
            throw new IllegalArgumentException(MessageFormat.format("Operation ''{0}'': Unknown parameter ''{1}''", parameterBlock.getOperationDescriptor().getName(), parameterName));
        }
        Class[] types = descriptor.getParamClasses();
        return this.parse(parameterBlock.getOperationDescriptor(), types[parameterIndex], text);
    }

    private int getParameterIndex(ParameterListDescriptor descriptor, String parameterName) {
        String[] names = descriptor.getParamNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        return -1;
    }

    private Object parse(OperationDescriptor operationDescriptor, Class type, String text) {
        if (type.equals(String.class)) {
            return text;
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.parseByte(text);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.parseShort(text);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.parseInt(text);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.parseLong(text);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.parseDouble(text);
        }
        if (type.equals(int[].class)) {
            return this.parseIntArray(text);
        }
        if (type.equals(float[].class)) {
            return this.parseFloatArray(text);
        }
        if (type.equals(double[].class)) {
            return this.parseDoubleArray(text);
        }
        if (type.equals(Interpolation.class)) {
            if ("INTERP_NEAREST".equals(text)) {
                return Interpolation.getInstance((int)0);
            }
            if ("INTERP_BILINEAR".equals(text)) {
                return Interpolation.getInstance((int)1);
            }
            if ("INTERP_BICUBIC".equals(text)) {
                return Interpolation.getInstance((int)2);
            }
            if ("INTERP_BICUBIC_2".equals(text)) {
                return Interpolation.getInstance((int)3);
            }
            throw new IllegalArgumentException("Unknown interpolation method: " + text);
        }
        if (EnumeratedParameter.class.isAssignableFrom(type)) {
            try {
                Field field = operationDescriptor.getClass().getField(text);
                field.setAccessible(true);
                Object value = field.get(operationDescriptor);
                return (EnumeratedParameter)value;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Enumerated value not found: " + text);
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }

    private int[] parseIntArray(String text) {
        String[] tokens = text.split(",");
        int[] value = new int[tokens.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Integer.parseInt(tokens[i]);
        }
        return value;
    }

    private float[] parseFloatArray(String text) {
        String[] tokens = text.split(",");
        float[] value = new float[tokens.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Float.parseFloat(tokens[i]);
        }
        return value;
    }

    private double[] parseDoubleArray(String text) {
        String[] tokens = text.split(",");
        double[] value = new double[tokens.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = Double.parseDouble(tokens[i]);
        }
        return value;
    }
}

