/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.BindingProblem;
import com.bc.ceres.swing.binding.BindingProblemListener;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.NonSI;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.ui.DecimalFormatter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

public class BoundsInputPanel {
    public static final String PROPERTY_WEST_BOUND = "westBound";
    public static final String PROPERTY_NORTH_BOUND = "northBound";
    public static final String PROPERTY_EAST_BOUND = "eastBound";
    public static final String PROPERTY_SOUTH_BOUND = "southBound";
    public static final String PROPERTY_PIXEL_SIZE_X = "pixelSizeX";
    public static final String PROPERTY_PIXEL_SIZE_Y = "pixelSizeY";
    private final BindingContext bindingContext;
    private final String enablePropertyKey;
    private JLabel pixelXUnit;
    private JLabel pixelYUnit;
    private JFormattedTextField pixelSizeXField;
    private JFormattedTextField pixelSizeYField;
    private Map<String, Double> unitMap;

    public BoundsInputPanel(BindingContext bindingContext, String enablePropertyKey) {
        this.bindingContext = bindingContext;
        this.enablePropertyKey = enablePropertyKey;
        this.unitMap = new HashMap<String, Double>();
        this.unitMap.put("\u00b0", 0.05);
        this.unitMap.put("m", 1000.0);
        this.unitMap.put("km", 1.0);
    }

    public JPanel createBoundsInputPanel(boolean disableUIProperty) {
        TableLayout layout = new TableLayout(9);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setTablePadding(3, 3);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setColumnWeightX(2, Double.valueOf(0.0));
        layout.setColumnWeightX(3, Double.valueOf(0.0));
        layout.setColumnWeightX(4, Double.valueOf(1.0));
        layout.setColumnWeightX(5, Double.valueOf(0.0));
        layout.setColumnWeightX(6, Double.valueOf(0.0));
        layout.setColumnWeightX(7, Double.valueOf(1.0));
        layout.setColumnWeightX(8, Double.valueOf(0.0));
        layout.setColumnPadding(2, new Insets(3, 0, 3, 12));
        layout.setColumnPadding(5, new Insets(3, 0, 3, 12));
        JPanel panel = new JPanel((LayoutManager)layout);
        DecimalFormatter decimalFormatter = new DecimalFormatter("###0.0##");
        this.pixelXUnit = new JLabel(NonSI.DEGREE_ANGLE.toString());
        this.pixelYUnit = new JLabel(NonSI.DEGREE_ANGLE.toString());
        panel.add(new JLabel("West:"));
        JFormattedTextField westLonField = new JFormattedTextField(decimalFormatter);
        westLonField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_WEST_BOUND, westLonField);
        this.bindingContext.bindEnabledState(PROPERTY_WEST_BOUND, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(westLonField);
        panel.add(new JLabel(NonSI.DEGREE_ANGLE.toString()));
        panel.add(new JLabel("East:"));
        JFormattedTextField eastLonField = new JFormattedTextField(decimalFormatter);
        eastLonField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_EAST_BOUND, eastLonField);
        this.bindingContext.bindEnabledState(PROPERTY_EAST_BOUND, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(eastLonField);
        panel.add(new JLabel(NonSI.DEGREE_ANGLE.toString()));
        panel.add(new JLabel("Pixel size X:"));
        this.pixelSizeXField = new JFormattedTextField(decimalFormatter);
        this.pixelSizeXField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_PIXEL_SIZE_X, this.pixelSizeXField);
        this.bindingContext.bindEnabledState(PROPERTY_PIXEL_SIZE_X, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(this.pixelSizeXField);
        panel.add(this.pixelXUnit);
        panel.add(new JLabel("North:"));
        JFormattedTextField northLatField = new JFormattedTextField(decimalFormatter);
        northLatField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_NORTH_BOUND, northLatField);
        this.bindingContext.bindEnabledState(PROPERTY_NORTH_BOUND, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(northLatField);
        panel.add(new JLabel(NonSI.DEGREE_ANGLE.toString()));
        panel.add(new JLabel("South:"));
        JFormattedTextField southLatField = new JFormattedTextField(decimalFormatter);
        southLatField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_SOUTH_BOUND, southLatField);
        this.bindingContext.bindEnabledState(PROPERTY_SOUTH_BOUND, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(southLatField);
        panel.add(new JLabel(NonSI.DEGREE_ANGLE.toString()));
        panel.add(new JLabel("Pixel size Y:"));
        this.pixelSizeYField = new JFormattedTextField(decimalFormatter);
        this.pixelSizeYField.setHorizontalAlignment(4);
        this.bindingContext.bind(PROPERTY_PIXEL_SIZE_Y, this.pixelSizeYField);
        this.bindingContext.bindEnabledState(PROPERTY_PIXEL_SIZE_Y, false, this.enablePropertyKey, (Object)disableUIProperty);
        panel.add(this.pixelSizeYField);
        panel.add(this.pixelYUnit);
        this.bindingContext.addProblemListener(new BindingProblemListener(){

            public void problemReported(BindingProblem problem, BindingProblem ignored) {
                boolean invalidBoundSet;
                String propertyName = problem.getBinding().getPropertyName();
                boolean bl = invalidBoundSet = propertyName.equals(BoundsInputPanel.PROPERTY_NORTH_BOUND) || propertyName.equals(BoundsInputPanel.PROPERTY_EAST_BOUND) || propertyName.equals(BoundsInputPanel.PROPERTY_SOUTH_BOUND) || propertyName.equals(BoundsInputPanel.PROPERTY_WEST_BOUND);
                if (invalidBoundSet) {
                    this.resetTextField(problem);
                }
            }

            private void resetTextField(BindingProblem problem) {
                problem.getBinding().getComponentAdapter().adjustComponents();
            }

            public void problemCleared(BindingProblem ignored) {
            }
        });
        return panel;
    }

    public void updatePixelUnit(CoordinateReferenceSystem crs) {
        String unitY;
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        String unitX = coordinateSystem.getAxis(0).getUnit().toString();
        if (!unitX.equals(this.pixelXUnit.getText())) {
            this.pixelXUnit.setText(unitX);
            this.pixelSizeXField.setValue(this.unitMap.get(unitX));
        }
        if (!(unitY = coordinateSystem.getAxis(1).getUnit().toString()).equals(this.pixelYUnit.getText())) {
            this.pixelYUnit.setText(unitY);
            this.pixelSizeYField.setValue(this.unitMap.get(unitY));
        }
    }
}

