/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed.attribute;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.indexed.attribute.AttributeIndexReader;
import org.geotools.data.shapefile.indexed.attribute.AttributeIndexWriter;

public class AttributeIndexSummary {
    public static final String SUMMARY_EXT = ".ids";
    public static final String INDEX_EXT = ".i";
    public static final DecimalFormat SUFFIX = new DecimalFormat("00");
    public static final int DEFAULT_CACHE_SIZE = 0x8000000;
    protected URL summaryURL = null;
    protected String filename = null;
    protected int cacheSize;

    public AttributeIndexSummary(URL shpURL) throws MalformedURLException, IOException {
        this(shpURL, 0x8000000);
    }

    public AttributeIndexSummary(URL shpURL, int cacheSize) throws MalformedURLException, IOException {
        try {
            this.filename = URLDecoder.decode(shpURL.toString(), "US-ASCII");
            this.filename = this.filename.substring(0, this.filename.lastIndexOf(".shp"));
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + shpURL + " cause " + use.getMessage());
        }
        int indexslash = this.filename.lastIndexOf(File.pathSeparator);
        if (indexslash == -1) {
            indexslash = 0;
        }
        this.summaryURL = new URL(this.filename + SUMMARY_EXT);
        DataUtilities.urlToFile((URL)this.summaryURL).createNewFile();
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String attribute) throws FileNotFoundException, IOException {
        URL url = this.getIndexURL(attribute);
        if (url == null) {
            this.addIndex(attribute);
            url = this.getIndexURL(attribute);
        }
        AttributeIndexSummary attributeIndexSummary = this;
        synchronized (attributeIndexSummary) {
            File f = DataUtilities.urlToFile((URL)url);
            if (f.exists() && !f.delete()) {
                throw new IOException("File index cannot be deleted. Probably it's locked.");
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            FileChannel writeChannel = raf.getChannel();
            AttributeIndexWriter indexWriter = new AttributeIndexWriter(attribute, writeChannel, this.getDBFChannel(), this.cacheSize);
            indexWriter.buildIndex();
        }
    }

    public AttributeIndexReader getIndex(String attribute) throws FileNotFoundException, IOException {
        URL url = this.getIndexURL(attribute);
        if (url == null) {
            return null;
        }
        File f = DataUtilities.urlToFile((URL)url);
        if (!f.exists()) {
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(DataUtilities.urlToFile((URL)url), "r");
        return new AttributeIndexReader(attribute, raf.getChannel());
    }

    public boolean hasIndex(String attribute) throws FileNotFoundException, IOException {
        URL url = this.getIndexURL(attribute);
        if (url == null) {
            return false;
        }
        return DataUtilities.urlToFile((URL)url).exists();
    }

    public boolean existsIndex(String attribute) throws FileNotFoundException, IOException {
        URL url = this.getIndexURL(attribute);
        if (url == null) {
            return false;
        }
        File f = DataUtilities.urlToFile((URL)url);
        return f.exists();
    }

    protected URL getIndexURL(String attribute) throws FileNotFoundException, IOException {
        File f = DataUtilities.urlToFile((URL)this.summaryURL);
        BufferedReader in = new BufferedReader(new FileReader(f));
        int count = 0;
        while (in.ready()) {
            String s = in.readLine();
            ++count;
            if (!s.equals(attribute)) continue;
            return new URL(this.filename + INDEX_EXT + SUFFIX.format(count));
        }
        return null;
    }

    protected synchronized void addIndex(String attribute) throws FileNotFoundException, IOException {
        File f = DataUtilities.urlToFile((URL)this.summaryURL);
        PrintWriter out = new PrintWriter(new FileWriter(f, true));
        out.println(attribute);
        out.flush();
        out.close();
    }

    protected FileChannel getDBFChannel() throws FileNotFoundException, MalformedURLException {
        URL url = new URL(this.filename + ".dbf");
        File f = DataUtilities.urlToFile((URL)url);
        if (!f.exists()) {
            url = new URL(this.filename + ".DBF");
        }
        if (!(f = DataUtilities.urlToFile((URL)url)).exists()) {
            throw new FileNotFoundException("DBF file not found");
        }
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        return raf.getChannel();
    }
}

