/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeFileIndexer
implements FileWriter {
    private static final Logger LOGGER = Logging.getLogger(ShapeFileIndexer.class);
    private int max = -1;
    private int leafSize = 16;
    private String byteOrder;
    private boolean interactive = false;
    private ShpFiles shpFiles;

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || (args.length - 1) % 2 != 0) {
            ShapeFileIndexer.usage();
        }
        long start = System.currentTimeMillis();
        ShapeFileIndexer idx = new ShapeFileIndexer();
        idx.interactive = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                ++i;
                continue;
            }
            if (args[i].equals("-M")) {
                idx.setMax(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-s")) {
                idx.setLeafSize(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-b")) {
                idx.setByteOrder(args[++i]);
                continue;
            }
            if (!args[i].toLowerCase().endsWith(".shp")) {
                System.out.println("File extension must be '.shp'");
                System.exit(1);
            }
            idx.setShapeFileName(new ShpFiles(args[i]));
        }
        try {
            System.out.print("Indexing ");
            int cnt = idx.index(true, (ProgressListener)new NullProgressListener());
            System.out.println();
            System.out.print(cnt + " features indexed ");
            System.out.println("in " + (System.currentTimeMillis() - start) + "ms.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            ShapeFileIndexer.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: ShapeFileIndexer -t <QIX> [-M <max tree depth>] [-b <byte order NL | NM>] <shape file>[-s <max number of items in a leaf>]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("\t-t Index type: RTREE or QUADTREE");
        System.out.println();
        System.out.println("Following options apllies only to QUADTREE:");
        System.out.println("\t-b byte order to use: NL = LSB; NM = MSB (default)");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int index(boolean verbose, ProgressListener listener) throws MalformedURLException, IOException, TreeException, StoreException, LockTimeoutException {
        if (this.shpFiles == null) {
            throw new IOException("You have to set a shape file name!");
        }
        int cnt = 0;
        ShapefileReader reader = null;
        StorageFile storage = this.shpFiles.getStorageFile(ShpFileType.QIX);
        File treeFile = storage.getFile();
        try {
            reader = new ShapefileReader(this.shpFiles, true, false, new GeometryFactory());
            if (this.max == -1) {
                int features = reader.getCount(0);
                this.max = 1;
                int nodes = 1;
                while (nodes * this.leafSize < features) {
                    ++this.max;
                    nodes *= 4;
                }
                if (this.max < 10) {
                    this.max = 10;
                }
                reader.close();
                reader = new ShapefileReader(this.shpFiles, true, false, new GeometryFactory());
            }
            cnt = this.buildQuadTree(reader, treeFile, verbose);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        storage.replaceOriginal();
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildQuadTree(ShapefileReader reader, File file, boolean verbose) throws IOException, StoreException {
        LOGGER.fine("Building quadtree spatial index with depth " + this.max + " for file " + file.getAbsolutePath());
        byte order = 0;
        if (this.byteOrder == null || this.byteOrder.equalsIgnoreCase("NM")) {
            order = 2;
        } else if (this.byteOrder.equalsIgnoreCase("NL")) {
            order = 1;
        } else {
            throw new StoreException("Asked byte order '" + this.byteOrder + "' must be 'NL' or 'NM'!");
        }
        IndexFile shpIndex = new IndexFile(this.shpFiles, false);
        QuadTree tree = null;
        int cnt = 0;
        int numRecs = shpIndex.getRecordCount();
        ShapefileHeader header = reader.getHeader();
        Envelope bounds = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
        tree = new QuadTree(numRecs, this.max, bounds, shpIndex);
        try {
            ShapefileReader.Record rec = null;
            while (reader.hasNext()) {
                rec = reader.nextRecord();
                tree.insert(cnt++, new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY));
                if (verbose && cnt % 1000 == 0) {
                    System.out.print('.');
                }
                if (cnt % 100000 != 0) continue;
                System.out.print('\n');
            }
            if (verbose) {
                System.out.println("done");
            }
            FileSystemIndexStore store = new FileSystemIndexStore(file, order);
            if (this.leafSize > 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Optimizing the tree (this might take some time)");
                }
                this.optimizeTree(tree, tree.getRoot(), 0, reader, shpIndex);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Tree optimized");
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                this.printStats(tree);
            }
            store.store(tree);
        }
        finally {
            tree.close();
        }
        return cnt;
    }

    private Node optimizeTree(QuadTree tree, Node node, int level, ShapefileReader reader, IndexFile index) throws StoreException, IOException {
        int i;
        int i2;
        if (node.getNumShapeIds() > this.leafSize && node.getNumSubNodes() == 0 && level < this.max * 2) {
            int[] shapeIds = node.getShapesId();
            int numShapesId = node.getNumShapeIds();
            node.clean();
            int extraLevels = 2;
            int nodes = 4;
            while (nodes * this.leafSize < numShapesId) {
                ++extraLevels;
                nodes *= 4;
            }
            for (int i3 = 0; i3 < numShapesId; ++i3) {
                int shapeId = shapeIds[i3];
                int offset = index.getOffsetInBytes(shapeId);
                reader.goTo(offset);
                ShapefileReader.Record rec = reader.nextRecord();
                Envelope env = new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY);
                tree.insert(node, shapeId, env, extraLevels);
            }
        }
        node.pack();
        for (i2 = 0; i2 < node.getNumSubNodes(); ++i2) {
            this.optimizeTree(tree, node.getSubNode(i2), level + 1, reader, index);
        }
        i2 = 0;
        while (i2 < node.getNumSubNodes()) {
            Node child = node.getSubNode(i2);
            if (child != null && child.getNumShapeIds() == 0 && child.getNumSubNodes() == 0) {
                node.removeSubNode(child);
                continue;
            }
            ++i2;
        }
        if (node.getNumSubNodes() == 1 && node.getNumShapeIds() == 0) {
            Node subnode = node.getSubNode(0);
            node.clearSubNodes();
            node.setShapesId(subnode);
            node.setBounds(subnode.getBounds());
            for (i = 0; i < subnode.getNumSubNodes(); ++i) {
                node.addSubNode(subnode.getSubNode(i));
            }
        } else {
            int i4;
            Envelope bounds = new Envelope();
            if (node.getNumShapeIds() > 0) {
                int[] shapeIds = node.getShapesId();
                for (i4 = 0; i4 < shapeIds.length; ++i4) {
                    int shapeId = shapeIds[i4];
                    int offset = index.getOffsetInBytes(shapeId);
                    reader.goTo(offset);
                    ShapefileReader.Record rec = reader.nextRecord();
                    Envelope env = new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY);
                    bounds.expandToInclude(env);
                }
            }
            if (node.getNumSubNodes() > 0) {
                for (i = 0; i < node.getNumSubNodes(); ++i) {
                    bounds.expandToInclude(node.getSubNode(i).getBounds());
                }
            }
            node.setBounds(bounds);
            int count = node.getNumShapeIds();
            for (i4 = 0; i4 < node.getNumSubNodes(); ++i4) {
                Node child = node.getSubNode(i4);
                if (child.getNumSubNodes() > 0) {
                    count = Integer.MAX_VALUE;
                    break;
                }
                count += child.getNumShapeIds();
            }
            if (count < this.leafSize) {
                for (i4 = 0; i4 < node.getNumSubNodes(); ++i4) {
                    Node child = node.getSubNode(i4);
                    int[] shapesId = child.getShapesId();
                    for (int j = 0; j < child.getNumShapeIds(); ++j) {
                        node.addShapeId(shapesId[j]);
                    }
                }
                node.clearSubNodes();
            }
        }
        return node;
    }

    private void printStats(QuadTree tree) throws StoreException {
        HashMap<Integer, Integer> stats = new HashMap<Integer, Integer>();
        this.gatherStats(tree.getRoot(), stats);
        ArrayList nums = new ArrayList(stats.keySet());
        Collections.sort(nums);
        LOGGER.log(Level.FINE, "Index statistics");
        for (Integer num : nums) {
            LOGGER.log(Level.FINE, num + " -> " + stats.get(num));
        }
    }

    void gatherStats(Node node, Map<Integer, Integer> stats) throws StoreException {
        int num = node.getNumShapeIds();
        Integer count = stats.get(num);
        if (count == null) {
            stats.put(num, 1);
        } else {
            stats.put(num, count + 1);
        }
        for (int i = 0; i < node.getNumSubNodes(); ++i) {
            this.gatherStats(node.getSubNode(i), stats);
        }
    }

    public void setMax(int i) {
        this.max = i;
    }

    public void setShapeFileName(ShpFiles shpFiles) {
        this.shpFiles = shpFiles;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }

    public int getLeafSize() {
        return this.leafSize;
    }

    public void setLeafSize(int leafSize) {
        this.leafSize = leafSize;
    }
}

