/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class FileLandCoverModelDescriptor
extends AbstractLandCoverModelDescriptor {
    private final File file;

    public FileLandCoverModelDescriptor(File file) {
        this.remotePath = null;
        this.name = file.getName();
        this.file = file;
        this.NO_DATA_VALUE = -9999.0;
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, new File[]{this.file}, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return this.file.getName();
    }

    @Override
    public int getDataType() {
        return 30;
    }
}

